/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.util.Observer;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.data.Interval;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.DragEventManager;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ObservableForObject;

public class ReferenceFrame {
    private static Logger log = Logger.getLogger(ReferenceFrame.class);
    public static int binsPerTile = 700;
    private String name;
    int pixelX;
    protected int widthInPixels;
    protected String chrName = "chrAll";
    private int minZoom;
    protected int zoom = this.minZoom = 0;
    public static int maxZoom = 23;
    private int nTiles = 1;
    private double maxPixel;
    protected double origin = 0.0;
    protected double locationScale;
    private double minScale = 0.07142857142857142;
    protected boolean locationScaleValid = false;
    protected Locus initialLocus;
    protected int setEnd = 0;
    protected ObservableForObject<String> chromoObservable;

    public ReferenceFrame(String name) {
        this.name = name;
        Genome genome = this.getGenome();
        this.chrName = genome == null ? "" : genome.getHomeChromosome();
        this.chromoObservable = new ObservableForObject<String>(this.chrName);
    }

    public ReferenceFrame(ReferenceFrame otherFrame) {
        this.chrName = otherFrame.chrName;
        this.initialLocus = otherFrame.initialLocus;
        this.locationScale = otherFrame.locationScale;
        this.locationScaleValid = otherFrame.locationScaleValid;
        this.maxPixel = otherFrame.maxPixel;
        this.minScale = otherFrame.minScale;
        this.minZoom = otherFrame.minZoom;
        this.name = otherFrame.name;
        this.nTiles = otherFrame.nTiles;
        this.origin = otherFrame.origin;
        this.pixelX = otherFrame.pixelX;
        this.setEnd = otherFrame.setEnd;
        this.widthInPixels = otherFrame.widthInPixels;
        this.zoom = otherFrame.zoom;
        this.chromoObservable = new ObservableForObject<String>(this.chrName);
    }

    public synchronized void setBounds(int x, int w) {
        this.pixelX = x;
        if (w != this.widthInPixels) {
            this.widthInPixels = w;
            this.computeLocationScale();
        }
    }

    public int getMidpoint() {
        return this.pixelX + this.widthInPixels / 2;
    }

    public void computeMaxZoom() {
        Genome genome = this.getGenome();
        if (genome != null && this.chrName != null && genome.getChromosome(this.chrName) != null) {
            if (this.chrName.equals("All")) {
                maxZoom = 0;
            } else {
                int chrLength = genome.getChromosome(this.chrName).getLength();
                maxZoom = (int)(Math.log((double)chrLength / 50.0) / Globals.log2) + 1;
            }
            if (this.zoom > maxZoom) {
                this.zoomTo(maxZoom);
            }
        }
    }

    private void zoomTo(int newZoom) {
        this.zoom = Math.min(maxZoom, newZoom);
        this.nTiles = (int)Math.pow(2.0, Math.max(this.minZoom, this.zoom));
        this.maxPixel = this.getTilesTimesBinsPerTile();
        this.invalidateLocationScale();
        IGV.repaintPanelsHeadlessSafe();
    }

    public void setZoom(int z) {
        if (z > 0) {
            this.zoom = z;
        }
    }

    public void incrementZoom(int increment) {
        double currentCenter = this.getGenomeCenterPosition();
        this.zoomBy(increment, currentCenter);
    }

    public void zoomAndCenterAdjusted(int newZoom) {
        double currentCenter = this.getGenomeCenterPosition();
        this.zoomTo(newZoom, currentCenter);
    }

    protected double getGenomeCenterPosition() {
        return this.origin + (double)(this.widthInPixels / 2) * this.getScale();
    }

    public synchronized void zoomBy(int zoomFactor, double newCenter) {
        if (FrameManager.isGeneListMode()) {
            double f = Math.pow(2.0, zoomFactor);
            this.setLocationScale(Math.max(this.minScale, this.getScale() / f));
            double newOrigin = Math.round(newCenter - (double)(this.widthInPixels / 2) * this.getScale());
            this.setOrigin(newOrigin);
            double end = this.setEnd > 0 ? (double)this.setEnd : this.getEnd();
            this.imputeZoom(this.origin, end);
            this.setEnd = -1;
        } else {
            int newZoom = Math.max(0, this.zoom + zoomFactor);
            this.zoomTo(newZoom, newCenter);
        }
    }

    public synchronized void zoomTo(int newZoom, double newCenter) {
        if (this.chrName.equals("All")) {
            this.chrName = this.getGenome().getHomeChromosome();
        }
        if (this.chrName.equals("All")) {
            this.jumpToChromosomeForGenomeLocation(newCenter);
            IGV.getInstance().chromosomeChangeEvent(this.chrName);
        } else if (this.zoom != newZoom) {
            this.zoomTo(newZoom);
            double newLocationScale = this.getScale();
            double newOrigin = Math.round(newCenter - (double)(this.widthInPixels / 2) * newLocationScale);
            this.setOrigin(newOrigin);
        }
        this.recordHistory();
        DragEventManager.getInstance().dragStopped();
    }

    public void recordHistory() {
        IGV.getInstance().getSession().getHistory().push(this.getFormattedLocusString(), this.zoom);
    }

    private void jumpToChromosomeForGenomeLocation(double locationMB) {
        double startMB = 0.0;
        for (String chr : this.getGenome().getChromosomeNames()) {
            double endMB = startMB + (double)this.getGenome().getChromosome(chr).getLength() / 1000.0;
            if (locationMB > startMB && locationMB <= endMB) {
                this.setChromosomeName(chr);
                break;
            }
            startMB = endMB;
        }
    }

    public void shiftOriginPixels(int delta) {
        double shiftBP = (double)delta * this.getScale();
        this.setOrigin(this.origin + shiftBP);
    }

    public void snapToGrid() {
        this.setOrigin(Math.round(this.origin));
    }

    public void centerOnLocation(String chr, double chrLocation) {
        if (!this.chrName.equals(chr)) {
            this.chrName = chr;
            this.computeMaxZoom();
            if (this.zoom > maxZoom) {
                this.zoomTo(maxZoom);
            }
        }
        this.centerOnLocation(chrLocation);
    }

    public void centerOnLocation(double chrLocation) {
        double windowWidth = (double)this.widthInPixels * this.getScale() / 2.0;
        this.setOrigin(Math.round(chrLocation - windowWidth));
        this.recordHistory();
    }

    public boolean windowAtEnd() {
        double windowLengthBP = (double)this.widthInPixels * this.getScale();
        return this.origin + windowLengthBP + 1.0 > (double)this.getChromosomeLength();
    }

    public void setOrigin(double position) {
        this.setOrigin(position, true);
    }

    public void setOrigin(double position, boolean repaint) {
        int windowLengthBP = (int)((double)this.widthInPixels * this.getScale());
        double newOrigin = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_SOFT_CLIPPED") ? Math.max(-1000.0, Math.min(position, (double)(this.getChromosomeLength() + 1000 - windowLengthBP))) : Math.max(0.0, Math.min(position, (double)(this.getChromosomeLength() - windowLengthBP)));
        this.origin = newOrigin;
        if (repaint) {
            IGV.repaintPanelsHeadlessSafe();
        }
    }

    public void jumpTo(String chr, int start, int end) {
        Locus locus = new Locus(chr, start, end);
        this.jumpTo(locus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jumpTo(Locus locus) {
        Chromosome chromosome;
        String chr = locus.getChr();
        int start = locus.getStart();
        int end = locus.getEnd();
        Genome genome = this.getGenome();
        if (chr != null && genome.getChromosome(chr) == null && !chr.contains("All")) {
            MessageUtils.showMessage(chr + " is not a valid chromosome.");
            return;
        }
        this.initialLocus = locus;
        Chromosome chromosome2 = chromosome = genome == null ? null : genome.getChromosome(chr);
        if (chromosome != null) {
            end = Math.min(chromosome.getLength(), end);
        }
        ReferenceFrame referenceFrame = this;
        synchronized (referenceFrame) {
            this.chrName = chr;
            if (start >= 0) {
                this.imputeZoom(start, end);
                if (this.widthInPixels > 0) {
                    this.setLocationScale((double)(end - start) / (double)this.widthInPixels);
                }
                this.setEnd = locus.getEnd();
                this.origin = start;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Data panel width = " + this.widthInPixels);
            log.debug("New start = " + (int)this.origin);
            log.debug("New end = " + (int)this.getEnd());
            log.debug("New center = " + (int)this.getCenter());
            log.debug("Scale = " + this.locationScale);
        }
        IGV.repaintPanelsHeadlessSafe();
    }

    protected void imputeZoom(double start, double end) {
        int z = (int)(Math.log((double)this.getChromosomeLength() / (end - start)) / Globals.log2) + 1;
        if (z != this.zoom) {
            this.zoom = Math.min(maxZoom, Math.max(this.minZoom, z));
            this.nTiles = (int)Math.pow(2.0, this.zoom);
            this.maxPixel = this.getTilesTimesBinsPerTile();
        }
        if (IGV.hasInstance()) {
            IGV.getInstance().repaintStatusAndZoomSlider();
        }
    }

    protected Genome getGenome() {
        return GenomeManager.getInstance().getCurrentGenome();
    }

    public double getOrigin() {
        return this.origin;
    }

    public double getCenter() {
        return this.origin + this.getScale() * (double)this.widthInPixels / 2.0;
    }

    public double getEnd() {
        return this.origin + this.getScale() * (double)this.widthInPixels;
    }

    public int getZoom() {
        return this.zoom;
    }

    public int getMaxZoom() {
        return maxZoom;
    }

    public int getAdjustedZoom() {
        return this.zoom - this.minZoom;
    }

    public double getMaxPixel() {
        return this.maxPixel;
    }

    public void setChromosomeName(String name, boolean force) {
        if (this.chrName == null || !name.equals(this.chrName) || force) {
            this.chrName = name;
            this.origin = 0.0;
            this.setEnd = -1;
            this.zoomTo(0);
            this.computeMaxZoom();
            this.chromoObservable.setChangedAndNotify();
        }
    }

    public void addObserver(Observer observer) {
        this.chromoObservable.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.chromoObservable.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.chromoObservable.deleteObservers();
    }

    public void setChromosomeName(String name) {
        this.setChromosomeName(name, false);
    }

    public String getChrName() {
        return this.chrName;
    }

    public int getWidthInPixels() {
        return this.widthInPixels;
    }

    public synchronized double getScale() {
        if (this.locationScale <= 0.0 || !this.locationScaleValid) {
            this.computeLocationScale();
        }
        return this.locationScale;
    }

    public void invalidateLocationScale() {
        this.locationScaleValid = false;
    }

    private synchronized void computeLocationScale() {
        Genome genome = this.getGenome();
        if (genome != null) {
            if (this.setEnd > 0 && this.widthInPixels > 0) {
                this.setLocationScale(((double)this.setEnd - this.origin) / (double)this.widthInPixels);
                this.imputeZoom(this.origin, this.setEnd);
                this.setEnd = -1;
            } else {
                this.computeMinZoom();
                double virtualPixelSize = this.getTilesTimesBinsPerTile();
                double nPixel = Math.max(virtualPixelSize, (double)this.widthInPixels);
                this.setLocationScale((double)this.getChromosomeLength() / nPixel);
            }
        }
    }

    protected void computeMinZoom() {
        if (this.chrName.equals("All")) {
            this.minZoom = 0;
        } else {
            this.minZoom = Math.max(0, (int)(Math.log(this.widthInPixels / binsPerTile) / Globals.log2));
            if (this.zoom < this.minZoom) {
                this.zoom = this.minZoom;
                this.nTiles = (int)Math.pow(2.0, this.zoom);
                this.maxPixel = this.getTilesTimesBinsPerTile();
            }
        }
    }

    public double getChromosomePosition(int screenPosition) {
        return this.origin + this.getScale() * (double)screenPosition;
    }

    public int getScreenPosition(double chromosomePosition) {
        return (int)((chromosomePosition - this.origin) / this.getScale());
    }

    public Chromosome getChromosome() {
        Genome genome = this.getGenome();
        if (genome == null) {
            return null;
        }
        return genome.getChromosome(this.chrName);
    }

    public int getChromosomeLength() {
        Genome genome = this.getGenome();
        if (genome == null) {
            return 1;
        }
        if (this.chrName.equals("All")) {
            return (int)(genome.getLength() / 1000L);
        }
        if (this.getChromosome() == null) {
            log.error("Null chromosome: " + this.chrName);
            if (genome == null || genome.getChromosomes().size() == 0) {
                return 1;
            }
            return genome.getChromosomes().iterator().next().getLength();
        }
        return this.getChromosome().getLength();
    }

    public double getTilesTimesBinsPerTile() {
        return (double)this.nTiles * (double)binsPerTile;
    }

    public String getFormattedLocusString() {
        if (this.zoom == 0) {
            return this.getChrName();
        }
        Range range = this.getCurrentRange();
        return Locus.getFormattedLocusString(range.getChr(), range.getStart(), range.getEnd());
    }

    public Range getCurrentRange() {
        int start = 0;
        int end = this.widthInPixels;
        int startLoc = (int)this.getChromosomePosition(start) + 1;
        int endLoc = (int)this.getChromosomePosition(end);
        Range range = new Range(this.getChrName(), startLoc, endLoc);
        return range;
    }

    protected synchronized void setLocationScale(double locationScale) {
        if (log.isDebugEnabled()) {
            log.debug("Set location scale: " + locationScale + "  origin=" + this.origin);
        }
        this.locationScale = locationScale;
        this.locationScaleValid = true;
    }

    public void reset() {
        this.jumpTo(FrameManager.getLocus(this.name));
    }

    public String getName() {
        return this.name;
    }

    public Locus getInitialLocus() {
        return this.initialLocus;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public boolean isExomeMode() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean overlaps(Interval interval) {
        return this.getChrName().equals(interval.getChr()) && this.getOrigin() <= (double)interval.getEnd() && this.getEnd() >= (double)interval.getStart();
    }

    public static class Range {
        private String chr;
        private int start;
        private int end;

        public Range(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
        }

        public String getChr() {
            return this.chr;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getLength() {
            return this.end - this.start;
        }
    }
}

