/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.maf.MAFLocalReader;
import org.broad.igv.maf.MAFReader;
import org.broad.igv.maf.MAFTile;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ParsingUtils;

public class MAFListReader
implements MAFReader {
    private static Logger log = Logger.getLogger(MAFListReader.class);
    List<String> chrNames;
    Map<String, String> filenameMap;
    Map<String, MAFLocalReader> readerMap;

    public MAFListReader(String mappingFile) throws IOException {
        this.loadDictionaryFile(mappingFile);
        this.readerMap = new HashMap<String, MAFLocalReader>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDictionaryFile(String mappingFile) throws IOException {
        this.chrNames = new ArrayList<String>();
        this.filenameMap = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(mappingFile);
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("#")) continue;
                String[] tokens = Globals.tabPattern.split(nextLine, -1);
                if (tokens.length != 2) {
                    log.info("Skipping line: " + nextLine);
                    continue;
                }
                String chr = tokens[0];
                String fname = tokens[1];
                String fullPath = FileUtils.getAbsolutePath(fname, mappingFile);
                this.filenameMap.put(chr, fullPath);
                this.chrNames.add(chr);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    @Override
    public MAFTile loadTile(String chr, int start, int end, List<String> species) {
        MAFLocalReader reader = this.getReader(chr);
        return reader == null ? null : reader.loadTile(chr, start, end, species);
    }

    private MAFLocalReader getReader(final String chr) {
        MAFLocalReader reader = this.readerMap.get(chr);
        if (reader == null) {
            final String path = this.filenameMap.get(chr);
            if (path == null) {
                log.info("No MAF file found for chromosome: " + chr);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MAFLocalReader reader = new MAFLocalReader(path);
                            MAFListReader.this.readerMap.put(chr, reader);
                            IGV.getInstance().repaintDataAndHeaderPanels();
                        }
                        catch (Exception e) {
                            log.error("Error loading MAF reader (" + path + "):  ", e);
                            MessageUtils.showMessage("Error loading MAF file: " + e.getMessage());
                        }
                    }
                };
                LongRunningTask.submit(runnable);
            }
        }
        return reader;
    }

    @Override
    public List<String> getChrNames() {
        return this.chrNames;
    }
}

