/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.runtime;

import java.util.IdentityHashMap;

public class ContractContext {
    private static final int ENTERED_DEFAULT_SIZE = 100;
    static ThreadLocal<ContractContext> context = new ThreadLocal<ContractContext>(){

        @Override
        protected ContractContext initialValue() {
            return new ContractContext();
        }
    };
    protected boolean busy;
    protected IdentityHashMap<Object, Void> entered = new IdentityHashMap(100);

    protected ContractContext() {
    }

    public boolean tryEnterContract() {
        if (this.busy) {
            return false;
        }
        this.busy = true;
        return true;
    }

    public void leaveContract() {
        this.busy = false;
    }

    public boolean tryEnter(Object object) {
        if (this.entered.containsKey(object)) {
            return false;
        }
        this.entered.put(object, null);
        return true;
    }

    public void leave(Object object) {
        this.entered.remove(object);
    }

    public void clear() {
        this.busy = false;
    }
}

