/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementVisitor;
import com.google.java.contract.core.model.GenericElementModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.util.Elements;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Invariant(value={"getExceptions() != null", "isConstructor() == (returnType == null)"})
public class MethodModel
extends GenericElementModel {
    protected Set<TypeName> exceptions;
    protected TypeName returnType;
    protected boolean variadic;

    @Requires(value={"kind != null", "kind.isMember() && kind != ElementKind.FIELD", "kind != ElementKind.CONSTRUCTOR", "name != null", "returnType != null"})
    public MethodModel(ElementKind elementKind, String string, TypeName typeName) {
        super(elementKind, string);
        this.exceptions = new HashSet<TypeName>();
        this.returnType = typeName;
        this.variadic = false;
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    public MethodModel(MethodModel methodModel) {
        super(methodModel);
        this.exceptions = new HashSet<TypeName>(methodModel.exceptions);
        this.returnType = methodModel.returnType;
        this.variadic = false;
    }

    @Override
    public MethodModel clone() {
        return new MethodModel(this);
    }

    public MethodModel() {
        super(ElementKind.CONSTRUCTOR, "<init>");
        this.exceptions = new HashSet<TypeName>();
        this.returnType = null;
        this.variadic = false;
    }

    public Set<? extends TypeName> getExceptions() {
        return Collections.unmodifiableSet(this.exceptions);
    }

    @Requires(value={"exception != null"})
    @Ensures(value={"getExceptions().contains(exception)"})
    public void addException(TypeName typeName) {
        this.exceptions.add(typeName);
    }

    @Requires(value={"exception != null"})
    @Ensures(value={"!getExceptions().contains(exception)"})
    public void removeException(TypeName typeName) {
        this.exceptions.remove(typeName);
    }

    @Requires(value={"!isConstructor()"})
    @Ensures(value={"result != null"})
    public TypeName getReturnType() {
        return this.returnType;
    }

    @Requires(value={"!isConstructor()", "type != null"})
    public void setReturnType(TypeName typeName) {
        this.returnType = typeName;
    }

    public boolean isVariadic() {
        return this.variadic;
    }

    public void setVariadic(boolean bl) {
        this.variadic = bl;
    }

    public boolean isConstructor() {
        return this.kind == ElementKind.CONSTRUCTOR;
    }

    @Ensures(value={"result != null"})
    public List<? extends VariableModel> getParameters() {
        return Elements.filter(this.getEnclosedElements(), VariableModel.class, ElementKind.PARAMETER);
    }

    @Requires(value={"param != null", "param.getKind() == ElementKind.PARAMETER"})
    @Ensures(value={"getEnclosedElements().contains(param)", "getParameters().contains(param)"})
    public void addParameter(VariableModel variableModel) {
        this.addEnclosedElement(variableModel);
    }

    @Requires(value={"param != null", "param.getKind() == ElementKind.PARAMETER"})
    @Ensures(value={"!getEnclosedElements().contains(param)", "!getParameters().contains(param)"})
    public void removeParameter(VariableModel variableModel) {
        this.removeEnclosedElement(variableModel);
    }

    @Override
    public void accept(ElementVisitor elementVisitor) {
        elementVisitor.visitMethod(this);
    }

    @Override
    public EnumSet<ElementKind> getAllowedEnclosedKinds() {
        EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.PARAMETER, ElementKind.REQUIRES, ElementKind.ENSURES, ElementKind.THROW_ENSURES);
        enumSet.addAll(super.getAllowedEnclosedKinds());
        return enumSet;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MethodModel)) {
            return false;
        }
        MethodModel methodModel = (MethodModel)object;
        if (!methodModel.getSimpleName().equals(this.getSimpleName())) {
            return false;
        }
        List<? extends VariableModel> list = this.getParameters();
        List<? extends VariableModel> list2 = methodModel.getParameters();
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator<? extends VariableModel> iterator = list.iterator();
        Iterator<? extends VariableModel> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getType().equals(iterator2.next().getType())) continue;
            return false;
        }
        return methodModel.getEnclosingElement().equals(this.getEnclosingElement());
    }
}

