/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import org.apache.log4j.Logger;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.BaseAlignmentCounts;

public class DenseAlignmentCounts
extends BaseAlignmentCounts {
    private static Logger log = Logger.getLogger(DenseAlignmentCounts.class);
    int[] posA;
    int[] posT;
    int[] posC;
    int[] posG;
    int[] posN;
    int[] negA;
    int[] negT;
    int[] negC;
    int[] negG;
    int[] negN;
    int[] qA;
    int[] qT;
    int[] qC;
    int[] qG;
    int[] qN;
    int[] posTotal;
    int[] negTotal;
    int[] del;
    int[] ins;
    private int[] totalQ;
    private int maxCount = 0;

    public DenseAlignmentCounts(int start, int end, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        super(start, end, bisulfiteContext);
        int nPts = end - start;
        this.posA = new int[nPts];
        this.posT = new int[nPts];
        this.posC = new int[nPts];
        this.posG = new int[nPts];
        this.posN = new int[nPts];
        this.posTotal = new int[nPts];
        this.negA = new int[nPts];
        this.negT = new int[nPts];
        this.negC = new int[nPts];
        this.negG = new int[nPts];
        this.negN = new int[nPts];
        this.negTotal = new int[nPts];
        this.qA = new int[nPts];
        this.qT = new int[nPts];
        this.qC = new int[nPts];
        this.qG = new int[nPts];
        this.qN = new int[nPts];
        this.del = new int[nPts];
        this.ins = new int[nPts];
        this.totalQ = new int[nPts];
    }

    @Override
    public int getNumberOfPoints() {
        return this.end - this.start;
    }

    @Override
    public void finish() {
    }

    @Override
    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public int getTotalCount(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.posTotal[offset] + this.negTotal[offset];
    }

    @Override
    public int getNegTotal(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.negTotal[offset];
    }

    @Override
    public int getPosTotal(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.posTotal[offset];
    }

    @Override
    public int getTotalQuality(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.totalQ[offset];
    }

    @Override
    public int getCount(int pos, byte b) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        switch (b) {
            case 65: 
            case 97: {
                return this.posA[offset] + this.negA[offset];
            }
            case 84: 
            case 116: {
                return this.posT[offset] + this.negT[offset];
            }
            case 67: 
            case 99: {
                return this.posC[offset] + this.negC[offset];
            }
            case 71: 
            case 103: {
                return this.posG[offset] + this.negG[offset];
            }
            case 78: 
            case 110: {
                return this.posN[offset] + this.negN[offset];
            }
        }
        log.debug("Unknown nucleotide: " + b);
        return 0;
    }

    @Override
    public int getNegCount(int pos, byte b) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        switch (b) {
            case 65: 
            case 97: {
                return this.negA[offset];
            }
            case 84: 
            case 116: {
                return this.negT[offset];
            }
            case 67: 
            case 99: {
                return this.negC[offset];
            }
            case 71: 
            case 103: {
                return this.negG[offset];
            }
            case 78: 
            case 110: {
                return this.negN[offset];
            }
        }
        log.error("Unknown nucleotide: " + b);
        return 0;
    }

    @Override
    public int getPosCount(int pos, byte b) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        switch (b) {
            case 65: 
            case 97: {
                return this.posA[offset];
            }
            case 84: 
            case 116: {
                return this.posT[offset];
            }
            case 67: 
            case 99: {
                return this.posC[offset];
            }
            case 71: 
            case 103: {
                return this.posG[offset];
            }
            case 78: 
            case 110: {
                return this.posN[offset];
            }
        }
        log.error("Unknown nucleotide: " + b);
        return 0;
    }

    @Override
    public int getDelCount(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.del[offset];
    }

    @Override
    public int getInsCount(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.ins[offset];
    }

    @Override
    public int getQuality(int pos, byte b) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            log.error("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            return 0;
        }
        switch (b) {
            case 65: 
            case 97: {
                return this.qA[offset];
            }
            case 84: 
            case 116: {
                return this.qT[offset];
            }
            case 67: 
            case 99: {
                return this.qC[offset];
            }
            case 71: 
            case 103: {
                return this.qG[offset];
            }
            case 78: 
            case 110: {
                return this.qN[offset];
            }
        }
        log.error("Unknown nucleotide: " + this.posN);
        return 0;
    }

    @Override
    public int getAvgQuality(int pos, byte b) {
        int count = this.getCount(pos, b);
        return count == 0 ? 0 : this.getQuality(pos, b) / count;
    }

    @Override
    protected void incrementDeletion(int pos, boolean negativeStrand) {
        int offset = pos - this.start;
        if (offset >= 0 && offset < this.del.length) {
            this.del[offset] = this.del[offset] + 1;
            if (this.countDeletedBasesCovered) {
                if (negativeStrand) {
                    this.negTotal[offset] = this.negTotal[offset] + 1;
                } else {
                    this.posTotal[offset] = this.posTotal[offset] + 1;
                }
            }
        }
    }

    @Override
    protected void incrementInsertion(AlignmentBlock insBlock) {
        int pos = insBlock.getStart();
        int offset = pos - this.start;
        if (offset >= 0 && offset < this.ins.length) {
            this.ins[offset] = this.ins[offset] + 1;
            if (--offset >= 0) {
                this.ins[offset] = this.ins[offset] + 1;
            }
        }
    }

    @Override
    protected void incBlockCounts(AlignmentBlock block, boolean isNegativeStrand) {
        int start = block.getStart();
        byte[] bases = block.getBases();
        if (bases != null) {
            for (int i = 0; i < bases.length; ++i) {
                int pos = start + i;
                byte q = block.qualities[i];
                byte n = bases[i];
                this.incPositionCount(pos, n, q, isNegativeStrand);
            }
        }
    }

    @Override
    protected void incPositionCount(int pos, byte b, byte q, boolean isNegativeStrand) {
        int offset = pos - this.start;
        if (offset >= 0 && offset < this.posA.length) {
            switch (b) {
                case 65: 
                case 97: {
                    if (isNegativeStrand) {
                        this.negA[offset] = this.negA[offset] + 1;
                    } else {
                        this.posA[offset] = this.posA[offset] + 1;
                    }
                    this.qA[offset] = this.qA[offset] + q;
                    break;
                }
                case 84: 
                case 116: {
                    if (isNegativeStrand) {
                        this.negT[offset] = this.negT[offset] + 1;
                    } else {
                        this.posT[offset] = this.posT[offset] + 1;
                    }
                    this.qT[offset] = this.qT[offset] + q;
                    break;
                }
                case 67: 
                case 99: {
                    if (isNegativeStrand) {
                        this.negC[offset] = this.negC[offset] + 1;
                    } else {
                        this.posC[offset] = this.posC[offset] + 1;
                    }
                    this.qC[offset] = this.qC[offset] + q;
                    break;
                }
                case 71: 
                case 103: {
                    if (isNegativeStrand) {
                        this.negG[offset] = this.negG[offset] + 1;
                    } else {
                        this.posG[offset] = this.posG[offset] + 1;
                    }
                    this.qG[offset] = this.qG[offset] + q;
                    break;
                }
                default: {
                    if (isNegativeStrand) {
                        this.negN[offset] = this.negN[offset] + 1;
                    } else {
                        this.posN[offset] = this.posN[offset] + 1;
                    }
                    this.qN[offset] = this.qN[offset] + q;
                }
            }
            if (isNegativeStrand) {
                this.negTotal[offset] = this.negTotal[offset] + 1;
            } else {
                this.posTotal[offset] = this.posTotal[offset] + 1;
            }
            this.totalQ[offset] = this.totalQ[offset] + q;
            int tmp = this.posTotal[offset] + this.negTotal[offset];
            this.maxCount = tmp > this.maxCount ? tmp : this.maxCount;
        }
    }

    @Override
    public AlignmentCounts merge(AlignmentCounts other, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        if (other.getClass() != this.getClass()) {
            throw new IllegalArgumentException("Cannot merge different types of AlignmentCount instances");
        }
        return DenseAlignmentCounts.merge(this, (DenseAlignmentCounts)other, bisulfiteContext);
    }

    private static DenseAlignmentCounts merge(DenseAlignmentCounts first, DenseAlignmentCounts second, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        if (second.getStart() < first.getStart()) {
            DenseAlignmentCounts tmp = first;
            first = second;
            second = tmp;
        }
        int firstLength = first.getEnd() - first.getStart();
        int newStart = first.getStart();
        int newEnd = Math.max(first.getEnd(), second.getEnd());
        int lengthIncrease = newEnd - newStart - firstLength;
        if (lengthIncrease <= 0) {
            return first;
        }
        int[][] firstSrcArrs = DenseAlignmentCounts.getCountArrs(first);
        int[][] secondSrcArrs = DenseAlignmentCounts.getCountArrs(second);
        DenseAlignmentCounts result = new DenseAlignmentCounts(newStart, newEnd, bisulfiteContext);
        int[][] destArrs = DenseAlignmentCounts.getCountArrs(result);
        int number = firstSrcArrs.length;
        int secondOffset = first.getEnd() - second.getStart();
        for (int arnum = 0; arnum < number; ++arnum) {
            int[] destArr = destArrs[arnum];
            System.arraycopy(firstSrcArrs[arnum], 0, destArr, 0, firstLength);
            System.arraycopy(secondSrcArrs[arnum], secondOffset, destArr, firstLength, lengthIncrease);
        }
        result.maxCount = Math.max(first.getMaxCount(), second.getMaxCount());
        return result;
    }

    private static int[][] getCountArrs(DenseAlignmentCounts counts) {
        int[][] result = new int[][]{counts.posA, counts.posT, counts.posC, counts.posG, counts.posN, counts.negA, counts.negT, counts.negC, counts.negG, counts.negN, counts.qA, counts.qT, counts.qC, counts.qG, counts.qN, counts.posTotal, counts.negTotal, counts.del, counts.ins, counts.totalQ};
        return result;
    }
}

