/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.Arrays;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlockFS;
import org.broad.igv.sam.FlowSignalContext;
import org.broad.igv.sam.FlowSignalSubContext;

public class AlignmentBlock {
    private int start;
    private byte[] bases;
    public byte[] qualities;
    private short[] counts;
    private boolean softClipped = false;
    private Alignment baseAlignment = null;

    public static AlignmentBlock getInstance(int start, byte[] bases, byte[] qualities, Alignment baseAlignment) {
        return new AlignmentBlock(start, bases, qualities, baseAlignment);
    }

    public static AlignmentBlock getInstance(int start, byte[] bases, byte[] qualities, FlowSignalContext fContext, Alignment baseAlignment) {
        return new AlignmentBlockFS(start, bases, qualities, fContext, baseAlignment);
    }

    protected AlignmentBlock(int start, byte[] bases, byte[] qualities, Alignment baseAlignment) {
        this.start = start;
        this.bases = bases;
        this.baseAlignment = baseAlignment;
        if (qualities == null || qualities.length < bases.length) {
            this.qualities = new byte[bases.length];
            Arrays.fill(this.qualities, (byte)126);
        } else {
            this.qualities = qualities;
        }
        this.counts = null;
    }

    public Alignment getBaseAlignment() {
        return this.baseAlignment;
    }

    public boolean contains(int position) {
        int offset = position - this.start;
        return offset >= 0 && offset < this.bases.length;
    }

    public byte[] getBases() {
        return this.bases;
    }

    public byte getBase(int offset) {
        return this.bases[offset];
    }

    public int getStart() {
        return this.start;
    }

    public byte getQuality(int offset) {
        return this.qualities[offset];
    }

    public byte[] getQualities() {
        return this.qualities;
    }

    public short[] getCounts() {
        return this.counts;
    }

    public short getCount(int i) {
        return this.counts[i];
    }

    public void setCounts(short[] counts) {
        this.counts = counts;
    }

    public int getEnd() {
        return this.start + this.bases.length;
    }

    public boolean isSoftClipped() {
        return this.softClipped;
    }

    public void setSoftClipped(boolean softClipped) {
        this.softClipped = softClipped;
    }

    public boolean hasFlowSignals() {
        return false;
    }

    public boolean hasCounts() {
        return this.counts != null;
    }

    public FlowSignalSubContext getFlowSignalSubContext(int offset) {
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[block ");
        sb.append(this.isSoftClipped() ? "softClipped " : " ");
        sb.append(this.getStart());
        sb.append("-");
        sb.append(this.getEnd());
        sb.append(" ");
        for (int i = 0; i < this.bases.length; ++i) {
            sb.append((char)this.bases[i]);
        }
        sb.append("]");
        return sb.toString();
    }
}

