/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;

public class SpliceJunctionRenderer
extends IGVFeatureRenderer {
    private static Logger log = Logger.getLogger(SpliceJunctionRenderer.class);
    Color ARC_COLOR_NEG = new Color(50, 50, 150, 140);
    Color ARC_COLOR_POS = new Color(150, 50, 50, 140);
    Color ARC_COLOR_HIGHLIGHT_NEG = new Color(90, 90, 255, 255);
    Color ARC_COLOR_HIGHLIGHT_POS = new Color(255, 90, 90, 255);
    Color COLOR_CENTERLINE = new Color(0, 0, 0, 100);
    protected int MAX_DEPTH = 50;

    @Override
    public void render(List<IGVFeature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (featureList != null && !featureList.isEmpty()) {
            Font font = FontManager.getFont(track.getFontSize());
            Graphics2D fontGraphics = (Graphics2D)context.getGraphic2DForColor(Color.BLACK).create();
            if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
                fontGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            fontGraphics.setFont(font);
            PreferenceManager prefs = PreferenceManager.getInstance();
            boolean shouldShowFlankingRegions = prefs.getAsBoolean("SAM.SHOW_JUNCTION_FLANKINGREGIONS");
            double trackRectangleX = trackRectangle.getX();
            double trackRectangleMaxX = trackRectangle.getMaxX();
            SpliceJunctionFeature selectedFeature = (SpliceJunctionFeature)((FeatureTrack)track).getSelectedFeature();
            for (IGVFeature feature : featureList) {
                SpliceJunctionFeature junctionFeature = (SpliceJunctionFeature)feature;
                boolean shouldHighlight = false;
                if (selectedFeature != null && selectedFeature.isSameJunction(junctionFeature)) {
                    this.setHighlightFeature(junctionFeature);
                    shouldHighlight = true;
                }
                int flankingStart = junctionFeature.getStart();
                int flankingEnd = junctionFeature.getEnd();
                int junctionStart = junctionFeature.getJunctionStart();
                int junctionEnd = junctionFeature.getJunctionEnd();
                double virtualPixelStart = Math.round(((double)flankingStart - origin) / locScale);
                double virtualPixelEnd = Math.round(((double)flankingEnd - origin) / locScale);
                double virtualPixelJunctionStart = Math.round(((double)junctionStart - origin) / locScale);
                double virtualPixelJunctionEnd = Math.round(((double)junctionEnd - origin) / locScale);
                if (!(virtualPixelEnd >= trackRectangleX) || !(virtualPixelStart <= trackRectangleMaxX)) continue;
                int displayPixelEnd = (int)Math.min(trackRectangleMaxX, virtualPixelEnd);
                int displayPixelStart = (int)Math.max(trackRectangleX, virtualPixelStart);
                float depth = junctionFeature.getJunctionDepth();
                Color color = feature.getColor();
                this.drawFeature((int)virtualPixelStart, (int)virtualPixelEnd, (int)virtualPixelJunctionStart, (int)virtualPixelJunctionEnd, depth, trackRectangle, context, feature.getStrand(), junctionFeature, shouldHighlight, color, shouldShowFlankingRegions);
            }
            Graphics2D g2D = context.getGraphic2DForColor(this.COLOR_CENTERLINE);
            g2D.drawLine((int)trackRectangleX, (int)trackRectangle.getCenterY(), (int)trackRectangleMaxX, (int)trackRectangle.getCenterY());
        }
    }

    protected void drawFlankingRegion(Graphics g2D, int pixelStart, int pixelLength, int[] regionDepthArray, int maxPossibleArcHeight, Rectangle trackRectangle, boolean isPositiveStrand) {
        for (int i = 0; i < pixelLength; ++i) {
            float arrayIndicesPerPixel = (float)regionDepthArray.length / (float)pixelLength;
            int flankingRegionArrayPixelMinIndex = (int)((float)i * arrayIndicesPerPixel);
            int flankingRegionArrayPixelMaxIndex = (int)((float)(i + 1) * arrayIndicesPerPixel);
            flankingRegionArrayPixelMinIndex = Math.max(0, Math.min(flankingRegionArrayPixelMinIndex, regionDepthArray.length - 1));
            flankingRegionArrayPixelMaxIndex = Math.max(0, Math.min(flankingRegionArrayPixelMaxIndex, regionDepthArray.length - 1));
            int meanDepthThisPixel = 0;
            for (int j = flankingRegionArrayPixelMinIndex; j <= flankingRegionArrayPixelMaxIndex; ++j) {
                meanDepthThisPixel += regionDepthArray[j];
            }
            meanDepthThisPixel /= flankingRegionArrayPixelMaxIndex - flankingRegionArrayPixelMinIndex + 1;
            meanDepthThisPixel = Math.min(this.MAX_DEPTH, meanDepthThisPixel);
            int pixelHeight = Math.max(maxPossibleArcHeight * meanDepthThisPixel / this.MAX_DEPTH, 2);
            g2D.fillRect(pixelStart + i, (int)trackRectangle.getCenterY() + (isPositiveStrand ? -pixelHeight : 0), 1, pixelHeight);
        }
    }

    protected void drawFeature(int pixelFeatureStart, int pixelFeatureEnd, int pixelJunctionStart, int pixelJunctionEnd, float depth, Rectangle trackRectangle, RenderContext context, Strand strand, SpliceJunctionFeature junctionFeature, boolean shouldHighlight, Color featureColor, boolean shouldShowFlankingRegions) {
        Color color;
        boolean isPositiveStrand = true;
        if (strand != null && strand.equals((Object)Strand.NEGATIVE)) {
            isPositiveStrand = false;
        }
        if (featureColor != null) {
            int r = featureColor.getRed();
            int g = featureColor.getGreen();
            int b = featureColor.getBlue();
            int alpha = shouldHighlight ? 255 : 140;
            color = new Color(r, g, b, alpha);
        } else {
            color = isPositiveStrand ? (shouldHighlight ? this.ARC_COLOR_HIGHLIGHT_POS : this.ARC_COLOR_POS) : (shouldHighlight ? this.ARC_COLOR_HIGHLIGHT_NEG : this.ARC_COLOR_NEG);
        }
        Graphics2D g2D = context.getGraphic2DForColor(color);
        if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int maxPossibleArcHeight = (trackRectangle.height - 1) / 2;
        if (shouldShowFlankingRegions) {
            if (junctionFeature.hasFlankingRegionDepthArrays()) {
                int startFlankingRegionPixelLength = pixelJunctionStart - pixelFeatureStart;
                int endFlankingRegionPixelLength = pixelFeatureEnd - pixelJunctionEnd;
                this.drawFlankingRegion(g2D, pixelFeatureStart, startFlankingRegionPixelLength, junctionFeature.getStartFlankingRegionDepthArray(), maxPossibleArcHeight, trackRectangle, isPositiveStrand);
                this.drawFlankingRegion(g2D, pixelJunctionEnd + 1, endFlankingRegionPixelLength, junctionFeature.getEndFlankingRegionDepthArray(), maxPossibleArcHeight, trackRectangle, isPositiveStrand);
            } else {
                int overlapRectHeight = 3;
                int overlapRectTopX = (int)trackRectangle.getCenterY() + (isPositiveStrand ? -2 : 0);
                if (pixelFeatureStart < pixelJunctionStart) {
                    g2D.fillRect(pixelFeatureStart, overlapRectTopX, pixelJunctionStart - pixelFeatureStart, overlapRectHeight);
                }
                if (pixelJunctionEnd < pixelFeatureEnd) {
                    g2D.fillRect(pixelJunctionEnd, overlapRectTopX, pixelFeatureEnd - pixelJunctionEnd, overlapRectHeight);
                }
            }
        }
        double minArcHeightProportion = 0.33;
        int innerArcHeight = (int)((double)maxPossibleArcHeight * minArcHeightProportion);
        float depthProportionOfMax = Math.min(1.0f, depth / (float)this.MAX_DEPTH);
        int arcWidth = Math.max(1, (int)((1.0 - minArcHeightProportion) * (double)maxPossibleArcHeight * (double)depthProportionOfMax));
        int outerArcHeight = innerArcHeight + arcWidth;
        int arcBeginY = (int)trackRectangle.getCenterY() + (isPositiveStrand ? -1 : 1);
        int outerArcPeakY = isPositiveStrand ? arcBeginY - outerArcHeight : arcBeginY + outerArcHeight;
        int innerArcPeakY = isPositiveStrand ? arcBeginY - innerArcHeight : arcBeginY + innerArcHeight;
        int outerBezierY = arcBeginY + (int)(1.3 * (double)(outerArcPeakY - arcBeginY));
        int innerBezierY = arcBeginY + (int)(1.3 * (double)(innerArcPeakY - arcBeginY));
        int bezierXPad = Math.max(1, (pixelJunctionEnd - pixelJunctionStart) / 30);
        GeneralPath arcPath = new GeneralPath();
        arcPath.moveTo(pixelJunctionStart, arcBeginY);
        arcPath.curveTo(pixelJunctionStart - bezierXPad, outerBezierY, pixelJunctionEnd + bezierXPad, outerBezierY, pixelJunctionEnd, arcBeginY);
        arcPath.curveTo(pixelJunctionEnd + bezierXPad, innerBezierY, pixelJunctionStart - bezierXPad, innerBezierY, pixelJunctionStart, arcBeginY);
        g2D.draw(arcPath);
        g2D.fill(arcPath);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
    }
}

