/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.plugin;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.dev.plugin.Argument;
import org.broad.igv.dev.plugin.FeatureEncoder;
import org.broad.igv.dev.plugin.LineFeatureEncoder;
import org.broad.tribble.Feature;

public class AsciiEncoder<E extends Feature>
implements FeatureEncoder<E> {
    protected LineFeatureEncoder<E> lineFeatureEncoder;
    public static final String NUM_COLS_ATTR = "numCols";

    public AsciiEncoder(LineFeatureEncoder<E> lineFeatureEncoder) {
        this.lineFeatureEncoder = lineFeatureEncoder;
    }

    @Override
    public Map<String, Object> encodeAll(OutputStream outputStream, Iterator<E> features) {
        LineFeatureEncoder<E> encoder = this.lineFeatureEncoder;
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream));
        HashMap<String, Object> attributes = new HashMap<String, Object>(1);
        int tmpNumCols = 0;
        if (features != null) {
            String header = encoder.getHeader();
            if (header != null) {
                writer.println(header);
            }
            while (features.hasNext()) {
                Feature feature = (Feature)features.next();
                String line = encoder.encode(feature);
                if (line == null) continue;
                writer.println(line);
                tmpNumCols = encoder.getNumCols(line);
            }
        }
        attributes.put(NUM_COLS_ATTR, tmpNumCols);
        writer.flush();
        writer.close();
        return attributes;
    }

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap) {
        this.lineFeatureEncoder.setInputs(commands, argumentMap);
    }
}

