/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.data.WiggleDataset;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.collections.DownsampledDoubleArrayList;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;
import org.broad.tribble.readers.AsciiLineReader;

public class WiggleParser {
    private static Logger log = Logger.getLogger(WiggleParser.class);
    private int chrColumn = 0;
    private int startColumn = 1;
    private int endColumn = 2;
    private int dataColumn = 3;
    Genome genome;
    WiggleDataset dataset;
    private Type type = Type.BED_GRAPH;
    private String chr;
    String lastChr = "";
    int lastPosition = 0;
    private int start;
    private int step = 1;
    private int windowSpan = 1;
    private int startBase = 1;
    IntArrayList startLocations = null;
    IntArrayList endLocations = null;
    FloatArrayList data = null;
    ResourceLocator resourceLocator;
    Set<String> unsortedChromosomes;
    int estArraySize;
    Map<String, Integer> longestFeatureMap = new HashMap<String, Integer>();
    private static final int maxSamples = 1000;
    DownsampledDoubleArrayList sampledData = new DownsampledDoubleArrayList(1000, 1000);

    public WiggleParser(ResourceLocator locator) {
        this(locator, null);
    }

    public WiggleParser(ResourceLocator locator, Genome genome) {
        this.genome = genome;
        this.resourceLocator = locator;
        this.estArraySize = this.estArraySize(locator, genome);
        this.dataset = new WiggleDataset(genome, locator.getTrackName());
        if (locator.getPath().endsWith("CpG.txt")) {
            this.type = Type.CPG;
        } else if (locator.getPath().toLowerCase().endsWith(".expr")) {
            this.type = Type.EXPR;
            this.chrColumn = 2;
            this.startColumn = 3;
            this.endColumn = 4;
            this.dataColumn = 5;
            this.startBase = 1;
            this.dataset.setType(TrackType.EXPR);
        }
    }

    private int estArraySize(ResourceLocator locator, Genome genome) {
        int estLines = 100000;
        if (locator.getServerURL() == null) {
            estLines = ParsingUtils.estimateLineCount(locator.getPath());
        }
        int nChromosomes = genome == null ? 24 : genome.getAllChromosomeNames().size();
        return Math.max(1000, estLines / nChromosomes);
    }

    public static boolean isWiggle(ResourceLocator file) {
        return file.getPath().endsWith("CpG.txt") || file.getPath().endsWith(".expr") || file.getPath().endsWith(".wig");
    }

    public WiggleDataset parse() {
        this.lastPosition = -1;
        this.unsortedChromosomes = new HashSet<String>();
        AsciiLineReader reader = null;
        String nextLine = null;
        int lineNumber = 0;
        try {
            reader = ParsingUtils.openAsciiReader(this.resourceLocator);
            if (this.type == Type.EXPR) {
                reader.readLine();
            }
            int position = -1;
            while ((nextLine = reader.readLine()) != null) {
                ++lineNumber;
                if (nextLine.startsWith("#") || nextLine.startsWith("data") || nextLine.startsWith("browser") || nextLine.trim().length() == 0) continue;
                if (nextLine.startsWith("track") && this.type != Type.CPG) {
                    this.type = Type.BED_GRAPH;
                    ParsingUtils.parseTrackLine(nextLine, this.dataset.getTrackProperties());
                    if (this.dataset.getTrackProperties().getBaseCoord() != TrackProperties.BaseCoord.ZERO) continue;
                    this.startBase = 0;
                    continue;
                }
                if (nextLine.startsWith("fixedStep")) {
                    this.type = Type.FIXED;
                    this.parseStepLine(nextLine);
                    position = this.start;
                    if (this.start >= this.lastPosition) continue;
                    this.unsortedChromosomes.add(this.chr);
                    continue;
                }
                if (nextLine.startsWith("variableStep")) {
                    this.type = Type.VARIABLE;
                    this.parseStepLine(nextLine);
                    if (this.start >= this.lastPosition) continue;
                    this.unsortedChromosomes.add(this.chr);
                    continue;
                }
                String[] tokens = Globals.singleTabMultiSpacePattern.split(nextLine);
                int nTokens = tokens.length;
                if (nTokens == 0) continue;
                try {
                    int startPosition;
                    if (this.type.equals((Object)Type.CPG)) {
                        if (nTokens <= 3) continue;
                        this.chr = tokens[1].trim();
                        if (!this.chr.equals(this.lastChr)) {
                            this.changedChromosome(this.dataset, this.lastChr);
                        }
                        this.lastChr = this.chr;
                        int endPosition = -1;
                        try {
                            endPosition = Integer.parseInt(tokens[2].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.error("Column 2  is not a number");
                            throw new ParserException("Column 2 must be numeric. Found: " + tokens[1], lineNumber, nextLine);
                        }
                        int startPosition2 = endPosition - 1;
                        if (startPosition2 < this.lastPosition) {
                            this.unsortedChromosomes.add(this.chr);
                        }
                        this.lastPosition = startPosition2;
                        this.startLocations.add(startPosition2);
                        this.endLocations.add(endPosition);
                        float value = Float.parseFloat(tokens[4].trim());
                        if (tokens[3].trim().equals("R")) {
                            value = -value;
                        }
                        this.data.add(value);
                        continue;
                    }
                    if (this.type.equals((Object)Type.BED_GRAPH) || this.type.equals((Object)Type.EXPR)) {
                        if (nTokens <= 3) continue;
                        this.chr = tokens[this.chrColumn].trim();
                        if (!this.chr.equals(this.lastChr)) {
                            this.changedChromosome(this.dataset, this.lastChr);
                        }
                        this.lastChr = this.chr;
                        startPosition = -1;
                        try {
                            startPosition = Integer.parseInt(tokens[this.startColumn].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.error("Column " + (this.startColumn + 1) + "  is not a number");
                            throw new ParserException("Column (startColumn + 1) must be numeric. Found: " + tokens[this.startColumn], lineNumber, nextLine);
                        }
                        if (startPosition < this.lastPosition) {
                            this.unsortedChromosomes.add(this.chr);
                        }
                        this.lastPosition = startPosition;
                        this.startLocations.add(startPosition);
                        try {
                            int endPosition = Integer.parseInt(tokens[this.endColumn].trim());
                            this.endLocations.add(endPosition);
                            int length = endPosition - startPosition;
                            this.updateLongestFeature(length);
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.error("Column " + (this.endColumn + 1) + " is not a number");
                            throw new ParserException("Column " + (this.endColumn + 1) + " must be numeric." + " Found: " + tokens[this.endColumn], lineNumber, nextLine);
                        }
                        this.data.add(Float.parseFloat(tokens[this.dataColumn].trim()));
                        continue;
                    }
                    if (this.type.equals((Object)Type.VARIABLE)) {
                        if (nTokens <= 1) continue;
                        startPosition = Integer.parseInt(tokens[0]) - 1;
                        if (startPosition < this.lastPosition) {
                            this.unsortedChromosomes.add(this.chr);
                        }
                        this.lastPosition = startPosition;
                        int end = startPosition + this.windowSpan;
                        this.startLocations.add(startPosition);
                        this.endLocations.add(end);
                        this.data.add(Float.parseFloat(tokens[1]));
                        continue;
                    }
                    if (position >= 0) {
                        this.startLocations.add(position);
                        this.endLocations.add(position + this.windowSpan);
                        this.data.add(Float.parseFloat(tokens[0]));
                    }
                    this.lastPosition = position += this.step;
                }
                catch (NumberFormatException e) {
                    log.error(e);
                    throw new ParserException(e.getMessage(), lineNumber, nextLine);
                }
            }
            this.changedChromosome(this.dataset, this.lastChr);
        }
        catch (ParserException pe) {
            throw pe;
        }
        catch (Exception e) {
            if (nextLine != null && lineNumber != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, lineNumber, nextLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.dataset.sort(this.unsortedChromosomes);
        this.dataset.setLongestFeatureMap(this.longestFeatureMap);
        double[] sd = this.sampledData.toArray();
        double percent10 = StatUtils.percentile(sd, 10.0);
        double percent90 = StatUtils.percentile(sd, 90.0);
        this.dataset.setPercent10((float)percent10);
        this.dataset.setPercent90((float)percent90);
        return this.dataset;
    }

    private void updateLongestFeature(int length) {
        if (this.longestFeatureMap.containsKey(this.chr)) {
            this.longestFeatureMap.put(this.chr, Math.max(this.longestFeatureMap.get(this.chr), length));
        } else {
            this.longestFeatureMap.put(this.chr, length);
        }
    }

    private void parseStepLine(String header) {
        String[] tokens;
        for (String token : tokens = header.split("\\s+")) {
            String[] keyValue = token.split("=");
            if (keyValue.length < 2) continue;
            if (keyValue[0].equalsIgnoreCase("chrom")) {
                this.chr = keyValue[1];
                if (!this.chr.equals(this.lastChr)) {
                    this.changedChromosome(this.dataset, this.lastChr);
                }
                this.lastChr = this.chr;
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("start")) {
                this.start = Integer.parseInt(keyValue[1]) - this.startBase;
                if (this.start >= this.lastPosition) continue;
                this.unsortedChromosomes.add(this.chr);
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("step")) {
                this.step = Integer.parseInt(keyValue[1]);
                continue;
            }
            if (!keyValue[0].equalsIgnoreCase("span")) continue;
            this.windowSpan = Integer.parseInt(keyValue[1]);
            this.updateLongestFeature(this.windowSpan);
        }
    }

    private void changedChromosome(WiggleDataset dataset, String lastChr) {
        if (this.startLocations != null && this.startLocations.size() > 0) {
            String convertedChr = this.genome == null ? lastChr : this.genome.getChromosomeAlias(lastChr);
            dataset.addDataChunk(convertedChr, this.startLocations, this.endLocations, this.data);
            float[] f = this.data.toArray();
            for (int i = 0; i < f.length; ++i) {
                this.sampledData.add(f[i]);
            }
        }
        this.startLocations = new IntArrayList(this.estArraySize);
        this.endLocations = new IntArrayList(this.estArraySize);
        this.data = new FloatArrayList(this.estArraySize);
        this.lastPosition = -1;
    }

    private static enum Type {
        FIXED,
        VARIABLE,
        BED_GRAPH,
        CPG,
        EXPR;

    }
}

