/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BBTotalSummaryBlock;
import org.broad.igv.bbfile.BBZoomLevels;
import org.broad.igv.bbfile.BPTree;
import org.broad.igv.bbfile.BigBedIterator;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.ZoomLevelIterator;
import org.broad.igv.util.CompressionUtils;
import org.broad.tribble.util.SeekableBufferedStream;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class BBFileReader {
    public static final long BBFILE_HEADER_OFFSET = 0L;
    private static Logger log = Logger.getLogger(BBFileReader.class);
    private String path;
    private long fileOffset;
    private BBFileHeader fileHeader;
    private boolean isLowToHigh;
    private int uncompressBufSize;
    private String autoSqlFormat;
    private int zoomLevelCount;
    private long zoomLevelOffset;
    private BBZoomLevels zoomLevels;
    private BBTotalSummaryBlock totalSummaryBlock;
    private long chromIDTreeOffset;
    private BPTree chromosomeIDTree;
    private long chromDataTreeOffset;
    private RPTree chromosomeDataTree;
    private String autoSql;
    CompressionUtils compressionUtils;

    static SeekableStream getStream(String path) throws IOException {
        return new SeekableBufferedStream(SeekableStreamFactory.getStreamFor(path), 128000);
    }

    public BBFileReader(String path) throws IOException {
        long autoSqlOffset;
        log.debug("Opening BBFile source  " + path);
        this.compressionUtils = new CompressionUtils();
        this.fileOffset = 0L;
        SeekableStream stream = BBFileReader.getStream(path);
        this.path = path;
        this.fileHeader = new BBFileHeader(path, stream, this.fileOffset);
        if (!this.fileHeader.isHeaderOK()) {
            log.error("BBFile header is unrecognized type, header magic = " + this.fileHeader.getMagic());
            throw new RuntimeException("Error reading BBFile header for: " + path);
        }
        this.isLowToHigh = this.fileHeader.isLowToHigh();
        this.uncompressBufSize = this.fileHeader.getUncompressBuffSize();
        this.fileOffset = stream.position();
        this.zoomLevelCount = this.fileHeader.getZoomLevels();
        if (this.zoomLevelCount > 0) {
            this.zoomLevelOffset = this.fileOffset;
            this.zoomLevels = new BBZoomLevels(stream, this.zoomLevelOffset, this.zoomLevelCount, this.isLowToHigh, this.uncompressBufSize);
            this.fileOffset += (long)(this.zoomLevelCount * 24);
        }
        if ((autoSqlOffset = this.fileHeader.getAutoSqlOffset()) != 0L) {
            stream.seek(autoSqlOffset);
            this.autoSql = BBFileReader.readNullTerminatedString(stream);
        }
        this.fileOffset = this.fileHeader.getTotalSummaryOffset();
        if (this.fileHeader.getVersion() >= 2 && this.fileOffset > 0L) {
            this.totalSummaryBlock = new BBTotalSummaryBlock(stream, this.fileOffset, this.isLowToHigh);
            this.fileOffset += 40L;
        }
        this.chromIDTreeOffset = this.fileHeader.getChromosomeTreeOffset();
        if (this.chromIDTreeOffset != 0L) {
            this.fileOffset = this.chromIDTreeOffset;
            this.chromosomeIDTree = new BPTree(stream, this.fileOffset, this.isLowToHigh);
        }
        this.chromDataTreeOffset = this.fileHeader.getFullIndexOffset();
        if (this.chromDataTreeOffset != 0L) {
            this.fileOffset = this.chromDataTreeOffset;
            boolean forceDescend = false;
            this.chromosomeDataTree = new RPTree(stream, this.fileOffset, this.isLowToHigh, this.uncompressBufSize, forceDescend);
        }
        this.fileOffset = this.fileHeader.getFullDataOffset();
    }

    public BBFileHeader getBBFileHeader() {
        return this.fileHeader;
    }

    public boolean isBigBedFile() {
        return this.fileHeader.isBigBed();
    }

    public boolean isBigWigFile() {
        return this.fileHeader.isBigWig();
    }

    public boolean isLowToHigh() {
        return this.isLowToHigh;
    }

    public BBTotalSummaryBlock getTotalSummaryBlock() {
        return this.totalSummaryBlock;
    }

    public BBZoomLevels getZoomLevels() {
        return this.zoomLevels;
    }

    public ArrayList<String> getChromosomeNames() {
        ArrayList<String> chromosomeList = this.chromosomeIDTree.getChromosomeNames();
        return chromosomeList;
    }

    public String getAutoSql() {
        return this.autoSql;
    }

    public synchronized BigBedIterator getBigBedIterator(String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        if (!this.isBigBedFile()) {
            return null;
        }
        RPChromosomeRegion selectionRegion = this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
        if (selectionRegion == null) {
            return new BigBedIterator();
        }
        BigBedIterator bedIterator = new BigBedIterator(this.path, this.chromosomeIDTree, this.chromosomeDataTree, selectionRegion, contained, this.compressionUtils);
        return bedIterator;
    }

    public synchronized BigWigIterator getBigWigIterator(String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        if (!this.isBigWigFile()) {
            return null;
        }
        RPChromosomeRegion selectionRegion = this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
        if (selectionRegion == null) {
            return new BigWigIterator();
        }
        BigWigIterator wigIterator = new BigWigIterator(this.path, this.chromosomeIDTree, this.chromosomeDataTree, selectionRegion, contained, this.compressionUtils);
        return wigIterator;
    }

    public synchronized ZoomLevelIterator getZoomLevelIterator(int zoomLevel, String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        ZoomLevelIterator zoomIterator;
        if (zoomLevel < 1 || zoomLevel > this.zoomLevelCount) {
            throw new RuntimeException("Error: ZoomLevelIterator zoom level is out of range\n");
        }
        RPTree zoomDataTree = this.zoomLevels.getZoomLevelRPTree(zoomLevel);
        RPChromosomeRegion selectionRegion = this.getSelectionRegion(zoomDataTree, startChromosome, startBase, endChromosome, endBase);
        if (selectionRegion == null) {
            return ZoomLevelIterator.EmptyIterator.theInstance;
        }
        try {
            zoomIterator = new ZoomLevelIterator(BBFileReader.getStream(this.path), this.chromosomeIDTree, zoomDataTree, zoomLevel, selectionRegion, contained, this.compressionUtils);
        }
        catch (IOException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        return zoomIterator;
    }

    public synchronized ZoomLevelIterator getZoomLevelIterator(int zoomLevel) {
        return this.getZoomLevelIterator(zoomLevel, null, -1, null, -1, true);
    }

    private RPChromosomeRegion getSelectionRegion(RPTree zoomDataTree, String startChromosome, int startBase, String endChromosome, int endBase) {
        if (startChromosome == null || endChromosome == null) {
            return zoomDataTree.getChromosomeBounds();
        }
        return this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
    }

    private RPChromosomeRegion getChromosomeBounds(String startChromosome, int startBase, String endChromosome, int endBase) {
        if (startChromosome.length() > this.chromosomeIDTree.getKeySize()) {
            return null;
        }
        String startChromKey = this.chromosomeIDTree.getChromosomeKey(startChromosome);
        int startChromID = this.chromosomeIDTree.getChromosomeID(startChromKey);
        if (startChromID < 0) {
            return null;
        }
        String endChromKey = this.chromosomeIDTree.getChromosomeKey(endChromosome);
        int endChromID = this.chromosomeIDTree.getChromosomeID(endChromKey);
        if (endChromID < 0) {
            return null;
        }
        RPChromosomeRegion chromBounds = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
        return chromBounds;
    }

    private static String readNullTerminatedString(InputStream fis) throws IOException {
        byte b;
        BufferedInputStream bis = new BufferedInputStream(fis, 1000);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(100);
        while ((b = (byte)bis.read()) != 0) {
            bos.write(b);
        }
        return new String(bos.toByteArray());
    }
}

