/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMSequenceDictionary;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.codecs.bcf2.BCF2Codec;
import org.broadinstitute.sting.utils.codecs.bcf2.BCF2Type;
import org.broadinstitute.sting.utils.codecs.bcf2.BCF2Utils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFAlleleClipper;
import org.broadinstitute.sting.utils.codecs.vcf.VCFContigHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.LazyGenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.writer.BCF2Encoder;
import org.broadinstitute.sting.utils.variantcontext.writer.BCF2FieldWriter;
import org.broadinstitute.sting.utils.variantcontext.writer.BCF2FieldWriterManager;
import org.broadinstitute.sting.utils.variantcontext.writer.IndexingVariantContextWriter;
import org.broadinstitute.sting.utils.variantcontext.writer.VCFWriter;

class BCF2Writer
extends IndexingVariantContextWriter {
    protected static final Logger logger = Logger.getLogger(BCF2Writer.class);
    private static final boolean ALLOW_MISSING_CONTIG_LINES = false;
    private final OutputStream outputStream;
    private VCFHeader header;
    private final Map<String, Integer> contigDictionary = new HashMap<String, Integer>();
    private final Map<String, Integer> stringDictionaryMap = new LinkedHashMap<String, Integer>();
    private final boolean doNotWriteGenotypes;
    private String[] sampleNames = null;
    private final BCF2Encoder encoder = new BCF2Encoder();
    final BCF2FieldWriterManager fieldManager = new BCF2FieldWriterManager();

    public BCF2Writer(File location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing, boolean doNotWriteGenotypes) {
        super(BCF2Writer.writerName(location, output), location, output, refDict, enableOnTheFlyIndexing);
        this.outputStream = this.getOutputStream();
        this.doNotWriteGenotypes = doNotWriteGenotypes;
    }

    @Override
    public void writeHeader(VCFHeader header) {
        if ((header = new VCFHeader(header.getMetaDataInSortedOrder(), header.getGenotypeSamples())).getContigLines().isEmpty()) {
            throw new UserException.MalformedBCF2("Cannot write BCF2 file with missing contig lines");
        }
        this.createContigDictionary(header.getContigLines());
        ArrayList dict = BCF2Utils.makeDictionary((VCFHeader)header);
        for (int i = 0; i < dict.size(); ++i) {
            this.stringDictionaryMap.put((String)dict.get(i), i);
        }
        this.sampleNames = header.getGenotypeSamples().toArray(new String[header.getNGenotypeSamples()]);
        this.fieldManager.setup(header, this.encoder, this.stringDictionaryMap);
        try {
            ByteArrayOutputStream capture = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(capture);
            this.header = VCFWriter.writeHeader(header, writer, this.doNotWriteGenotypes, VCFWriter.getVersionLine(), "BCF2 stream");
            writer.append('\u0000');
            writer.close();
            byte[] headerBytes = capture.toByteArray();
            this.outputStream.write(BCF2Utils.MAGIC_HEADER_LINE);
            BCF2Utils.encodeRawBytes((int)headerBytes.length, (BCF2Type)BCF2Type.INT32, (OutputStream)this.outputStream);
            this.outputStream.write(headerBytes);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile("BCF2 stream", "Got IOException while trying to write BCF2 header", (Exception)e);
        }
    }

    @Override
    public void add(VariantContext vc) {
        if (this.doNotWriteGenotypes) {
            vc = new VariantContextBuilder(vc).noGenotypes().make();
        }
        vc = vc.fullyDecode(this.header, false);
        super.add(vc);
        try {
            byte[] infoBlock = this.buildSitesData(vc);
            byte[] genotypesBlock = this.buildSamplesData(vc);
            this.writeBlock(infoBlock, genotypesBlock);
        }
        catch (IOException e) {
            throw new UserException("Error writing record to BCF2 file: " + vc.toString(), e);
        }
    }

    @Override
    public void close() {
        try {
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new UserException("Failed to close BCF2 file");
        }
        super.close();
    }

    private byte[] buildSitesData(VariantContext vc) throws IOException {
        int contigIndex = this.contigDictionary.get(vc.getChr());
        if (contigIndex == -1) {
            throw new UserException(String.format("Contig %s not found in sequence dictionary from reference", vc.getChr()));
        }
        this.encoder.encodeRawValue(contigIndex, BCF2Type.INT32);
        this.encoder.encodeRawValue(vc.getStart() - 1, BCF2Type.INT32);
        this.encoder.encodeRawValue(vc.getEnd() - vc.getStart() + 1, BCF2Type.INT32);
        if (vc.hasLog10PError()) {
            this.encoder.encodeRawFloat((float)vc.getPhredScaledQual());
        } else {
            this.encoder.encodeRawMissingValue(BCF2Type.FLOAT);
        }
        int nAlleles = vc.getNAlleles();
        int nInfo = vc.getAttributes().size();
        int nGenotypeFormatFields = this.getNGenotypeFormatFields(vc);
        int nSamples = this.header.getNGenotypeSamples();
        this.encoder.encodeRawInt(nAlleles << 16 | nInfo & 0xFFFF, BCF2Type.INT32);
        this.encoder.encodeRawInt(nGenotypeFormatFields << 24 | nSamples & 0xFFFFF, BCF2Type.INT32);
        this.buildID(vc);
        this.buildAlleles(vc);
        this.buildFilter(vc);
        this.buildInfo(vc);
        return this.encoder.getRecordBytes();
    }

    private BCF2Codec.LazyData getLazyData(VariantContext vc) {
        LazyGenotypesContext lgc;
        if (vc.getGenotypes().isLazyWithData() && (lgc = (LazyGenotypesContext)vc.getGenotypes()).getUnparsedGenotypeData() instanceof BCF2Codec.LazyData) {
            return (BCF2Codec.LazyData)lgc.getUnparsedGenotypeData();
        }
        return null;
    }

    private final int getNGenotypeFormatFields(VariantContext vc) {
        BCF2Codec.LazyData lazyData = this.getLazyData(vc);
        return lazyData != null ? lazyData.nGenotypeFields : VCFWriter.calcVCFGenotypeKeys(vc, this.header).size();
    }

    private void buildID(VariantContext vc) throws IOException {
        this.encoder.encodeTypedString(vc.getID());
    }

    private void buildAlleles(VariantContext vc) throws IOException {
        boolean needsPadding = VCFAlleleClipper.needsPadding(vc);
        for (Allele allele : vc.getAlleles()) {
            byte[] s;
            if (needsPadding) {
                allele = VCFAlleleClipper.padAllele(vc, allele);
            }
            if ((s = allele.getDisplayBases()) == null) {
                throw new ReviewedStingException("BUG: BCF2Writer encountered null padded allele" + allele);
            }
            this.encoder.encodeTypedString(s);
        }
    }

    private void buildFilter(VariantContext vc) throws IOException {
        if (vc.isFiltered()) {
            this.encodeStringsByRef(vc.getFilters());
        } else {
            this.encoder.encodeTypedMissing(BCF2Type.INT8);
        }
    }

    private void buildInfo(VariantContext vc) throws IOException {
        for (Map.Entry<String, Object> infoFieldEntry : vc.getAttributes().entrySet()) {
            String key = infoFieldEntry.getKey();
            BCF2FieldWriter.SiteWriter writer = this.fieldManager.getSiteFieldWriter(key);
            writer.start(this.encoder, vc);
            writer.site(this.encoder, vc);
            writer.done(this.encoder, vc);
        }
    }

    private byte[] buildSamplesData(VariantContext vc) throws IOException {
        BCF2Codec.LazyData lazyData = this.getLazyData(vc);
        if (lazyData != null) {
            return lazyData.bytes;
        }
        List<String> genotypeFields = VCFWriter.calcVCFGenotypeKeys(vc, this.header);
        for (String field : genotypeFields) {
            BCF2FieldWriter.GenotypesWriter writer = this.fieldManager.getGenotypeFieldWriter(field);
            writer.start(this.encoder, vc);
            for (String name : this.sampleNames) {
                Genotype g = vc.getGenotype(name);
                if (g == null) {
                    VCFWriter.missingSampleError(vc, this.header);
                }
                writer.addGenotype(this.encoder, vc, g);
            }
            writer.done(this.encoder, vc);
        }
        return this.encoder.getRecordBytes();
    }

    @Requires(value={"infoBlock.length > 0", "genotypesBlock.length >= 0"})
    private void writeBlock(byte[] infoBlock, byte[] genotypesBlock) throws IOException {
        BCF2Utils.encodeRawBytes((int)infoBlock.length, (BCF2Type)BCF2Type.INT32, (OutputStream)this.outputStream);
        BCF2Utils.encodeRawBytes((int)genotypesBlock.length, (BCF2Type)BCF2Type.INT32, (OutputStream)this.outputStream);
        this.outputStream.write(infoBlock);
        this.outputStream.write(genotypesBlock);
    }

    @Requires(value={"! strings.isEmpty()"})
    @Ensures(value={"result.isIntegerType()"})
    private final BCF2Type encodeStringsByRef(Collection<String> strings) throws IOException {
        ArrayList<Integer> offsets = new ArrayList<Integer>(strings.size());
        for (String string : strings) {
            Integer got = this.stringDictionaryMap.get(string);
            if (got == null) {
                throw new ReviewedStingException("Format error: could not find string " + string + " in header as required by BCF");
            }
            int offset = got;
            offsets.add(offset);
        }
        BCF2Type type = BCF2Utils.determineIntegerType(offsets);
        this.encoder.encodeTyped(offsets, type);
        return type;
    }

    @Requires(value={"contigDictionary.isEmpty()"})
    private final void createContigDictionary(Collection<VCFContigHeaderLine> contigLines) {
        int offset = 0;
        for (VCFContigHeaderLine contig : contigLines) {
            this.contigDictionary.put(contig.getID(), offset++);
        }
    }
}

