/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.collections;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.Interval;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.Locus;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.collections.CollUtils;

public class CachedIntervals<T extends Interval> {
    private Map<String, List<T>> map = Collections.synchronizedMap(new HashMap());
    private static final int DEFAULT_CACHE_SIZE = 5;
    private static final int DEFAULT_MAX_INTERVAL_SIZE = 10000000;
    protected int cacheSize = 5;
    protected int maxIntervalSize = 10000000;
    protected Map<String, List<Locus>> keepLocuses;

    public CachedIntervals() {
    }

    public CachedIntervals(int cacheSize, int maxIntervalSize) {
        this.cacheSize = cacheSize;
        this.maxIntervalSize = maxIntervalSize;
    }

    public List<T> getContains(final String chr, final int start, final int end, final int zoom) {
        Predicate<Interval> pred = new Predicate<Interval>(){

            @Override
            public boolean apply(Interval interval) {
                return interval.contains(chr, start, end, zoom);
            }
        };
        return this.getGen(chr, pred);
    }

    public List<T> getOverlaps(final String chr, final int start, final int end, final int zoom) {
        Predicate<Interval> pred = new Predicate<Interval>(){

            @Override
            public boolean apply(Interval interval) {
                return interval.overlaps(chr, start, end, zoom);
            }
        };
        return this.getGen(chr, pred);
    }

    public List<T> get(String seqName) {
        return this.getGen(seqName, null);
    }

    private List<T> getGen(String seqName, Predicate<Interval> predicate) {
        List<T> intervals = this.map.get(seqName);
        if (intervals == null) {
            return null;
        }
        List<Interval> returnedIntervals = predicate != null ? CollUtils.filter(intervals, predicate) : new ArrayList<T>(intervals);
        FeatureUtils.sortFeatureList(returnedIntervals);
        return returnedIntervals;
    }

    public synchronized void put(T addingInterval) {
        String key = addingInterval.getChr();
        List<T> intervals = this.map.get(key);
        if (intervals == null) {
            intervals = new LinkedList<T>();
            this.map.put(key, intervals);
            intervals.add(addingInterval);
        } else {
            List<T> overlaps = this.getOverlaps(addingInterval.getChr(), addingInterval.getStart(), addingInterval.getEnd(), addingInterval.getZoom());
            Interval overlap = null;
            boolean doMerge = false;
            if (overlaps != null && overlaps.size() > 0) {
                overlap = (Interval)overlaps.get(0);
                doMerge = overlap.canMerge((Interval)addingInterval);
            }
            if (doMerge) {
                overlap.merge((Interval)addingInterval);
                int intervalSize = overlap.getEnd() - overlap.getStart();
                if (intervalSize > this.maxIntervalSize) {
                    this.trimInterval(overlap);
                }
            } else {
                intervals.add(addingInterval);
            }
        }
        int effectiveCacheSize = this.keepLocuses.size() + this.cacheSize;
        if (intervals.size() > effectiveCacheSize) {
            this.removeOrphanedIntervals();
        }
    }

    private void trimInterval(Interval interval) {
        List<Locus> locusList = this.keepLocuses.get(interval.getChr());
        if (locusList == null || locusList.size() == 0) {
            return;
        }
        int locusStart = Integer.MAX_VALUE;
        int locusEnd = Integer.MIN_VALUE;
        boolean trim = false;
        for (Locus locus : locusList) {
            if (!locus.overlaps(interval.getChr(), interval.getStart(), interval.getEnd())) continue;
            locusStart = Math.min(locus.getStart(), locusStart);
            locusEnd = Math.max(locus.getEnd(), locusEnd);
            trim = true;
        }
        if (trim) {
            if (locusEnd - locusStart < this.maxIntervalSize) {
                int center = (locusStart + locusEnd) / 2;
                locusStart = Math.max(0, center - this.maxIntervalSize / 2);
                locusEnd = locusStart + this.maxIntervalSize;
            }
            interval.trimTo(interval.getChr(), locusStart, locusEnd, interval.getZoom());
        }
    }

    private synchronized void removeOrphanedIntervals() {
        Map newMap = Collections.synchronizedMap(new HashMap());
        for (Map.Entry<String, List<T>> entry : this.map.entrySet()) {
            String chr = entry.getKey();
            List<Locus> frameList = this.keepLocuses.get(chr);
            if (frameList == null) continue;
            List<T> intervalList = entry.getValue();
            block1: for (Interval interval : intervalList) {
                for (Locus keepLocus : frameList) {
                    if (!keepLocus.overlaps(chr, interval.getStart(), interval.getEnd())) continue;
                    ArrayList<Interval> newIntervalList = (ArrayList<Interval>)newMap.get(chr);
                    if (newIntervalList == null) {
                        newIntervalList = new ArrayList<Interval>();
                        newMap.put(chr, newIntervalList);
                    }
                    newIntervalList.add(interval);
                    continue block1;
                }
            }
        }
        this.map = newMap;
    }

    public int getMaxIntervalSize() {
        return this.maxIntervalSize;
    }

    public void setMaxIntervalSize(int maxIntervalSize) {
        this.maxIntervalSize = maxIntervalSize < 0 ? Integer.MAX_VALUE : maxIntervalSize;
    }

    public int size() {
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getLoadedIntervals() {
        ArrayList allLoadedIntervals = new ArrayList(this.map.size());
        Map<String, List<T>> map = this.map;
        synchronized (map) {
            for (Map.Entry<String, List<T>> entry : this.map.entrySet()) {
                allLoadedIntervals.addAll(entry.getValue());
            }
        }
        return allLoadedIntervals;
    }

    public void clear() {
        this.map.clear();
    }

    public void setLocusList(List<ReferenceFrame> allFramesList) {
        HashMap<String, List<Locus>> locusMap = new HashMap<String, List<Locus>>();
        for (ReferenceFrame frame : allFramesList) {
            List<Locus> chrFrameList = locusMap.get(frame.getChrName());
            if (chrFrameList == null) {
                chrFrameList = new ArrayList<Locus>();
                locusMap.put(frame.getChrName(), chrFrameList);
            }
            chrFrameList.add(new Locus(frame.getChrName(), (int)frame.getOrigin(), (int)frame.getEnd()));
        }
        this.keepLocuses = locusMap;
    }
}

