/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import apple.dts.samplecode.osxadapter.OSXAdapter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.jidesoft.swing.JideSplitPane;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.batch.BatchRunner;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.dev.affective.AffectiveGenome;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.MaximumContigGenomeException;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeBuilderDialog;
import org.broad.igv.feature.genome.GenomeException;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.GeneList;
import org.broad.igv.lists.GeneListManager;
import org.broad.igv.lists.Preloader;
import org.broad.igv.peaks.PeakCommandBar;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.reader.BAMHttpReader;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionReader;
import org.broad.igv.session.UCSCSessionReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackLoader;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGVCommandBar;
import org.broad.igv.ui.IGVContentPane;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.Main;
import org.broad.igv.ui.MessageCollection;
import org.broad.igv.ui.PreferencesEditor;
import org.broad.igv.ui.StatusWindow;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.dnd.GhostGlassPane;
import org.broad.igv.ui.event.AlignmentTrackEvent;
import org.broad.igv.ui.event.AlignmentTrackEventListener;
import org.broad.igv.ui.event.TrackGroupEvent;
import org.broad.igv.ui.event.TrackGroupEventListener;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.DataPanelContainer;
import org.broad.igv.ui.panel.DragEventManager;
import org.broad.igv.ui.panel.DragListener;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.RegionNavigatorDialog;
import org.broad.igv.ui.panel.RegionOfInterestPanel;
import org.broad.igv.ui.panel.RegionOfInterestTool;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.ui.util.CheckListDialog;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.ui.util.IndefiniteProgressMonitor;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.SnapshotFileChooser;
import org.broad.igv.ui.util.SnapshotUtilities;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.collections.LRUCache;
import org.broad.igv.variant.VariantTrack;
import org.broad.tribble.util.SeekableFileStream;

public class IGV {
    private static Logger log = Logger.getLogger(IGV.class);
    private static IGV theInstance;
    private Frame mainFrame;
    private JRootPane rootPane;
    private IGVContentPane contentPane;
    private IGVMenuBar menuBar;
    private StatusWindow statusWindow;
    Component glassPane;
    GhostGlassPane dNdGlassPane;
    public static Cursor fistCursor;
    public static Cursor zoomInCursor;
    public static Cursor zoomOutCursor;
    public static Cursor dragNDropCursor;
    Session session;
    private GenomeManager genomeManager;
    private String groupByAttribute = null;
    private Map<String, List<Track>> overlayTracksMap = new HashMap<String, List<Track>>();
    private Set<Track> overlaidTracks = new HashSet<Track>();
    public static final String DATA_PANEL_NAME = "DataPanel";
    public static final String FEATURE_PANEL_NAME = "FeaturePanel";
    private LinkedList<String> recentSessionList = new LinkedList();
    private boolean isExportingSnapshot = false;
    Collection<SoftReference<TrackGroupEventListener>> groupListeners = Collections.synchronizedCollection(new ArrayList());
    Collection<SoftReference<AlignmentTrackEventListener>> alignmentTrackListeners = Collections.synchronizedCollection(new ArrayList());
    JCheckBoxMenuItem showPeakMenuItem;
    PeakCommandBar peakCommandBar;

    public static IGV createInstance(Frame frame) {
        if (theInstance != null) {
            throw new RuntimeException("Only a single instance is allowed.");
        }
        theInstance = new IGV(frame);
        return theInstance;
    }

    public static IGV getInstance() {
        if (theInstance == null) {
            throw new RuntimeException("IGV has not been initialized.  Must call createInstance(Frame) first");
        }
        return theInstance;
    }

    static void destroyInstance() {
        theInstance = null;
    }

    public static boolean hasInstance() {
        return theInstance != null;
    }

    public static JRootPane getRootPane() {
        return IGV.getInstance().rootPane;
    }

    public static Frame getMainFrame() {
        return IGV.getInstance().mainFrame;
    }

    private IGV(Frame frame) {
        theInstance = this;
        this.genomeManager = GenomeManager.getInstance();
        this.mainFrame = frame;
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                this.windowCloseEvent();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                this.windowCloseEvent();
            }

            private void windowCloseEvent() {
                PreferenceManager.getInstance().setApplicationFrameBounds(IGV.this.mainFrame.getBounds());
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                ToolTipManager.sharedInstance().setEnabled(false);
                ToolTipManager.sharedInstance().setEnabled(true);
                IGVPopupMenu.closeAll();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                ToolTipManager.sharedInstance().setEnabled(false);
                ToolTipManager.sharedInstance().setEnabled(true);
                IGVPopupMenu.closeAll();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
            }
        });
        this.session = new Session(null);
        this.createHandCursor();
        this.createZoomCursors();
        this.createDragAndDropCursor();
        this.mainFrame.setTitle("IGV");
        if (this.mainFrame instanceof JFrame) {
            JFrame jf = (JFrame)this.mainFrame;
            this.rootPane = jf.getRootPane();
        } else {
            this.rootPane = new JRootPane();
            this.mainFrame.add(this.rootPane);
        }
        this.contentPane = new IGVContentPane(this);
        this.menuBar = new IGVMenuBar(this);
        this.rootPane.setContentPane(this.contentPane);
        this.rootPane.setJMenuBar(this.menuBar);
        this.glassPane = this.rootPane.getGlassPane();
        this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
        this.glassPane.addMouseListener(new MouseAdapter(){});
        this.dNdGlassPane = new GhostGlassPane();
        this.mainFrame.pack();
        Dimension screenBounds = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle applicationBounds = PreferenceManager.getInstance().getApplicationFrameBounds();
        int state = PreferenceManager.getInstance().getAsInt("IGV.Frame.ExtendedState");
        if (applicationBounds == null || applicationBounds.getMaxX() > screenBounds.getWidth() || applicationBounds.getMaxY() > screenBounds.getHeight()) {
            int width = Math.min(1150, (int)screenBounds.getWidth());
            int height = Math.min(800, (int)screenBounds.getHeight());
            applicationBounds = new Rectangle(0, 0, width, height);
        }
        this.mainFrame.setMinimumSize(new Dimension(300, 300));
        this.mainFrame.setExtendedState(state);
        this.mainFrame.setBounds(applicationBounds);
        BAMHttpReader.cleanTempDir(432000000L);
    }

    public void repaint() {
        this.mainFrame.repaint();
    }

    public GhostGlassPane getDnDGlassPane() {
        return this.dNdGlassPane;
    }

    public void startDnD() {
        this.rootPane.setGlassPane(this.dNdGlassPane);
        this.dNdGlassPane.setVisible(true);
    }

    public void endDnD() {
        this.rootPane.setGlassPane(this.glassPane);
        this.glassPane.setVisible(false);
    }

    public Dimension getPreferredSize() {
        return UIConstants.preferredSize;
    }

    public void addRegionOfInterest(RegionOfInterest roi) {
        this.session.addRegionOfInterestWithNoListeners(roi);
        RegionOfInterestPanel.setSelectedRegion(roi);
        this.doRefresh();
    }

    void beginROI(JButton button) {
        for (TrackPanel tp : this.getTrackPanels()) {
            TrackPanelScrollPane tsv = tp.getScrollPane();
            DataPanelContainer dpc = tsv.getDataPanel();
            for (Component c : dpc.getComponents()) {
                if (!(c instanceof DataPanel)) continue;
                DataPanel dp = (DataPanel)c;
                RegionOfInterestTool regionOfInterestTool = new RegionOfInterestTool(dp, button);
                dp.setCurrentTool(regionOfInterestTool);
            }
        }
    }

    public void endROI() {
        for (TrackPanel tp : this.getTrackPanels()) {
            DataPanelContainer dp = tp.getScrollPane().getDataPanel();
            dp.setCurrentTool(null);
        }
    }

    public void chromosomeChangeEvent(String chrName) {
        this.chromosomeChangeEvent(chrName, true);
    }

    public void chromosomeChangeEvent(String chrName, boolean updateCommandBar) {
        this.contentPane.chromosomeChanged(chrName);
        this.repaintDataAndHeaderPanels(updateCommandBar);
        this.contentPane.getCommandBar().updateComponentStates();
    }

    public void repaintStatusAndZoomSlider() {
        this.contentPane.getCommandBar().repaint();
    }

    public static void repaintPanelsHeadlessSafe() {
        if (IGV.hasInstance() && !Globals.isHeadless()) {
            IGV.getInstance().repaintDataAndHeaderPanels();
            IGV.getInstance().repaintStatusAndZoomSlider();
        }
    }

    public void repaintDataAndHeaderPanels() {
        this.repaintDataAndHeaderPanels(true);
    }

    public void repaintDataPanels() {
        this.repaintDataAndHeaderPanels(false);
    }

    public void repaintDataAndHeaderPanels(boolean updateCommandBar) {
        if (Globals.isBatch()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    IGV.this.contentPane.revalidateDataPanels();
                    IGV.this.rootPane.paintImmediately(IGV.this.rootPane.getBounds());
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (InterruptedException e) {
                    log.error(e);
                }
                catch (InvocationTargetException e) {
                    log.error(e.getMessage());
                    throw new RuntimeException(e);
                }
            }
        } else {
            this.contentPane.revalidateDataPanels();
            this.rootPane.repaint();
        }
        if (updateCommandBar) {
            this.contentPane.updateCurrentCoordinates();
        }
    }

    public void repaintNamePanels() {
        for (TrackPanel tp : this.getTrackPanels()) {
            tp.getScrollPane().getNamePanel().repaint();
        }
    }

    public void selectGenomeFromList(String genomeId) {
        this.contentPane.getCommandBar().selectGenome(genomeId);
    }

    public Collection<String> getSelectableGenomeIDs() {
        return this.contentPane.getCommandBar().getSelectableGenomeIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDefineGenome(ProgressMonitor monitor) {
        String genomePath;
        ProgressBar bar = null;
        File archiveFile = null;
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            GenomeBuilderDialog genomeBuilderDialog = new GenomeBuilderDialog(this.mainFrame, this);
            genomeBuilderDialog.setVisible(true);
            File genomeZipFile = genomeBuilderDialog.getArchiveFile();
            if (genomeBuilderDialog.isCanceled() || genomeZipFile == null) {
                return;
            }
            if (monitor != null) {
                bar = ProgressBar.showProgressDialog(this.mainFrame, "Defining Genome...", monitor, false);
            }
            String cytobandFileName = genomeBuilderDialog.getCytobandFileName();
            String refFlatFileName = genomeBuilderDialog.getRefFlatFileName();
            String fastaFileName = genomeBuilderDialog.getFastaFileName();
            String chrAliasFile = genomeBuilderDialog.getChrAliasFileName();
            String genomeDisplayName = genomeBuilderDialog.getGenomeDisplayName();
            String genomeId = genomeBuilderDialog.getGenomeId();
            GenomeListItem genomeListItem = this.getGenomeManager().defineGenome(genomeZipFile, cytobandFileName, refFlatFileName, fastaFileName, chrAliasFile, genomeDisplayName, genomeId, monitor);
            if (genomeListItem != null) {
                this.contentPane.getCommandBar().refreshGenomeListComboBox();
                this.contentPane.getCommandBar().selectGenome(genomeListItem.getId());
            }
            if (monitor != null) {
                monitor.fireProgressChange(100);
            }
        }
        catch (MaximumContigGenomeException e) {
            genomePath = "";
            if (archiveFile != null) {
                genomePath = archiveFile.getAbsolutePath();
            }
            log.error("Failed to define genome: " + genomePath, e);
            JOptionPane.showMessageDialog(this.mainFrame, "Failed to define the current genome " + genomePath + "\n" + e.getMessage());
        }
        catch (GenomeException e) {
            log.error("Failed to define genome.", e);
            MessageUtils.showMessage(e.getMessage());
        }
        catch (Exception e) {
            genomePath = "";
            if (archiveFile != null) {
                genomePath = archiveFile.getAbsolutePath();
            }
            log.error("Failed to define genome: " + genomePath, e);
            MessageUtils.showMessage("Unexpected error while importing a genome: " + e.getMessage());
        }
        finally {
            if (bar != null) {
                bar.close();
            }
            WaitCursorManager.removeWaitCursor(token);
        }
    }

    public GenomeListItem getGenomeSelectedInDropdown() {
        return this.contentPane.getCommandBar().getGenomeSelectedInDropdown();
    }

    public Collection<String> getGenomeDisplayNames() {
        return this.contentPane.getCommandBar().getGenomeDisplayNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadGenome(ProgressMonitor monitor) {
        ProgressBar bar = null;
        File file = null;
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            File importDirectory = PreferenceManager.getInstance().getLastGenomeImportDirectory();
            if (importDirectory == null) {
                PreferenceManager.getInstance().setLastGenomeImportDirectory(DirectoryManager.getUserDirectory());
            }
            if ((file = FileDialogUtils.chooseFile("Load Genome", importDirectory, 0)) != null) {
                if (monitor != null) {
                    bar = ProgressBar.showProgressDialog(this.mainFrame, "Loading Genome...", monitor, false);
                }
                this.loadGenome(file.getAbsolutePath(), monitor);
            }
        }
        catch (IOException e) {
            MessageUtils.showMessage("<html>Error loading: " + file.getAbsolutePath() + "<br>" + e.getMessage());
            log.error("Error loading: " + file.getAbsolutePath(), e);
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
            if (monitor != null) {
                monitor.fireProgressChange(100);
            }
            if (bar != null) {
                bar.close();
            }
        }
    }

    public void loadGenome(String path, ProgressMonitor monitor) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            File directory = file.getParentFile();
            PreferenceManager.getInstance().setLastGenomeImportDirectory(directory);
        }
        this.resetSession(null);
        Genome genome = this.getGenomeManager().loadGenome(path, monitor);
        if (genome == null) {
            return;
        }
        String name = genome.getDisplayName();
        String id = genome.getId();
        GenomeListItem genomeListItem = new GenomeListItem(name, path, id);
        this.getGenomeManager().addGenomeItem(genomeListItem);
        IGVCommandBar cmdBar = this.contentPane.getCommandBar();
        cmdBar.refreshGenomeListComboBox();
        cmdBar.selectGenome(genomeListItem.getId());
        cmdBar.updateChromosFromGenome(genome);
    }

    public void enableExtrasMenu() {
        this.menuBar.enableExtrasMenu();
    }

    public void loadTracks(final Collection<ResourceLocator> locators) {
        this.contentPane.getStatusBar().setMessage("Loading ...");
        log.debug("Run loadTracks");
        if (locators != null && !locators.isEmpty()) {
            NamedRunnable runnable = new NamedRunnable(){

                @Override
                public void run() {
                    HashMap<TrackPanelScrollPane, Integer> trackCountMap = new HashMap<TrackPanelScrollPane, Integer>();
                    HashMap<TrackPanelScrollPane, Integer> panelSizeMap = new HashMap<TrackPanelScrollPane, Integer>();
                    for (TrackPanel tp : IGV.this.getTrackPanels()) {
                        TrackPanelScrollPane sp = tp.getScrollPane();
                        trackCountMap.put(sp, sp.getDataPanel().getAllTracks().size());
                        panelSizeMap.put(sp, sp.getDataPanel().getHeight());
                    }
                    IGV.this.loadResources(locators);
                    double totalHeight = 0.0;
                    for (TrackPanel tp : IGV.this.getTrackPanels()) {
                        int prevTrackCount;
                        TrackPanelScrollPane sp = tp.getScrollPane();
                        if (trackCountMap.containsKey(sp) && (prevTrackCount = ((Integer)trackCountMap.get(sp)).intValue()) != sp.getDataPanel().getAllTracks().size()) {
                            int scrollPosition = (Integer)panelSizeMap.get(sp);
                            if (prevTrackCount != 0 && sp.getVerticalScrollBar().isShowing()) {
                                sp.getVerticalScrollBar().setMaximum(sp.getDataPanel().getHeight());
                                sp.getVerticalScrollBar().setValue(scrollPosition);
                            }
                        }
                        if (sp.getTrackPanel().getTracks().size() <= 0) continue;
                        totalHeight += (double)Math.min(300, sp.getTrackPanel().getPreferredPanelHeight());
                    }
                    JideSplitPane centerSplitPane = IGV.this.contentPane.getMainPanel().getCenterSplitPane();
                    int htotal = centerSplitPane.getHeight();
                    int y = 0;
                    int i = 0;
                    for (Component c : centerSplitPane.getComponents()) {
                        if (!(c instanceof TrackPanelScrollPane)) continue;
                        TrackPanel trackPanel = ((TrackPanelScrollPane)c).getTrackPanel();
                        if (trackPanel.getTracks().size() > 0) {
                            int panelWeight = Math.min(300, trackPanel.getPreferredPanelHeight());
                            int dh = (int)((double)panelWeight / totalHeight * (double)htotal);
                            y += dh;
                        }
                        centerSplitPane.setDividerLocation(i, y);
                        ++i;
                    }
                    IGV.this.contentPane.getMainPanel().invalidate();
                    IGV.this.showLoadedTrackCount();
                    boolean affective = PreferenceManager.getInstance().getAsBoolean("AFFECTIVE_ENABLE");
                    if (affective) {
                        IGV.this.contentPane.getCommandBar().updateChromosomeDropdown();
                    }
                }

                @Override
                public String getName() {
                    return "Load Tracks";
                }
            };
            LongRunningTask.submit(runnable);
        }
        log.debug("Finish loadTracks");
    }

    public void setGeneList(String listID) {
        this.setGeneList(listID, true);
    }

    public void setGeneList(final String listID, final boolean recordHistory) {
        final WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        SwingUtilities.invokeLater(new NamedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (listID == null) {
                        IGV.this.session.setCurrentGeneList(null);
                    } else {
                        GeneList gl = GeneListManager.getInstance().getGeneList(listID);
                        if (recordHistory) {
                            IGV.this.session.getHistory().push("List: " + listID, 0);
                        }
                        IGV.this.session.setCurrentGeneList(gl);
                    }
                    Preloader.preload();
                    IGV.this.resetFrames();
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }

            @Override
            public String getName() {
                return "Set gene list";
            }
        });
    }

    public void setDefaultFrame(String searchString) {
        FrameManager.setToDefaultFrame(searchString);
        this.resetFrames();
    }

    public void resetFrames() {
        this.contentPane.getMainPanel().headerPanelContainer.createHeaderPanels();
        for (TrackPanel tp : this.getTrackPanels()) {
            tp.createDataPanels();
        }
        this.contentPane.getCommandBar().setGeneListMode(FrameManager.isGeneListMode());
        this.contentPane.getMainPanel().applicationHeaderPanel.revalidate();
        this.contentPane.getMainPanel().validate();
        this.contentPane.getMainPanel().repaint();
    }

    public final void doViewPreferences() {
        this.doViewPreferences(null);
    }

    public final void doViewPreferences(final String tabToSelect) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean originalSingleTrackValue = PreferenceManager.getInstance().getAsBoolean("IGV.single.track.pane");
                PreferencesEditor dialog = new PreferencesEditor(IGV.this.mainFrame, true);
                if (tabToSelect != null) {
                    dialog.selectTab(tabToSelect);
                }
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    IGV.this.resetStatusMessage();
                    return;
                }
                try {
                    boolean singlePanel = PreferenceManager.getInstance().getAsBoolean("IGV.single.track.pane");
                    if (originalSingleTrackValue != singlePanel) {
                        JOptionPane.showMessageDialog(IGV.this.mainFrame, "Panel option change will take affect after restart.");
                    }
                }
                finally {
                    IGV.this.doRefresh();
                    IGV.this.resetStatusMessage();
                }
            }
        });
    }

    public final void saveStateForExit() {
        if (!this.getRecentSessionList().isEmpty()) {
            int size = this.getRecentSessionList().size();
            if (size > 3) {
                size = 3;
            }
            String recentSessions = "";
            for (int i = 0; i < size; ++i) {
                recentSessions = recentSessions + this.getRecentSessionList().get(i);
                if (i >= size - 1) continue;
                recentSessions = recentSessions + ";";
            }
            PreferenceManager.getInstance().remove("IGV.Session.recent.sessions");
            PreferenceManager.getInstance().setRecentSessions(recentSessions);
        }
        PreferenceManager.getInstance().setApplicationFrameBounds(this.mainFrame.getBounds());
        PreferenceManager.getInstance().put("IGV.Frame.ExtendedState", "" + this.mainFrame.getExtendedState());
    }

    public final void doShowAttributeDisplay(boolean enableAttributeView) {
        boolean oldState = PreferenceManager.getInstance().getAsBoolean("IGV.track.show.attribute.views");
        PreferenceManager.getInstance().setShowAttributeView(enableAttributeView);
        if (oldState != enableAttributeView) {
            this.doRefresh();
        }
    }

    public final void doRefresh() {
        this.contentPane.getMainPanel().revalidate();
        this.mainFrame.repaint();
        this.contentPane.getCommandBar().updateComponentStates();
    }

    public final void refreshCommandBar() {
        this.contentPane.getCommandBar().updateCurrentCoordinates();
    }

    public final void doSelectDisplayableAttribute() {
        List<String> allAttributes = AttributeManager.getInstance().getAttributeNames();
        Set<String> hiddenAttributes = IGV.getInstance().getSession().getHiddenAttributes();
        CheckListDialog dlg = new CheckListDialog(this.mainFrame, allAttributes, hiddenAttributes, false);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            IGV.getInstance().getSession().setHiddenAttributes(dlg.getNonSelections());
            this.doRefresh();
        }
    }

    public final void saveImage(Component target) {
        this.saveImage(target, "igv_snapshot");
    }

    public final void saveImage(Component target, String title) {
        this.contentPane.getStatusBar().setMessage("Creating image...");
        File defaultFile = new File(title + ".png");
        this.createSnapshot(target, defaultFile);
    }

    public boolean isExportingSnapshot() {
        return this.isExportingSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createSnapshot(Component target, File defaultFile) {
        File file = this.selectSnapshotFile(defaultFile);
        if (file == null) {
            return;
        }
        WaitCursorManager.CursorToken token = null;
        try {
            token = WaitCursorManager.showWaitCursor();
            this.contentPane.getStatusBar().setMessage("Exporting image: " + defaultFile.getAbsolutePath());
            this.createSnapshotNonInteractive(target, file);
        }
        catch (IOException e) {
            log.error("Error creating exporting image ", e);
            MessageUtils.showMessage("Error creating the image file: " + defaultFile + "<br> " + e.getMessage());
        }
        finally {
            if (token != null) {
                WaitCursorManager.removeWaitCursor(token);
            }
            this.resetStatusMessage();
        }
    }

    public void createSnapshotNonInteractive(File file) throws IOException {
        this.createSnapshotNonInteractive(this.contentPane.getMainPanel(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSnapshotNonInteractive(Component target, File file) throws IOException {
        log.debug("Creating snapshot: " + file.getName());
        String extension = FileUtils.getFileExtension(file.getAbsolutePath());
        SnapshotFileChooser.SnapshotFileType type = SnapshotFileChooser.getSnapshotFileType(extension);
        Object exc = null;
        if (type != SnapshotFileChooser.SnapshotFileType.NULL) {
            try {
                this.setExportingSnapshot(true);
                SnapshotUtilities.doComponentSnapshot(target, file, type);
            }
            finally {
                this.setExportingSnapshot(false);
            }
            log.debug("Finished creating snapshot: " + file.getName());
            if (exc != null) {
                throw exc;
            }
        } else {
            log.error("Unknown file extension " + extension);
        }
    }

    public File selectSnapshotFile(File defaultFile) {
        File directory;
        File snapshotDirectory = PreferenceManager.getInstance().getLastSnapshotDirectory();
        SnapshotFileChooser fc = new SnapshotFileChooser(snapshotDirectory, defaultFile);
        fc.showSaveDialog(this.mainFrame);
        File file = fc.getSelectedFile();
        if (file != null && (directory = file.getParentFile()) != null) {
            PreferenceManager.getInstance().setLastSnapshotDirectory(directory);
        }
        return file;
    }

    private void createZoomCursors() throws HeadlessException, IndexOutOfBoundsException {
        if (zoomInCursor == null || zoomOutCursor == null) {
            Image zoomInImage = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_IN).getImage();
            Image zoomOutImage = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_OUT).getImage();
            Point hotspot = new Point(10, 10);
            zoomInCursor = this.mainFrame.getToolkit().createCustomCursor(zoomInImage, hotspot, "Zoom in");
            zoomOutCursor = this.mainFrame.getToolkit().createCustomCursor(zoomOutImage, hotspot, "Zoom out");
        }
    }

    private void createHandCursor() throws HeadlessException, IndexOutOfBoundsException {
        if (fistCursor == null) {
            BufferedImage handImage = new BufferedImage(32, 32, 2);
            Graphics2D g = handImage.createGraphics();
            g.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 32.0, 32.0);
            g.fill(rect);
            g = handImage.createGraphics();
            g.drawImage(IconFactory.getInstance().getIcon(IconFactory.IconID.FIST).getImage(), 0, 0, null);
            fistCursor = this.mainFrame.getToolkit().createCustomCursor(handImage, new Point(8, 6), "Move");
        }
    }

    private void createDragAndDropCursor() throws HeadlessException, IndexOutOfBoundsException {
        if (dragNDropCursor == null) {
            ImageIcon icon = IconFactory.getInstance().getIcon(IconFactory.IconID.DRAG_AND_DROP);
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            BufferedImage dragNDropImage = new BufferedImage(width, height, 2);
            Graphics2D g = dragNDropImage.createGraphics();
            g.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
            g.fill(rect);
            g = dragNDropImage.createGraphics();
            Image image = icon.getImage();
            g.drawImage(image, 0, 0, null);
            dragNDropCursor = this.mainFrame.getToolkit().createCustomCursor(dragNDropImage, new Point(0, 0), "Drag and Drop");
        }
    }

    public void resetSession(String sessionPath) {
        LRUCache.clearCaches();
        AttributeManager.getInstance().clearAllAttributes();
        String tile = sessionPath == null ? "IGV" : sessionPath;
        this.mainFrame.setTitle(tile);
        this.menuBar.resetSessionActions();
        AttributeManager.getInstance().clearAllAttributes();
        if (this.session == null) {
            this.session = new Session(sessionPath);
        } else {
            this.session.reset(sessionPath);
        }
        this.alignmentTrackListeners.clear();
        this.groupListeners.clear();
        this.contentPane.getMainPanel().resetPanels();
        SeekableFileStream.closeAllInstances();
        this.doRefresh();
    }

    public void setStatusBarMessage(String message) {
        if (message.equals("Done.")) {
            this.resetStatusMessage();
        }
        this.contentPane.getStatusBar().setMessage(message);
    }

    public void setStatusBarPosition(String message) {
        this.contentPane.getStatusBar().setMessage2(message);
    }

    public void resetToFactorySettings() {
        try {
            PreferenceManager.getInstance().clear();
            boolean isShow = PreferenceManager.getInstance().getAsBoolean("IGV.track.show.attribute.views");
            this.doShowAttributeDisplay(isShow);
            Preferences prefs = Preferences.userNodeForPackage(Globals.class);
            prefs.remove("igvDir");
            this.doRefresh();
        }
        catch (Exception e) {
            String message = "Failure while resetting preferences!";
            log.error(message, e);
            MessageUtils.showMessage(message + ": " + e.getMessage());
        }
    }

    public void setFilterMatchAll(boolean value) {
        this.menuBar.setFilterMatchAll(value);
    }

    public boolean isFilterMatchAll() {
        return this.menuBar.isFilterMatchAll();
    }

    public void setFilterShowAllTracks(boolean value) {
        this.menuBar.setFilterShowAllTracks(value);
    }

    public boolean isFilterShowAllTracks() {
        return this.menuBar.isFilterShowAllTracks();
    }

    public TrackPanelScrollPane addDataPanel(String name) {
        return this.contentPane.getMainPanel().addDataPanel(name);
    }

    public TrackPanel getTrackPanel(String name) {
        for (TrackPanel sp : this.getTrackPanels()) {
            if (!name.equals(sp.getName())) continue;
            return sp;
        }
        TrackPanelScrollPane sp = this.addDataPanel(name);
        return sp.getTrackPanel();
    }

    public List<TrackPanel> getTrackPanels() {
        return this.contentPane.getMainPanel().getTrackPanels();
    }

    public boolean scrollToTrack(String trackName) {
        for (TrackPanel tp : this.getTrackPanels()) {
            if (!tp.getScrollPane().getNamePanel().scrollTo(trackName)) continue;
            return true;
        }
        return false;
    }

    public Session getSession() {
        return this.session;
    }

    public final void doRestoreSession(File sessionFile, String locus) {
        if (sessionFile.exists()) {
            this.doRestoreSession(sessionFile.getAbsolutePath(), locus, false);
        } else {
            String message = "Session file does not exist! : " + sessionFile.getAbsolutePath();
            log.error(message);
            MessageUtils.showMessage(message);
        }
    }

    public void doRestoreSession(final String sessionPath, final String locus, final boolean merge) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IGV.this.restoreSessionSynchronous(sessionPath, locus, merge);
            }
        };
        LongRunningTask.submit(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restoreSessionSynchronous(String sessionPath, String locus, boolean merge) {
        InputStream inputStream = null;
        try {
            String searchText;
            if (!merge) {
                this.resetSession(sessionPath);
            }
            this.setStatusBarMessage("Opening session...");
            inputStream = new BufferedInputStream(ParsingUtils.openInputStreamGZ(new ResourceLocator(sessionPath)));
            boolean isUCSC = sessionPath.endsWith(".session");
            SessionReader sessionReader = isUCSC ? new UCSCSessionReader(this) : new IGVSessionReader(this);
            sessionReader.loadSession(inputStream, this.session, sessionPath);
            String string = searchText = locus == null ? this.session.getLocus() : locus;
            if (!FrameManager.isGeneListMode() && searchText != null && !searchText.equals("All") && searchText.trim().length() > 0) {
                this.goToLocus(searchText);
            }
            this.mainFrame.setTitle("IGV - Session: " + sessionPath);
            LRUCache.clearCaches();
            double[] dividerFractions = this.session.getDividerFractions();
            if (dividerFractions != null) {
                this.contentPane.getMainPanel().setDividerFractions(dividerFractions);
            }
            this.session.clearDividerLocations();
            RegionNavigatorDialog.destroyInstance();
            if (!this.getRecentSessionList().contains(sessionPath)) {
                this.getRecentSessionList().addFirst(sessionPath);
            }
            this.doRefresh();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Error loading session", e);
            String message = "Error loading session session : <br>&nbsp;&nbsp;" + sessionPath + "<br>" + e.getMessage();
            MessageUtils.showMessage(message);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing session stream", iOException);
                }
                this.resetStatusMessage();
            }
        }
    }

    public void resetStatusMessage() {
        this.contentPane.getStatusBar().setMessage("" + this.getVisibleTrackCount() + " tracks loaded");
    }

    public void rebuildGenomeDropdownList() {
        GenomeManager.getInstance().buildGenomeItemList();
        this.contentPane.getCommandBar().refreshGenomeListComboBox();
    }

    public void showLoadedTrackCount() {
        int visibleTrackCount = this.getVisibleTrackCount();
        this.contentPane.getStatusBar().setMessage("" + visibleTrackCount + (visibleTrackCount == 1 ? " track" : " tracks"));
    }

    private void closeWindow(final ProgressBar progressBar) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                progressBar.close();
            }
        });
    }

    public void goToLocus(String locus) {
        this.contentPane.getCommandBar().searchByLocus(locus);
    }

    public void goToLociList(List<String> loci) {
        List<ReferenceFrame> frames = FrameManager.getFrames();
        if (frames.size() == loci.size()) {
            for (int i = 0; i < loci.size(); ++i) {
                frames.get(i).jumpTo(new Locus(loci.get(i)));
            }
            this.repaint();
        } else {
            GeneList geneList = new GeneList("", loci, false);
            this.getSession().setCurrentGeneList(geneList);
            this.resetFrames();
        }
    }

    public void tweakPanelDivider() {
        this.contentPane.getMainPanel().tweakPanelDivider();
    }

    public void removeDataPanel(String name) {
        this.contentPane.getMainPanel().removeDataPanel(name);
    }

    public void layoutMainPanel() {
        this.contentPane.getMainPanel().doLayout();
    }

    public MainPanel getMainPanel() {
        return this.contentPane.getMainPanel();
    }

    public void setExportingSnapshot(boolean exportingSnapshot) {
        this.isExportingSnapshot = exportingSnapshot;
        if (this.isExportingSnapshot) {
            RepaintManager.currentManager(this.contentPane).setDoubleBufferingEnabled(false);
        } else {
            RepaintManager.currentManager(this.contentPane).setDoubleBufferingEnabled(true);
        }
    }

    public LinkedList<String> getRecentSessionList() {
        return this.recentSessionList;
    }

    public void setRecentSessionList(LinkedList<String> recentSessionList) {
        this.recentSessionList = recentSessionList;
    }

    public IGVContentPane getContentPane() {
        return this.contentPane;
    }

    public GenomeManager getGenomeManager() {
        return this.genomeManager;
    }

    public void addCommandBar(PeakCommandBar cb) {
        this.peakCommandBar = cb;
        this.contentPane.add(this.peakCommandBar);
        this.contentPane.invalidate();
        this.showPeakMenuItem = new JCheckBoxMenuItem("Show peaks toolbar");
        this.showPeakMenuItem.setSelected(true);
        this.showPeakMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IGV.this.showPeakMenuItem.isSelected()) {
                    IGV.this.contentPane.add(IGV.this.peakCommandBar);
                } else {
                    IGV.this.contentPane.remove(IGV.this.peakCommandBar);
                }
            }
        });
        this.menuBar.getViewMenu().addSeparator();
        this.menuBar.getViewMenu().add(this.showPeakMenuItem);
    }

    public boolean isShowDetailsOnClick() {
        return this.contentPane != null && this.contentPane.getCommandBar().getDetailsBehavior() == IGVCommandBar.SHOW_DETAILS_BEHAVIOR.CLICK;
    }

    public boolean isShowDetailsOnHover() {
        return this.contentPane != null && this.contentPane.getCommandBar().getDetailsBehavior() == IGVCommandBar.SHOW_DETAILS_BEHAVIOR.HOVER;
    }

    public void openStatusWindow() {
        if (this.statusWindow == null) {
            this.statusWindow = new StatusWindow();
        }
        this.statusWindow.setVisible(true);
    }

    public void setStatusWindowText(String text) {
        if (this.statusWindow != null && this.statusWindow.isVisible()) {
            this.statusWindow.updateText(text);
        }
    }

    public void loadResources(Collection<ResourceLocator> locators) {
        log.info("Loading " + locators.size() + " resources.");
        final MessageCollection messages = new MessageCollection();
        ArrayList threads = new ArrayList(locators.size());
        for (final ResourceLocator locator : locators) {
            File trackSetFile;
            if (locator.isLocal() && !(trackSetFile = new File(locator.getPath())).exists()) {
                messages.append("File not found: " + locator.getPath() + "\n");
                continue;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        List<Track> tracks = IGV.this.load(locator);
                        if (tracks.size() > 0) {
                            Track t;
                            String path = locator.getPath();
                            TrackPanel panel = IGV.this.getPanelFor(locator);
                            if ((path.endsWith(".vcf") || path.endsWith(".vcf.gz") || path.endsWith(".vcf4") || path.endsWith(".vcf4.gz")) && (t = tracks.get(0)) instanceof VariantTrack && ((VariantTrack)t).getAllSamples().size() > 10) {
                                String newPanelName = "Panel" + System.currentTimeMillis();
                                panel = IGV.this.addDataPanel(newPanelName).getTrackPanel();
                            }
                            panel.addTracks(tracks);
                        }
                    }
                    catch (Exception e) {
                        log.error("Error loading tracks", e);
                        messages.append("Error loading " + locator + ": " + e.getMessage());
                    }
                }
            };
            runnable.run();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException ignore) {}
        }
        this.resetGroups();
        this.resetOverlayTracks();
        if (!messages.isEmpty()) {
            for (String message : messages.getMessages()) {
                MessageUtils.showMessage(message);
            }
        }
    }

    public List<Track> load(ResourceLocator locator) {
        TrackLoader loader = new TrackLoader();
        List<Track> newTracks = loader.load(locator, this);
        if (newTracks.size() > 0) {
            for (Track track : newTracks) {
                String fn = locator.getPath();
                int lastSlashIdx = fn.lastIndexOf("/");
                if (lastSlashIdx < 0) {
                    lastSlashIdx = fn.lastIndexOf("\\");
                }
                if (lastSlashIdx > 0) {
                    fn = fn.substring(lastSlashIdx + 1);
                }
                track.setAttributeValue("NAME", track.getName());
                track.setAttributeValue("DATA FILE", fn);
                track.setAttributeValue("DATA TYPE", track.getTrackType().toString());
                if (!(track instanceof TrackGroupEventListener)) continue;
                this.addGroupEventListener((TrackGroupEventListener)((Object)track));
            }
        }
        return newTracks;
    }

    public void load(ResourceLocator locator, TrackPanel panel) {
        if (locator.getPath().endsWith(".xml") || locator.getPath().endsWith("session")) {
            boolean merge = false;
            this.doRestoreSession(locator.getPath(), null, merge);
        }
        List<Track> tracks = this.load(locator);
        panel.addTracks(tracks);
        this.doRefresh();
    }

    public Set<TrackType> getLoadedTypes() {
        HashSet<TrackType> types = new HashSet<TrackType>();
        for (Track t : this.getAllTracks()) {
            TrackType type = t.getTrackType();
            if (t == null) continue;
            types.add(type);
        }
        return types;
    }

    public TrackPanel getPanelFor(ResourceLocator locator) {
        String path = locator.getPath().toLowerCase();
        if ("alist".equals(locator.getType())) {
            return this.getVcfBamPanel();
        }
        if (PreferenceManager.getInstance().getAsBoolean("IGV.single.track.pane")) {
            return this.getTrackPanel(DATA_PANEL_NAME);
        }
        if (path.endsWith(".sam") || path.endsWith(".bam") || path.endsWith(".sam.list") || path.endsWith(".bam.list") || path.endsWith(".aligned") || path.endsWith(".sorted.txt")) {
            String newPanelName = "Panel" + System.currentTimeMillis();
            return this.addDataPanel(newPanelName).getTrackPanel();
        }
        return this.getDefaultPanel(locator);
    }

    public TrackPanel getVcfBamPanel() {
        String panelName = "VCF_BAM";
        TrackPanel panel = this.getTrackPanel(panelName);
        if (panel != null) {
            return panel;
        }
        return this.addDataPanel(panelName).getTrackPanel();
    }

    private TrackPanel getDefaultPanel(ResourceLocator locator) {
        if (locator.getType() != null && locator.getType().equalsIgnoreCase("das")) {
            return this.getTrackPanel(FEATURE_PANEL_NAME);
        }
        String filename = locator.getPath().toLowerCase();
        if (filename.endsWith(".txt") || filename.endsWith(".tab") || filename.endsWith(".xls") || filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.lastIndexOf("."));
        }
        if (filename.contains("refflat") || filename.contains("ucscgene") || filename.contains("genepred") || filename.contains("ensgene") || filename.contains("refgene") || filename.endsWith("gff") || filename.endsWith("gtf") || filename.endsWith("gff3") || filename.endsWith("embl") || filename.endsWith("bed") || filename.endsWith("gistic") || filename.endsWith("bedz") || filename.endsWith("repmask") || filename.contains("dranger")) {
            return this.getTrackPanel(FEATURE_PANEL_NAME);
        }
        return this.getTrackPanel(DATA_PANEL_NAME);
    }

    public void reset() {
        this.groupByAttribute = null;
        for (TrackPanel sp : this.getTrackPanels()) {
            if (!DATA_PANEL_NAME.equals(sp.getName())) continue;
            sp.reset();
            break;
        }
        this.groupListeners.clear();
    }

    public void sortAlignmentTracks(AlignmentTrack.SortOption option, String tag) {
        this.sortAlignmentTracks(option, null, tag);
    }

    public void sortAlignmentTracks(AlignmentTrack.SortOption option, Double location, String tag) {
        for (Track t : this.getAllTracks()) {
            if (!(t instanceof AlignmentTrack)) continue;
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                double actloc = location != null ? location.doubleValue() : frame.getCenter();
                ((AlignmentTrack)t).sortRows(option, frame, actloc, tag);
            }
        }
    }

    public void groupAlignmentTracks(AlignmentTrack.GroupOption option) {
        for (Track t : this.getAllTracks()) {
            if (!(t instanceof AlignmentTrack)) continue;
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                ((AlignmentTrack)t).groupAlignments(option, frame);
            }
        }
    }

    public void packAlignmentTracks() {
        for (Track t : this.getAllTracks()) {
            if (!(t instanceof AlignmentTrack)) continue;
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                ((AlignmentTrack)t).packAlignments(frame);
            }
        }
    }

    public void collapseTracks() {
        for (Track t : this.getAllTracks()) {
            t.setDisplayMode(Track.DisplayMode.COLLAPSED);
        }
    }

    public void expandTracks() {
        for (Track t : this.getAllTracks()) {
            t.setDisplayMode(Track.DisplayMode.EXPANDED);
        }
    }

    public void collapseTrack(String trackName) {
        for (Track t : this.getAllTracks()) {
            if (!t.getName().equals(trackName)) continue;
            t.setDisplayMode(Track.DisplayMode.COLLAPSED);
        }
    }

    public void expandTrack(String trackName) {
        for (Track t : this.getAllTracks()) {
            if (!t.getName().equals(trackName)) continue;
            t.setDisplayMode(Track.DisplayMode.EXPANDED);
        }
    }

    public void resetOverlayTracks() {
        List<Track> trackList;
        String sample;
        this.overlayTracksMap.clear();
        this.overlaidTracks.clear();
        for (Track track : this.getAllTracks()) {
            if (track == null || track.getTrackType() != TrackType.MUTATION || (sample = track.getSample()) == null) continue;
            trackList = this.overlayTracksMap.get(sample);
            if (trackList == null) {
                trackList = new ArrayList<Track>();
                this.overlayTracksMap.put(sample, trackList);
            }
            trackList.add(track);
        }
        for (Track track : this.getAllTracks()) {
            if (track == null || track.getTrackType() == TrackType.MUTATION || (sample = track.getSample()) == null || (trackList = this.overlayTracksMap.get(sample)) == null) continue;
            this.overlaidTracks.addAll(trackList);
        }
        boolean displayOverlays = this.getSession().getOverlayMutationTracks();
        for (Track track : this.getAllTracks()) {
            if (track == null || track.getTrackType() != TrackType.MUTATION) continue;
            track.setOverlayed(displayOverlays && this.overlaidTracks.contains(track));
        }
    }

    public List<Track> getOverlayTracks(Track track) {
        String sample = track.getSample();
        if (sample != null) {
            return this.overlayTracksMap.get(sample);
        }
        return null;
    }

    public int getVisibleTrackCount() {
        int count = 0;
        for (TrackPanel tsv : this.getTrackPanels()) {
            count += tsv.getVisibleTrackCount();
        }
        return count;
    }

    public List<Track> getAllTracks() {
        ArrayList<Track> allTracks = new ArrayList<Track>();
        for (TrackPanel tp : this.getTrackPanels()) {
            allTracks.addAll(tp.getTracks());
        }
        return allTracks;
    }

    public List<FeatureTrack> getFeatureTracks() {
        Iterable<FeatureTrack> featureTracksIter = Iterables.filter(this.getAllTracks(), FeatureTrack.class);
        ArrayList<FeatureTrack> featureTracks = Lists.newArrayList(featureTracksIter);
        return featureTracks;
    }

    public void clearSelections() {
        for (Track t : this.getAllTracks()) {
            if (t == null) continue;
            t.setSelected(false);
        }
    }

    public void setTrackSelections(Iterable<Track> selectedTracks) {
        for (Track t : selectedTracks) {
            t.setSelected(true);
        }
    }

    public void shiftSelectTracks(Track track) {
        int clickedTrackIndex;
        List<Track> allTracks = this.getAllTracks();
        int otherIndex = clickedTrackIndex = allTracks.indexOf(track);
        for (int i = 0; i < allTracks.size(); ++i) {
            if (!allTracks.get(i).isSelected() || i == clickedTrackIndex) continue;
            otherIndex = i;
            break;
        }
        int left = Math.min(otherIndex, clickedTrackIndex);
        int right = Math.max(otherIndex, clickedTrackIndex);
        for (int i = left; i <= right; ++i) {
            allTracks.get(i).setSelected(true);
        }
    }

    public void toggleTrackSelections(Iterable<Track> selectedTracks) {
        for (Track t : selectedTracks) {
            t.setSelected(!t.isSelected());
        }
    }

    public Collection<Track> getSelectedTracks() {
        HashSet<Track> selectedTracks = new HashSet<Track>();
        for (Track t : this.getAllTracks()) {
            if (t == null || !t.isSelected()) continue;
            selectedTracks.add(t);
        }
        return selectedTracks;
    }

    public Set<ResourceLocator> getDataResourceLocators() {
        HashSet<ResourceLocator> locators = new HashSet<ResourceLocator>();
        for (Track track : this.getAllTracks()) {
            ResourceLocator locator = track.getResourceLocator();
            if (locator == null) continue;
            locators.add(locator);
        }
        return locators;
    }

    public void setAllTrackHeights(int newHeight) {
        for (Track track : this.getAllTracks()) {
            track.setHeight(newHeight);
        }
    }

    public void removeTracks(Collection<Track> tracksToRemove) {
        List<TrackPanel> panels = this.getTrackPanels();
        for (TrackPanel trackPanel : panels) {
            trackPanel.removeTracks(tracksToRemove);
            if (trackPanel.hasTracks()) continue;
            this.removeDataPanel(trackPanel.getName());
        }
        for (Track t : tracksToRemove) {
            if (t instanceof DragListener) {
                DragEventManager.getInstance().removeDragListener((DragListener)((Object)t));
            }
            if (t instanceof TrackGroupEventListener) {
                this.removeGroupEventListener((TrackGroupEventListener)((Object)t));
            }
            if (!(t instanceof AlignmentTrackEventListener)) continue;
            this.removeAlignmentTrackEvent((AlignmentTrackEventListener)((Object)t));
        }
    }

    public void setGenomeTracks(FeatureTrack newGeneTrack) {
        TrackPanel panel = PreferenceManager.getInstance().getAsBoolean("IGV.single.track.pane") ? this.getTrackPanel(DATA_PANEL_NAME) : this.getTrackPanel(FEATURE_PANEL_NAME);
        SequenceTrack newSeqTrack = new SequenceTrack("Reference sequence");
        panel.addTrack(newSeqTrack);
        if (newGeneTrack != null) {
            panel.addTrack(newGeneTrack);
        }
    }

    public void sortAllTracksByAttributes(String[] attributeNames, boolean[] ascending) {
        assert (attributeNames.length == ascending.length);
        for (TrackPanel trackPanel : this.getTrackPanels()) {
            trackPanel.sortTracksByAttributes(attributeNames, ascending);
        }
    }

    public void sortByRegionScore(RegionOfInterest region, RegionScoreType type, ReferenceFrame frame) {
        RegionOfInterest r = region == null ? new RegionOfInterest(frame.getChrName(), (int)frame.getOrigin(), (int)frame.getEnd() + 1, frame.getName()) : region;
        List<String> sortedSamples = this.sortSamplesByRegionScore(r, type, frame);
        for (TrackPanel trackPanel : this.getTrackPanels()) {
            trackPanel.sortByRegionsScore(r, type, frame, sortedSamples);
        }
        this.repaintDataPanels();
    }

    private List<String> sortSamplesByRegionScore(RegionOfInterest region, RegionScoreType type, ReferenceFrame frame) {
        List<Track> allTracks = this.getAllTracks();
        ArrayList<Track> tracksWithScore = new ArrayList<Track>(allTracks.size());
        for (Track t : allTracks) {
            if (!t.isRegionScoreType(type)) continue;
            tracksWithScore.add(t);
        }
        IGV.sortByRegionScore(tracksWithScore, region, type, frame);
        ArrayList<String> sortedSamples = new ArrayList<String>(tracksWithScore.size());
        for (Track t : tracksWithScore) {
            String att = t.getSample();
            if (att == null) continue;
            sortedSamples.add(att);
        }
        return sortedSamples;
    }

    static void sortByRegionScore(List<Track> tracks, RegionOfInterest region, final RegionScoreType type, ReferenceFrame frame) {
        if (tracks != null && region != null && !tracks.isEmpty()) {
            final String frameName = frame != null ? frame.getName() : null;
            int tmpzoom = frame != null ? frame.getZoom() : 0;
            final int zoom = Math.max(0, tmpzoom);
            final String chr = region.getChr();
            final int start = region.getStart();
            final int end = region.getEnd();
            Comparator<Track> c = new Comparator<Track>(){

                @Override
                public int compare(Track t1, Track t2) {
                    try {
                        float s2;
                        if (t1 == null && t2 == null) {
                            return 0;
                        }
                        if (t1 == null) {
                            return 1;
                        }
                        if (t2 == null) {
                            return -1;
                        }
                        float s1 = t1.getRegionScore(chr, start, end, zoom, type, frameName);
                        if (s1 < (s2 = t2.getRegionScore(chr, start, end, zoom, type, frameName))) {
                            return 1;
                        }
                        if (s1 > s2) {
                            return -1;
                        }
                        return 0;
                    }
                    catch (Exception e) {
                        log.error("Error sorting tracks. Sort might not be accurate.", e);
                        return 0;
                    }
                }
            };
            Collections.sort(tracks, c);
        }
    }

    public String getGroupByAttribute() {
        return this.groupByAttribute;
    }

    public void setGroupByAttribute(String attributeName) {
        this.groupByAttribute = attributeName;
        this.resetGroups();
        this.notifyGroupEvent();
    }

    private void resetGroups() {
        for (TrackPanel trackPanel : this.getTrackPanels()) {
            trackPanel.groupTracksByAttribute(this.groupByAttribute);
        }
    }

    public synchronized void addGroupEventListener(TrackGroupEventListener l) {
        this.groupListeners.add(new SoftReference<TrackGroupEventListener>(l));
    }

    public synchronized void removeGroupEventListener(TrackGroupEventListener l) {
        Iterator<SoftReference<TrackGroupEventListener>> it = this.groupListeners.iterator();
        while (it.hasNext()) {
            TrackGroupEventListener listener = it.next().get();
            if (listener == null || listener != l) continue;
            it.remove();
            break;
        }
    }

    public void notifyGroupEvent() {
        TrackGroupEvent e = new TrackGroupEvent(this);
        for (SoftReference<TrackGroupEventListener> ref : this.groupListeners) {
            TrackGroupEventListener l = ref.get();
            l.onTrackGroupEvent(e);
        }
    }

    public synchronized void addAlignmentTrackEventListener(AlignmentTrackEventListener l) {
        this.alignmentTrackListeners.add(new SoftReference<AlignmentTrackEventListener>(l));
    }

    public synchronized void removeAlignmentTrackEvent(AlignmentTrackEventListener l) {
        Iterator<SoftReference<AlignmentTrackEventListener>> it = this.alignmentTrackListeners.iterator();
        while (it.hasNext()) {
            AlignmentTrackEventListener listener = it.next().get();
            if (listener == null || listener != l) continue;
            it.remove();
            break;
        }
    }

    public void notifyAlignmentTrackEvent(Object source, AlignmentTrackEvent.Type type) {
        AlignmentTrackEvent e = new AlignmentTrackEvent(source, type);
        for (SoftReference<AlignmentTrackEventListener> ref : this.alignmentTrackListeners) {
            AlignmentTrackEventListener l = ref.get();
            l.onAlignmentTrackEvent(e);
        }
    }

    public Future startUp(Main.IGVArgs igvArgs) {
        if (log.isDebugEnabled()) {
            log.debug("startUp");
        }
        return LongRunningTask.submit(new StartupRunnable(igvArgs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copySequenceToClipboard(Genome genome, String chr, int start, int end) {
        try {
            IGV.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            byte[] seqBytes = genome.getSequence(chr, start, end);
            if (seqBytes == null) {
                MessageUtils.showMessage("Sequence not available. Try enabling http byte-range requests");
            } else {
                String sequence = new String(seqBytes);
                StringUtils.copyTextToClipboard(sequence);
            }
        }
        finally {
            IGV.getMainFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForNotify(long timeout) {
        boolean completed = false;
        IGV iGV = this;
        synchronized (iGV) {
            if (!completed) {
                try {
                    this.wait(timeout);
                    completed = true;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return completed;
    }

    public class StartupRunnable
    implements Runnable {
        Main.IGVArgs igvArgs;

        StartupRunnable(Main.IGVArgs args) {
            this.igvArgs = args;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProgressMonitor monitor = new ProgressMonitor();
            ProgressBar progressBar = ProgressBar.showProgressDialog(IGV.this.mainFrame, "Initializing...", monitor, false);
            progressBar.setIndeterminate(true);
            monitor.fireProgressChange(20);
            IGV.this.mainFrame.setIconImage(this.getIconImage());
            if (Globals.IS_MAC) {
                this.setAppleDockIcon();
            }
            PreferenceManager preferenceManager = PreferenceManager.getInstance();
            boolean affectiveMode = PreferenceManager.getInstance().getAsBoolean("AFFECTIVE_ENABLE");
            if (affectiveMode) {
                IGV.this.closeWindow(progressBar);
                GenomeManager.getInstance().setCurrentGenome(new AffectiveGenome());
            } else {
                try {
                    IGV.this.contentPane.getCommandBar().initializeGenomeList(monitor);
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(IGV.this.mainFrame, "Error initializing genome list: " + ex.getMessage());
                    log.error("Error initializing genome list: ", ex);
                }
                catch (NoRouteToHostException ex) {
                    JOptionPane.showMessageDialog(IGV.this.mainFrame, "Network error initializing genome list: " + ex.getMessage());
                    log.error("Network error initializing genome list: ", ex);
                }
                finally {
                    monitor.fireProgressChange(50);
                    IGV.this.closeWindow(progressBar);
                }
                if (this.igvArgs.getGenomeId() != null) {
                    if (ParsingUtils.pathExists(this.igvArgs.getGenomeId())) {
                        try {
                            IGV.getInstance().loadGenome(this.igvArgs.getGenomeId(), null);
                        }
                        catch (IOException e) {
                            log.error("Error loading genome file: " + this.igvArgs.getGenomeId());
                        }
                    } else {
                        IGV.this.contentPane.getCommandBar().selectGenome(this.igvArgs.getGenomeId());
                    }
                } else if (this.igvArgs.getSessionFile() == null) {
                    String genomeId = preferenceManager.getDefaultGenome();
                    IGV.this.contentPane.getCommandBar().selectGenome(genomeId);
                }
            }
            if (this.igvArgs.getSessionFile() != null || this.igvArgs.getDataFileString() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Loadding session data");
                }
                IndefiniteProgressMonitor indefMonitor = new IndefiniteProgressMonitor(60);
                ProgressBar bar2 = ProgressBar.showProgressDialog(IGV.this.mainFrame, "Loading session data", indefMonitor, false);
                indefMonitor.start();
                if (log.isDebugEnabled()) {
                    log.debug("Calling restore session");
                }
                if (this.igvArgs.getSessionFile() != null) {
                    boolean success = false;
                    if (HttpUtils.isRemoteURL(this.igvArgs.getSessionFile())) {
                        boolean merge = false;
                        success = IGV.this.restoreSessionSynchronous(this.igvArgs.getSessionFile(), this.igvArgs.getLocusString(), merge);
                    } else {
                        File sf = new File(this.igvArgs.getSessionFile());
                        if (sf.exists()) {
                            success = IGV.this.restoreSessionSynchronous(sf.getAbsolutePath(), this.igvArgs.getLocusString(), false);
                        }
                    }
                    if (!success) {
                        String genomeId = preferenceManager.getDefaultGenome();
                        IGV.this.contentPane.getCommandBar().selectGenome(genomeId);
                    }
                } else if (this.igvArgs.getDataFileString() != null) {
                    String[] tokens = this.igvArgs.getDataFileString().split(",");
                    String[] names = null;
                    if (this.igvArgs.getName() != null) {
                        names = this.igvArgs.getName().split(",");
                    }
                    String indexFile = this.igvArgs.getIndexFile();
                    ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
                    int idx = 0;
                    for (String p : tokens) {
                        ResourceLocator rl = new ResourceLocator(p);
                        if (names != null && idx < names.length) {
                            String name = names[idx];
                            if (!FileUtils.isRemote(name)) {
                                name = StringUtils.decodeURL(name);
                            }
                            rl.setName(name);
                        }
                        rl.setIndexPath(indexFile);
                        locators.add(rl);
                        ++idx;
                    }
                    IGV.this.loadResources(locators);
                }
                indefMonitor.stop();
                IGV.this.closeWindow(bar2);
            }
            IGV.this.session.recordHistory();
            boolean portEnabled = preferenceManager.getAsBoolean("PORT_ENABLED");
            String portString = this.igvArgs.getPort();
            if (portEnabled || portString != null) {
                int port = preferenceManager.getAsInt("PORT_NUMBER");
                if (portString != null) {
                    port = Integer.parseInt(portString);
                }
                CommandListener.start(port);
            }
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    IGV.this.mainFrame.setVisible(true);
                    if (StartupRunnable.this.igvArgs.getLocusString() != null) {
                        IGV.this.goToLocus(StartupRunnable.this.igvArgs.getLocusString());
                    }
                    if (StartupRunnable.this.igvArgs.getBatchFile() != null) {
                        LongRunningTask.submit(new BatchRunner(StartupRunnable.this.igvArgs.getBatchFile()));
                    }
                }
            });
            IGV iGV = IGV.getInstance();
            synchronized (iGV) {
                IGV.getInstance().notifyAll();
            }
        }

        private void setAppleDockIcon() {
            try {
                Image image = this.getIconImage();
                OSXAdapter.setDockIconImage(image);
            }
            catch (Exception e) {
                log.error("Error setting apple dock icon", e);
            }
        }

        private Image getIconImage() {
            String path = "resources/IGV_64.png";
            URL url = IGV.class.getResource(path);
            Image image = new ImageIcon(url).getImage();
            return image;
        }
    }
}

