/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.tools.IgvTools;
import org.broad.igv.tools.PreprocessingException;
import org.broad.igv.tools.Preprocessor;
import org.broad.igv.track.WindowFunction;

public class IgvToolsGui
extends JDialog {
    private static Logger log = Logger.getLogger(IgvToolsGui.class);
    static JFileChooser fileDialog;
    private static final String COUNT = "Count";
    private static final String SORT = "Sort";
    private static final String INDEX = "Index";
    private static final String TILE = "Tile";
    String[] tools = new String[]{"Tile", "Count", "Sort", "Index"};
    String[] zoomLevels = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    PrintStream systemOutStream;
    PrintStream systemErrStream;
    static File lastDirectory;
    IgvTools igvTools = new IgvTools();
    private boolean genomeSelectionDisabled = false;
    private JPanel mainPanel;
    private JPanel requiredPanel;
    private JComboBox toolCombo;
    private JLabel outputLabel;
    private JButton outputButton;
    private JTextField inputField;
    private JButton inputButton;
    private JTextField outputField;
    private JLabel genomeLabel;
    private JTextField genomeField;
    private JButton genomeButton;
    private JPanel tilePanel;
    private JLabel zoomLabel;
    private JLabel windowFunctionLabel;
    private JPanel windowFunctionPanel;
    private JCheckBox minCheckBox;
    private JCheckBox maxCheckBox;
    private JCheckBox meanCheckBox;
    private JCheckBox medianCheckBox;
    private JCheckBox a2CheckBox;
    private JCheckBox a10CheckBox;
    private JCheckBox a90CheckBox;
    private JCheckBox a98CheckBox;
    private JLabel probeLabel;
    private JTextField probeField;
    private JButton probeButton;
    private JComboBox zoomCombo;
    private JLabel windowSizeLabel;
    private JTextField windowSizeField;
    private JPanel sortPanel;
    private JLabel tmpDirectoryLabel;
    private JLabel maxRecordsLabel;
    private JButton tempButton;
    private JTextField tmpDirectoryField;
    private JTextField maxRecordsField;
    private JPanel buttonPanel;
    private JButton runButton;
    private JButton closeButton;
    private JPanel OutputPanel;
    private JScrollPane outputScroll;
    private JTextArea outputText;
    private JProgressBar progressBar;

    public IgvToolsGui() {
        this.initComponents();
        this.initUI();
        this.updateUI();
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgvToolsGui.this.close();
                IgvToolsGui.this.setVisible(false);
            }
        });
        this.inputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File chosenFile = IgvToolsGui.this.chooseFile();
                    IgvToolsGui.this.inputField.setText(chosenFile.getAbsolutePath());
                    IgvToolsGui.this.updateUI();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.outputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File chosenFile = IgvToolsGui.this.chooseFile();
                    IgvToolsGui.this.outputField.setText(chosenFile.getAbsolutePath());
                    IgvToolsGui.this.updateUI();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.genomeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File chosenFile = IgvToolsGui.this.chooseFile();
                    IgvToolsGui.this.genomeField.setText(chosenFile.getAbsolutePath());
                    IgvToolsGui.this.updateUI();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.probeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File chosenFile = IgvToolsGui.this.chooseFile();
                    IgvToolsGui.this.probeField.setText(chosenFile.getAbsolutePath());
                    IgvToolsGui.this.updateUI();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.toolCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgvToolsGui.this.updateUI();
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgvToolsGui.this.run();
            }
        });
        this.tempButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File chosenFile = IgvToolsGui.this.chooseFile();
                    IgvToolsGui.this.tmpDirectoryField.setText(chosenFile.getAbsolutePath());
                    IgvToolsGui.this.updateUI();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void initUI() {
        this.setContentPane(this.mainPanel);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                IgvToolsGui.this.close();
            }
        });
        for (String item : this.zoomLevels) {
            this.zoomCombo.addItem(item);
        }
        for (String tool : this.tools) {
            this.toolCombo.addItem(tool);
        }
        this.zoomCombo.setSelectedIndex(7);
        this.windowSizeField.setText(String.valueOf(25));
        this.maxRecordsField.setText(String.valueOf(500000));
        this.redirectSystemStreams();
    }

    private void close() {
        System.setErr(this.systemErrStream);
        System.setOut(this.systemOutStream);
        this.dispose();
    }

    private void updateTextArea(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IgvToolsGui.this.outputText.append(text);
            }
        });
    }

    private void redirectSystemStreams() {
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                IgvToolsGui.this.updateTextArea(String.valueOf((char)b));
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                IgvToolsGui.this.updateTextArea(new String(b, off, len));
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }
        };
        this.systemOutStream = System.out;
        this.systemErrStream = System.err;
        System.setOut(new PrintStream(out, true));
        System.setErr(new PrintStream(out, true));
    }

    private void updateUI() {
        String tool = (String)this.toolCombo.getSelectedItem();
        if (tool.equals(COUNT)) {
            this.inputField.setEnabled(true);
            this.inputButton.setEnabled(true);
            this.outputField.setEnabled(true);
            this.outputButton.setEnabled(true);
            this.outputLabel.setEnabled(true);
            if (!this.genomeSelectionDisabled) {
                this.genomeField.setEnabled(true);
                this.genomeButton.setEnabled(true);
                this.genomeLabel.setEnabled(true);
            }
            this.zoomCombo.setEnabled(true);
            this.zoomLabel.setEnabled(true);
            this.maxRecordsField.setEnabled(false);
            this.maxRecordsLabel.setEnabled(false);
            this.probeField.setEnabled(false);
            this.probeButton.setEnabled(false);
            this.probeLabel.setEnabled(false);
            this.tmpDirectoryLabel.setEnabled(false);
            this.tmpDirectoryField.setEnabled(false);
            this.tempButton.setEnabled(false);
            this.windowSizeLabel.setEnabled(true);
            this.windowSizeField.setEnabled(true);
            this.enableWindowFunctions();
        } else if (tool.equals(SORT)) {
            this.inputField.setEnabled(true);
            this.inputButton.setEnabled(true);
            this.outputField.setEnabled(true);
            this.outputButton.setEnabled(true);
            this.outputLabel.setEnabled(true);
            this.genomeField.setEnabled(false);
            this.genomeButton.setEnabled(false);
            this.genomeLabel.setEnabled(false);
            this.zoomCombo.setEnabled(false);
            this.zoomLabel.setEnabled(false);
            this.maxRecordsField.setEnabled(true);
            this.maxRecordsLabel.setEnabled(true);
            this.probeField.setEnabled(false);
            this.probeButton.setEnabled(false);
            this.probeLabel.setEnabled(false);
            this.tmpDirectoryLabel.setEnabled(true);
            this.tmpDirectoryField.setEnabled(true);
            this.tempButton.setEnabled(true);
            this.windowSizeLabel.setEnabled(false);
            this.windowSizeField.setEnabled(false);
            this.disableWindowFunctions();
        } else if (tool.equals(INDEX)) {
            this.inputField.setEnabled(true);
            this.inputButton.setEnabled(true);
            this.outputField.setEnabled(false);
            this.outputButton.setEnabled(false);
            this.outputLabel.setEnabled(false);
            this.genomeField.setEnabled(false);
            this.genomeButton.setEnabled(false);
            this.genomeLabel.setEnabled(false);
            this.zoomCombo.setEnabled(false);
            this.zoomLabel.setEnabled(false);
            this.maxRecordsField.setEnabled(false);
            this.maxRecordsLabel.setEnabled(false);
            this.probeField.setEnabled(false);
            this.probeButton.setEnabled(false);
            this.probeLabel.setEnabled(false);
            this.tmpDirectoryLabel.setEnabled(false);
            this.tmpDirectoryField.setEnabled(false);
            this.tempButton.setEnabled(false);
            this.windowSizeLabel.setEnabled(false);
            this.windowSizeField.setEnabled(false);
            this.disableWindowFunctions();
        } else if (tool.equals(TILE)) {
            this.inputField.setEnabled(true);
            this.inputButton.setEnabled(true);
            this.outputField.setEnabled(true);
            this.outputButton.setEnabled(true);
            this.outputLabel.setEnabled(true);
            if (!this.genomeSelectionDisabled) {
                this.genomeField.setEnabled(true);
                this.genomeButton.setEnabled(true);
                this.genomeLabel.setEnabled(true);
            }
            this.zoomCombo.setEnabled(true);
            this.zoomLabel.setEnabled(true);
            this.maxRecordsField.setEnabled(true);
            this.maxRecordsLabel.setEnabled(true);
            this.probeField.setEnabled(true);
            this.probeButton.setEnabled(true);
            this.probeLabel.setEnabled(true);
            this.tmpDirectoryLabel.setEnabled(true);
            this.tmpDirectoryField.setEnabled(true);
            this.tempButton.setEnabled(false);
            this.windowSizeLabel.setEnabled(false);
            this.windowSizeField.setEnabled(false);
            this.enableWindowFunctions();
        }
    }

    private void enableWindowFunctions() {
        Component[] com = this.windowFunctionPanel.getComponents();
        this.windowFunctionLabel.setEnabled(true);
        for (int i = 0; i < com.length; ++i) {
            com[i].setEnabled(true);
        }
    }

    private void disableWindowFunctions() {
        Component[] com = this.windowFunctionPanel.getComponents();
        this.windowFunctionLabel.setEnabled(false);
        for (int i = 0; i < com.length; ++i) {
            com[i].setEnabled(false);
        }
    }

    private boolean validateFields() {
        int opt;
        String tool = (String)this.toolCombo.getSelectedItem();
        if (this.inputField.getText().trim().length() == 0) {
            this.showMessage("Input file is required");
            return false;
        }
        if (tool.equals(INDEX)) {
            return true;
        }
        if (this.outputField.getText().trim().length() == 0) {
            this.showMessage("Output file is required");
            return false;
        }
        if (new File(this.outputField.getText().trim()).exists() && (opt = JOptionPane.showConfirmDialog(this, "Output file: " + this.outputField.getText() + " exists.  Overwite?")) != 0) {
            return false;
        }
        if (tool.equals(SORT)) {
            return true;
        }
        if (this.genomeField.getText().trim().length() == 0) {
            this.showMessage("Genome is required");
            return false;
        }
        return true;
    }

    private void run() {
        String tool = (String)this.toolCombo.getSelectedItem();
        if (!this.validateFields()) {
            return;
        }
        try {
            if (tool.equals(COUNT)) {
                this.doCount();
            } else if (tool.equals(SORT)) {
                this.doSort();
            } else if (tool.equals(INDEX)) {
                this.doIndex();
            } else if (tool.equals(TILE)) {
                this.doTile();
            }
        }
        catch (PreprocessingException e) {
            this.showMessage("Error performing " + tool + ": " + e.getMessage());
        }
    }

    private void showMessage(String tool) {
        JOptionPane.showMessageDialog(this, tool);
    }

    private void doSort() {
        this.runButton.setEnabled(false);
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    IgvToolsGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    String maxRecordText = IgvToolsGui.this.maxRecordsField.getText();
                    int maxRecords = maxRecordText != null && maxRecordText.length() > 0 ? Integer.parseInt(maxRecordText) : 500000;
                    IgvToolsGui.this.igvTools.doSort(IgvToolsGui.this.inputField.getText(), IgvToolsGui.this.outputField.getText(), IgvToolsGui.this.tmpDirectoryField.getText(), maxRecords);
                }
                catch (Exception e) {
                    IgvToolsGui.this.showMessage("Error: " + e.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                IgvToolsGui.this.runButton.setEnabled(true);
                IgvToolsGui.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        swingWorker.execute();
    }

    private void doCount() {
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    IgvToolsGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    String ifile = IgvToolsGui.this.inputField.getText();
                    String ofile = IgvToolsGui.this.outputField.getText();
                    String genomeId = IgvToolsGui.this.genomeField.getText();
                    int maxZoomValue = Integer.parseInt(IgvToolsGui.this.zoomCombo.getSelectedItem().toString());
                    Collection wfs = IgvToolsGui.this.getWindowFunctions();
                    String windowSizeText = IgvToolsGui.this.windowSizeField.getText();
                    int windowSize = windowSizeText != null && windowSizeText.length() > 0 ? Integer.parseInt(windowSizeText) : 25;
                    int extFactor = 0;
                    int strandOption = -1;
                    IgvToolsGui.this.runButton.setEnabled(false);
                    int preExtFactor = 0;
                    int postExtFactor = 0;
                    IgvToolsGui.this.igvTools.doCount(ifile, ofile, genomeId, maxZoomValue, wfs, windowSize, extFactor, preExtFactor, postExtFactor, null, null, 0, 0);
                }
                catch (Exception e) {
                    IgvToolsGui.this.showMessage("Error: " + e.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                IgvToolsGui.this.runButton.setEnabled(true);
                IgvToolsGui.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        swingWorker.execute();
    }

    private void doTile() {
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    IgvToolsGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    String ifile = IgvToolsGui.this.inputField.getText();
                    String ofile = IgvToolsGui.this.outputField.getText();
                    String genomeId = IgvToolsGui.this.genomeField.getText();
                    int maxZoomValue = Integer.parseInt(IgvToolsGui.this.zoomCombo.getSelectedItem().toString());
                    Collection wfs = IgvToolsGui.this.getWindowFunctions();
                    String probeFile = IgvToolsGui.this.probeField.getText();
                    String typeString = Preprocessor.getExtension(ifile);
                    IgvToolsGui.this.runButton.setEnabled(false);
                    IgvToolsGui.this.igvTools.toTDF(typeString, ifile, ofile, probeFile, genomeId, maxZoomValue, wfs, null, 500000);
                }
                catch (Exception e) {
                    IgvToolsGui.this.showMessage("Error: " + e.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                IgvToolsGui.this.runButton.setEnabled(true);
                IgvToolsGui.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        swingWorker.execute();
    }

    private void doIndex() {
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    IgvToolsGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    String ifile = IgvToolsGui.this.inputField.getText();
                    int indexType = 1;
                    int binSize = 16000;
                    IgvToolsGui.this.runButton.setEnabled(false);
                    IgvToolsGui.this.igvTools.doIndex(ifile, null, indexType, binSize);
                }
                catch (Exception e) {
                    log.error(e);
                    IgvToolsGui.this.showMessage("Error: " + e.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                IgvToolsGui.this.runButton.setEnabled(true);
                IgvToolsGui.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        swingWorker.execute();
    }

    private Collection<WindowFunction> getWindowFunctions() {
        ArrayList<WindowFunction> wfs = new ArrayList<WindowFunction>();
        if (this.minCheckBox.isSelected()) {
            wfs.add(WindowFunction.min);
        }
        if (this.maxCheckBox.isSelected()) {
            wfs.add(WindowFunction.max);
        }
        if (this.meanCheckBox.isSelected()) {
            wfs.add(WindowFunction.mean);
        }
        if (this.a98CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile98);
        }
        if (this.a90CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile90);
        }
        if (this.a10CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile10);
        }
        if (this.a2CheckBox.isSelected()) {
            wfs.add(WindowFunction.percentile2);
        }
        if (wfs.isEmpty()) {
            wfs.add(WindowFunction.mean);
        }
        return wfs;
    }

    private File chooseFile() {
        fileDialog = new JFileChooser();
        if (lastDirectory != null) {
            fileDialog.setCurrentDirectory(lastDirectory);
        }
        fileDialog.setMultiSelectionEnabled(false);
        boolean affective = PreferenceManager.getInstance().getAsBoolean("AFFECTIVE_ENABLE");
        if (!affective) {
            fileDialog.setFileSelectionMode(0);
        } else {
            fileDialog.setFileSelectionMode(2);
        }
        int returnVal = fileDialog.showDialog(this, "Select File");
        if (returnVal == 1) {
            return null;
        }
        File selected = fileDialog.getSelectedFile();
        lastDirectory = selected.isDirectory() ? selected : selected.getParentFile();
        return selected;
    }

    public static void main(String[] args) {
        IgvToolsGui.launch(true, null);
    }

    public static void launch(boolean modal, String genomeId) {
        IgvToolsGui mainWindow = new IgvToolsGui();
        mainWindow.pack();
        mainWindow.setModal(modal);
        mainWindow.setDefaultCloseOperation(2);
        mainWindow.setResizable(false);
        if (genomeId != null) {
            mainWindow.genomeField.setText(genomeId);
            mainWindow.genomeField.setEnabled(false);
            mainWindow.genomeField.setToolTipText("<html>To change the genome id close this window and <br>use the pulldown on the IGV batch screen.");
            mainWindow.genomeButton.setEnabled(false);
            mainWindow.genomeSelectionDisabled = true;
        }
        mainWindow.setVisible(true);
    }

    private void inputButtonActionPerformed(ActionEvent e) {
        this.setDefaultOutputText();
    }

    private void inputFieldActionPerformed(ActionEvent e) {
        this.setDefaultOutputText();
    }

    private void inputFieldFocusLost(FocusEvent e) {
        this.setDefaultOutputText();
    }

    private void setDefaultOutputText() {
        if (this.inputField.getText().length() > 0) {
            String cmd = this.toolCombo.getSelectedItem().toString().toLowerCase();
            if (cmd.equals("count") || cmd.equals("tile")) {
                this.outputField.setText(this.inputField.getText() + ".tdf");
            } else if (cmd.equals("sort")) {
                String input = this.inputField.getText();
                int ext = input.indexOf(".");
                if (ext > 0) {
                    String output = input.substring(0, ext) + ".sorted" + input.substring(ext);
                    this.outputField.setText(output);
                }
            } else if (cmd.equals("index")) {
                this.outputField.setText("");
            }
        }
    }

    private void toolComboActionPerformed(ActionEvent e) {
        this.setDefaultOutputText();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.requiredPanel = new JPanel();
        this.toolCombo = new JComboBox();
        JLabel label1 = new JLabel();
        JLabel label2 = new JLabel();
        this.outputLabel = new JLabel();
        this.outputButton = new JButton();
        this.inputField = new JTextField();
        this.inputButton = new JButton();
        this.outputField = new JTextField();
        this.genomeLabel = new JLabel();
        this.genomeField = new JTextField();
        this.genomeButton = new JButton();
        this.tilePanel = new JPanel();
        this.zoomLabel = new JLabel();
        this.windowFunctionLabel = new JLabel();
        this.windowFunctionPanel = new JPanel();
        this.minCheckBox = new JCheckBox();
        this.maxCheckBox = new JCheckBox();
        this.meanCheckBox = new JCheckBox();
        this.medianCheckBox = new JCheckBox();
        this.a2CheckBox = new JCheckBox();
        this.a10CheckBox = new JCheckBox();
        this.a90CheckBox = new JCheckBox();
        this.a98CheckBox = new JCheckBox();
        this.probeLabel = new JLabel();
        this.probeField = new JTextField();
        this.probeButton = new JButton();
        this.zoomCombo = new JComboBox();
        this.windowSizeLabel = new JLabel();
        this.windowSizeField = new JTextField();
        this.sortPanel = new JPanel();
        this.tmpDirectoryLabel = new JLabel();
        this.maxRecordsLabel = new JLabel();
        this.tempButton = new JButton();
        this.tmpDirectoryField = new JTextField();
        this.maxRecordsField = new JTextField();
        this.buttonPanel = new JPanel();
        this.runButton = new JButton();
        this.closeButton = new JButton();
        this.OutputPanel = new JPanel();
        this.outputScroll = new JScrollPane();
        this.outputText = new JTextArea();
        JSeparator separator1 = new JSeparator();
        this.progressBar = new JProgressBar();
        this.mainPanel.setBorder(new TitledBorder(new EtchedBorder(), ""));
        this.mainPanel.setLayout(new GridBagLayout());
        this.requiredPanel.setLayout(new GridBagLayout());
        this.toolCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgvToolsGui.this.toolComboActionPerformed(e);
            }
        });
        this.requiredPanel.add((Component)this.toolCombo, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        label1.setText("Command");
        this.requiredPanel.add((Component)label1, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        label2.setText("Input File");
        this.requiredPanel.add((Component)label2, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.outputLabel.setText("Output File");
        this.requiredPanel.add((Component)this.outputLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.outputButton.setText("Browse");
        this.requiredPanel.add((Component)this.outputButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                IgvToolsGui.this.inputFieldFocusLost(e);
            }
        });
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgvToolsGui.this.inputFieldActionPerformed(e);
            }
        });
        this.requiredPanel.add((Component)this.inputField, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputButton.setText("Browse");
        this.inputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgvToolsGui.this.inputButtonActionPerformed(e);
            }
        });
        this.requiredPanel.add((Component)this.inputButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.requiredPanel.add((Component)this.outputField, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.genomeLabel.setToolTipText("Either a genome ID (e.g. hg18) or the full path to a .genome file.");
        this.genomeLabel.setText("Genome");
        this.requiredPanel.add((Component)this.genomeLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.requiredPanel.add((Component)this.genomeField, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.genomeButton.setText("Browse");
        this.requiredPanel.add((Component)this.genomeButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.requiredPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.tilePanel.setEnabled(true);
        this.tilePanel.setFont(this.tilePanel.getFont().deriveFont(2, 10.0f));
        this.tilePanel.setBorder(new TitledBorder(null, "Tile and Count Options", 4, 2));
        this.tilePanel.setLayout(new GridBagLayout());
        this.zoomLabel.setToolTipText("<html>Specifies the maximum zoom level to precompute. The default value is 7.<br>To reduce file size at the expense of Iperformance this value can be reduced.");
        this.zoomLabel.setText("Zoom Levels");
        this.tilePanel.add((Component)this.zoomLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.windowFunctionLabel.setToolTipText("Window functions to use for summarizing data. ");
        this.windowFunctionLabel.setText("Window Functions");
        this.tilePanel.add((Component)this.windowFunctionLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.windowFunctionPanel.setLayout(new GridLayout(2, 0));
        this.minCheckBox.setText("Min");
        this.windowFunctionPanel.add(this.minCheckBox);
        this.maxCheckBox.setText("Max");
        this.windowFunctionPanel.add(this.maxCheckBox);
        this.meanCheckBox.setSelected(true);
        this.meanCheckBox.setText("Mean");
        this.windowFunctionPanel.add(this.meanCheckBox);
        this.medianCheckBox.setText("Median");
        this.windowFunctionPanel.add(this.medianCheckBox);
        this.a2CheckBox.setText("2%");
        this.windowFunctionPanel.add(this.a2CheckBox);
        this.a10CheckBox.setText("10%");
        this.windowFunctionPanel.add(this.a10CheckBox);
        this.a90CheckBox.setText("90%");
        this.windowFunctionPanel.add(this.a90CheckBox);
        this.a98CheckBox.setText("98%");
        this.windowFunctionPanel.add(this.a98CheckBox);
        this.tilePanel.add((Component)this.windowFunctionPanel, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.probeLabel.setFont(this.probeLabel.getFont());
        this.probeLabel.setToolTipText("<html>Specifies a \"bed\" file to be used to map probe identifiers to locations.  This option is useful <br>when preprocessing gct files.  The bed file should contain 4 columns: chr start end name\n<br>where name is the probe name in the gct file.");
        this.probeLabel.setText("Probe to Loci Mapping");
        this.tilePanel.add((Component)this.probeLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tilePanel.add((Component)this.probeField, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.probeButton.setText("Browse");
        this.tilePanel.add((Component)this.probeButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.zoomCombo.setEditable(false);
        this.zoomCombo.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.tilePanel.add((Component)this.zoomCombo, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.windowSizeLabel.setToolTipText("The window size over which coverage computed when using the count command.  Defaults to 25 bp.");
        this.windowSizeLabel.setText("Window Size");
        this.tilePanel.add((Component)this.windowSizeLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tilePanel.add((Component)this.windowSizeField, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.tilePanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.sortPanel.setBorder(new TitledBorder(null, "Sort Options", 4, 2));
        this.sortPanel.setLayout(new GridBagLayout());
        this.tmpDirectoryLabel.setToolTipText("<html>Specify a temporary working directory.  For large input files this directory will be used to <br>store intermediate results of the sort. The default is the users temp directory.");
        this.tmpDirectoryLabel.setText("Temp Directory");
        this.sortPanel.add((Component)this.tmpDirectoryLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.maxRecordsLabel.setToolTipText("<html>The maximum number of records to keep in memory during the sort.  The default value is <br>500000.  Increase this number if you receive \"too many open files\" errors.   Decrease it if you <br>experience \"out of memory\" errors.");
        this.maxRecordsLabel.setText("Max Records");
        this.sortPanel.add((Component)this.maxRecordsLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tempButton.setText("Browse");
        this.sortPanel.add((Component)this.tempButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.sortPanel.add((Component)this.tmpDirectoryField, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.sortPanel.add((Component)this.maxRecordsField, new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.sortPanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.runButton.setText("Run");
        this.buttonPanel.add((Component)this.runButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.closeButton.setText("Close");
        this.buttonPanel.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.OutputPanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), "Messages", 4, 2));
        this.OutputPanel.setLayout(null);
        this.outputText.setEditable(false);
        this.outputText.setText("");
        this.outputText.setRows(10);
        this.outputScroll.setViewportView(this.outputText);
        this.OutputPanel.add(this.outputScroll);
        this.outputScroll.setBounds(4, 20, 881, this.outputScroll.getPreferredSize().height);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.OutputPanel.getComponentCount(); ++i) {
            Rectangle bounds = this.OutputPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.OutputPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.OutputPanel.setMinimumSize(preferredSize);
        this.OutputPanel.setPreferredSize(preferredSize);
        this.mainPanel.add((Component)this.OutputPanel, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.mainPanel.add((Component)separator1, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.mainPanel.add((Component)this.progressBar, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }
}

