/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.dev.plugin.Argument;
import org.broad.igv.dev.plugin.AsciiDecoder;
import org.broad.igv.dev.plugin.AsciiEncoder;
import org.broad.igv.dev.plugin.FeatureDecoder;
import org.broad.igv.dev.plugin.FeatureEncoder;
import org.broad.igv.dev.plugin.LineFeatureDecoder;
import org.broad.igv.dev.plugin.LineFeatureEncoder;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.RuntimeUtils;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;

abstract class PluginSource<E extends Feature, D extends Feature> {
    private static Logger log = Logger.getLogger(PluginSource.class);
    protected final List<String> commands;
    protected final LinkedHashMap<Argument, Object> arguments;
    protected boolean strictParsing = true;
    protected String decodingCodec = null;
    protected URL[] decodingLibURLs = new URL[0];
    protected String format = "bed";
    protected List<Map<String, Object>> attributes = new ArrayList<Map<String, Object>>(2);

    public PluginSource(List<String> commands, LinkedHashMap<Argument, Object> arguments, Map<String, String> parsingAttrs, String specPath) {
        this.commands = commands;
        this.arguments = arguments;
        this.setParsingAttributes(parsingAttrs, specPath);
    }

    private void setParsingAttributes(Map<String, String> parsingAttrs, String specPath) {
        String libs;
        this.decodingCodec = parsingAttrs.get("decoding_codec");
        String tmpStrict = parsingAttrs.get("strict");
        String fmt = parsingAttrs.get("format");
        String string = this.format = fmt != null ? fmt : this.format;
        if (tmpStrict != null) {
            this.strictParsing = Boolean.parseBoolean(tmpStrict);
        }
        libs = (libs = parsingAttrs.get("libs")) != null ? libs : "";
        this.decodingLibURLs = FileUtils.getURLsFromString(libs, specPath);
    }

    protected final Map<String, Object> writeFeaturesToStream(OutputStream outputStream, Iterator<E> features, Argument argument) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream));
        Map<String, Object> attributes = null;
        if (features != null) {
            FeatureEncoder<E> codec = this.getEncodingCodec(argument);
            attributes = codec.encodeAll(outputStream, features);
        }
        writer.flush();
        writer.close();
        return attributes;
    }

    protected final String[] genFullCommand(String chr, int start, int end, int zoom) throws IOException {
        ArrayList<String> fullCmd = new ArrayList<String>(this.commands);
        this.attributes.clear();
        HashMap<String, String[]> argValsById = new HashMap<String, String[]>(this.arguments.size());
        block5: for (Map.Entry<Argument, Object> entry : this.arguments.entrySet()) {
            Argument arg = entry.getKey();
            assert (arg.isValidValue(entry.getValue()));
            String[] sVal = null;
            String ts = null;
            switch (arg.getType()) {
                case LONGTEXT: 
                case TEXT: {
                    ts = (String)entry.getValue();
                    if (ts == null || ts.trim().length() == 0) continue block5;
                    sVal = new String[]{ts};
                    if (arg.getType() != Argument.InputType.TEXT) break;
                    sVal = ts.split("\\s+");
                    break;
                }
                case FEATURE_TRACK: 
                case DATA_TRACK: {
                    ts = this.createTempFile((Track)entry.getValue(), arg, chr, start, end, zoom);
                    sVal = new String[]{ts};
                    break;
                }
                case MULTI_FEATURE_TRACK: {
                    sVal = this.createTempFiles((List)entry.getValue(), arg, chr, start, end, zoom);
                }
            }
            if (arg.getId() != null) {
                argValsById.put(arg.getId(), sVal);
            }
            if (!arg.isOutput()) continue;
            String cmdArg = arg.getCmdArg();
            if (cmdArg.trim().length() > 0) {
                for (String argId : argValsById.keySet()) {
                    cmdArg = cmdArg.replace("$" + argId, ((String[])argValsById.get(argId))[0]);
                }
                fullCmd.add(cmdArg);
            }
            fullCmd.addAll(Arrays.asList(sVal));
        }
        return fullCmd.toArray(new String[0]);
    }

    private String[] createTempFiles(List<FeatureTrack> tracks, Argument argument, String chr, int start, int end, int zoom) throws IOException {
        String[] fileNames = new String[tracks.size()];
        int fi = 0;
        for (FeatureTrack track : tracks) {
            fileNames[fi++] = this.createTempFile(track, argument, chr, start, end, zoom);
        }
        return fileNames;
    }

    protected abstract String createTempFile(Track var1, Argument var2, String var3, int var4, int var5, int var6) throws IOException;

    protected final String createTempFile(List<E> features, Argument argument) throws IOException {
        File outFile = File.createTempFile("features", ".tmp", null);
        outFile.deleteOnExit();
        Map<String, Object> attributes = this.writeFeaturesToStream(new FileOutputStream(outFile), features.iterator(), argument);
        String path = outFile.getAbsolutePath();
        this.attributes.add(attributes);
        return path;
    }

    protected final Iterator<D> getFeatures(String chr, int start, int end, int zoom) throws IOException {
        String[] fullCmd = this.genFullCommand(chr, start, end, zoom);
        Process pr = RuntimeUtils.startExternalProcess(fullCmd, null, null);
        FeatureDecoder<D> codec = this.getDecodingCodec();
        return codec.decodeAll(pr.getInputStream(), this.strictParsing);
    }

    protected final FeatureEncoder<E> getEncodingCodec(Argument argument) {
        FeatureEncoder<E> codec = this.instantiateEncodingCodec(argument);
        codec.setInputs(Collections.unmodifiableList(this.commands), Collections.unmodifiableMap(this.arguments));
        return codec;
    }

    private final FeatureEncoder<E> instantiateEncodingCodec(Argument argument) {
        String encodingCodec = argument.getEncodingCodec();
        if (encodingCodec == null) {
            return new AsciiEncoder<Feature>(new IGVBEDCodec());
        }
        URL[] libURLs = argument.getLibURLs();
        try {
            URLClassLoader loader = URLClassLoader.newInstance(libURLs, this.getClass().getClassLoader());
            Class<?> clazz = loader.loadClass(encodingCodec);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object ocodec = constructor.newInstance(new Object[0]);
            AsciiEncoder codec = !(ocodec instanceof FeatureEncoder) && ocodec instanceof LineFeatureEncoder ? new AsciiEncoder((LineFeatureEncoder)ocodec) : (AsciiEncoder)ocodec;
            return codec;
        }
        catch (ClassNotFoundException e) {
            log.error("Could not find class " + encodingCodec, e);
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            log.error("Exception getting encoding codec", e);
            throw new RuntimeException(e);
        }
    }

    protected final FeatureDecoder<D> getDecodingCodec() {
        FeatureDecoder<D> codec = this.instantiateDecodingCodec(this.decodingCodec, this.decodingLibURLs);
        codec.setInputs(Collections.unmodifiableList(this.commands), Collections.unmodifiableMap(this.arguments));
        codec.setAttributes(Collections.unmodifiableList(this.attributes));
        return codec;
    }

    protected final FeatureDecoder<D> instantiateDecodingCodec(String decodingCodec, URL[] libURLs) {
        if (decodingCodec == null) {
            AsciiFeatureCodec asciiCodec = CodecFactory.getCodec("." + this.format, GenomeManager.getInstance().getCurrentGenome());
            if (asciiCodec == null) {
                throw new IllegalArgumentException("Unable to find codec for format " + this.format);
            }
            return new AsciiDecoder.DecoderWrapper(asciiCodec);
        }
        try {
            URLClassLoader loader = URLClassLoader.newInstance(libURLs, this.getClass().getClassLoader());
            Class<?> clazz = loader.loadClass(decodingCodec);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object codec = constructor.newInstance(new Object[0]);
            if (!(codec instanceof FeatureDecoder) && codec instanceof LineFeatureDecoder) {
                return new AsciiDecoder((LineFeatureDecoder)codec);
            }
            return (FeatureDecoder)codec;
        }
        catch (ClassNotFoundException e) {
            log.error("Could not find class " + decodingCodec, e);
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            log.error("Exception getting decoding codec", e);
            throw new RuntimeException(e);
        }
    }
}

