/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import java.awt.Color;
import java.util.List;
import org.broad.igv.data.cufflinks.CufflinksDataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ResourceLocator;

public class CufflinksTrack
extends DataTrack {
    CufflinksDataSource dataSource;

    public CufflinksTrack(ResourceLocator locator, String id, String name, CufflinksDataSource dataSource) {
        super(locator, id, name);
        this.dataSource = dataSource;
        this.setTrackType(TrackType.FPKM);
        if (this.isExpDiff(locator.getPath())) {
            float range = (float)Math.min(5.0, Math.abs(Math.max(dataSource.getDataMin(), dataSource.getDataMax())));
            this.setDataRange(new DataRange(-range, 0.0f, range));
            this.setColor(Color.RED);
            this.setAltColor(Color.BLUE);
            this.setColorScale(new ContinuousColorScale(-range, 0.0, range, Color.RED, Color.WHITE, Color.BLUE));
        } else {
            this.setDataRange(new DataRange((float)dataSource.getDataMin(), 0.0f, (float)dataSource.getDataMax()));
        }
    }

    @Override
    public List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        return this.dataSource.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
    }

    boolean isExpDiff(String path) {
        return path.toLowerCase().endsWith("_exp.diff");
    }
}

