/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.File;
import java.util.List;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.bed.BEDCodec;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class IndexFactoryTest {
    final File sortedBedFile = new File("test/data/bed/Unigene.sample.bed");
    final File unsortedBedFile = new File("test/data/bed/unsorted.bed");
    final File discontinuousFile = new File("test/data/bed/disconcontigs.bed");
    final FeatureCodec bedCodec = new BEDCodec();

    @Test
    public void testCreateLinearIndex() throws Exception {
        Index index = IndexFactory.createLinearIndex(this.sortedBedFile, this.bedCodec);
        String chr = "chr2";
        Assert.assertTrue((boolean)index.getSequenceNames().contains(chr));
        Assert.assertTrue((boolean)index.containsChromosome(chr));
        Assert.assertEquals((int)1, (int)index.getSequenceNames().size());
        List<Block> blocks = index.getBlocks(chr, 1, 50);
        Assert.assertEquals((int)1, (int)blocks.size());
        Block block = blocks.get(0);
        Assert.assertEquals((long)78L, (long)block.getSize());
    }

    @Test(expectedExceptions={TribbleException.MalformedFeatureFile.class}, dataProvider="indexFactoryProvider")
    public void testCreateIndexUnsorted(IndexFactory.IndexType type) throws Exception {
        Index index = IndexFactory.createIndex(this.unsortedBedFile, this.bedCodec, type);
    }

    @Test(expectedExceptions={TribbleException.MalformedFeatureFile.class}, dataProvider="indexFactoryProvider")
    public void testCreateIndexDiscontinuousContigs(IndexFactory.IndexType type) throws Exception {
        Index index = IndexFactory.createIndex(this.discontinuousFile, this.bedCodec, type);
    }

    @DataProvider(name="indexFactoryProvider")
    public Object[][] getIndexFactoryTypes() {
        return new Object[][]{{IndexFactory.IndexType.LINEAR}, {IndexFactory.IndexType.INTERVAL_TREE}};
    }
}

