/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext.writer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.samtools.SAMSequenceDictionary;
import org.broad.tribble.TribbleException;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFAlleleClipper;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineCount;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderVersion;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.LazyGenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.writer.IndexingVariantContextWriter;
import org.broadinstitute.sting.utils.variantcontext.writer.IntGenotypeFieldAccessors;

class VCFWriter
extends IndexingVariantContextWriter {
    private static final String VERSION_LINE = "##" + VCFHeaderVersion.VCF4_1.getFormatString() + "=" + VCFHeaderVersion.VCF4_1.getVersionString();
    protected final BufferedWriter mWriter;
    protected final boolean doNotWriteGenotypes;
    protected VCFHeader mHeader = null;
    private final boolean allowMissingFieldsInHeader;
    private IntGenotypeFieldAccessors intGenotypeFieldAccessors = new IntGenotypeFieldAccessors();
    private static final String QUAL_FORMAT_STRING = "%.2f";
    private static final String QUAL_FORMAT_EXTENSION_TO_TRIM = ".00";

    public VCFWriter(File location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing, boolean doNotWriteGenotypes, boolean allowMissingFieldsInHeader) {
        super(VCFWriter.writerName(location, output), location, output, refDict, enableOnTheFlyIndexing);
        this.mWriter = new BufferedWriter(new OutputStreamWriter(this.getOutputStream()));
        this.doNotWriteGenotypes = doNotWriteGenotypes;
        this.allowMissingFieldsInHeader = allowMissingFieldsInHeader;
    }

    @Override
    public void writeHeader(VCFHeader header) {
        this.mHeader = VCFWriter.writeHeader(header, this.mWriter, this.doNotWriteGenotypes, VCFWriter.getVersionLine(), this.getStreamName());
    }

    public static final String getVersionLine() {
        return VERSION_LINE;
    }

    public static VCFHeader writeHeader(VCFHeader header, Writer writer, boolean doNotWriteGenotypes, String versionLine, String streamNameForError) {
        header = doNotWriteGenotypes ? new VCFHeader(header.getMetaDataInSortedOrder()) : header;
        try {
            writer.write(versionLine + "\n");
            for (VCFHeaderLine line : header.getMetaDataInSortedOrder()) {
                if (VCFHeaderVersion.isFormatString(line.getKey())) continue;
                writer.write("##");
                writer.write(line.toString());
                writer.write("\n");
            }
            writer.write("#");
            boolean isFirst = true;
            for (VCFHeader.HEADER_FIELDS field : header.getHeaderFields()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.write("\t");
                }
                writer.write(field.toString());
            }
            if (header.hasGenotypingData()) {
                writer.write("\t");
                writer.write("FORMAT");
                for (String sample : header.getGenotypeSamples()) {
                    writer.write("\t");
                    writer.write(sample);
                }
            }
            writer.write("\n");
            writer.flush();
        }
        catch (IOException e) {
            throw new ReviewedStingException("IOException writing the VCF header to " + streamNameForError, e);
        }
        return header;
    }

    @Override
    public void close() {
        try {
            this.mWriter.flush();
            this.mWriter.close();
        }
        catch (IOException e) {
            throw new ReviewedStingException("Unable to close " + this.getStreamName(), e);
        }
        super.close();
    }

    @Override
    public void add(VariantContext vc) {
        if (this.mHeader == null) {
            throw new IllegalStateException("The VCF Header must be written before records can be added: " + this.getStreamName());
        }
        if (this.doNotWriteGenotypes) {
            vc = new VariantContextBuilder(vc).noGenotypes().make();
        }
        try {
            vc = VCFAlleleClipper.createVariantContextWithPaddedAlleles(vc);
            super.add(vc);
            Map<Allele, String> alleleMap = VCFWriter.buildAlleleMap(vc);
            this.mWriter.write(vc.getChr());
            this.mWriter.write("\t");
            this.mWriter.write(String.valueOf(vc.getStart()));
            this.mWriter.write("\t");
            String ID = vc.getID();
            this.mWriter.write(ID);
            this.mWriter.write("\t");
            String refString = vc.getReference().getDisplayString();
            this.mWriter.write(refString);
            this.mWriter.write("\t");
            if (vc.isVariant()) {
                Allele altAllele = vc.getAlternateAllele(0);
                String alt = altAllele.getDisplayString();
                this.mWriter.write(alt);
                for (int i = 1; i < vc.getAlternateAlleles().size(); ++i) {
                    altAllele = vc.getAlternateAllele(i);
                    alt = altAllele.getDisplayString();
                    this.mWriter.write(",");
                    this.mWriter.write(alt);
                }
            } else {
                this.mWriter.write(".");
            }
            this.mWriter.write("\t");
            if (!vc.hasLog10PError()) {
                this.mWriter.write(".");
            } else {
                this.mWriter.write(this.formatQualValue(vc.getPhredScaledQual()));
            }
            this.mWriter.write("\t");
            String filters = this.getFilterString(vc);
            this.mWriter.write(filters);
            this.mWriter.write("\t");
            TreeMap<String, String> infoFields = new TreeMap<String, String>();
            for (Map.Entry<String, Object> field : vc.getAttributes().entrySet()) {
                String outputValue;
                String key = field.getKey();
                if (!this.mHeader.hasInfoLine(key)) {
                    this.fieldIsMissingFromHeaderError(vc, key, "INFO");
                }
                if ((outputValue = VCFWriter.formatVCFField(field.getValue())) == null) continue;
                infoFields.put(key, outputValue);
            }
            this.writeInfoString(infoFields);
            GenotypesContext gc = vc.getGenotypes();
            if (gc.isLazyWithData() && ((LazyGenotypesContext)gc).getUnparsedGenotypeData() instanceof String) {
                this.mWriter.write("\t");
                this.mWriter.write(((LazyGenotypesContext)gc).getUnparsedGenotypeData().toString());
            } else {
                List<String> genotypeAttributeKeys = VCFWriter.calcVCFGenotypeKeys(vc, this.mHeader);
                if (!genotypeAttributeKeys.isEmpty()) {
                    for (String format : genotypeAttributeKeys) {
                        if (this.mHeader.hasFormatLine(format)) continue;
                        this.fieldIsMissingFromHeaderError(vc, format, "FORMAT");
                    }
                    String genotypeFormatString = ParsingUtils.join((String)":", genotypeAttributeKeys);
                    this.mWriter.write("\t");
                    this.mWriter.write(genotypeFormatString);
                    this.addGenotypeData(vc, alleleMap, genotypeAttributeKeys);
                }
            }
            this.mWriter.write("\n");
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the VCF object to " + this.getStreamName());
        }
    }

    private static Map<Allele, String> buildAlleleMap(VariantContext vc) {
        HashMap<Allele, String> alleleMap = new HashMap<Allele, String>(vc.getAlleles().size() + 1);
        alleleMap.put(Allele.NO_CALL, ".");
        List<Allele> alleles = vc.getAlleles();
        for (int i = 0; i < alleles.size(); ++i) {
            alleleMap.put(alleles.get(i), String.valueOf(i));
        }
        return alleleMap;
    }

    private final String getFilterString(VariantContext vc) {
        if (vc.isFiltered()) {
            for (String filter : vc.getFilters()) {
                if (this.mHeader.hasFilterLine(filter)) continue;
                this.fieldIsMissingFromHeaderError(vc, filter, "FILTER");
            }
            return ParsingUtils.join((String)";", (Collection)ParsingUtils.sortList(vc.getFilters()));
        }
        if (vc.filtersWereApplied()) {
            return "PASS";
        }
        return ".";
    }

    private String formatQualValue(double qual) {
        String s = String.format(QUAL_FORMAT_STRING, qual);
        if (s.endsWith(QUAL_FORMAT_EXTENSION_TO_TRIM)) {
            s = s.substring(0, s.length() - QUAL_FORMAT_EXTENSION_TO_TRIM.length());
        }
        return s;
    }

    private void writeInfoString(Map<String, String> infoFields) throws IOException {
        if (infoFields.isEmpty()) {
            this.mWriter.write(".");
            return;
        }
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : infoFields.entrySet()) {
            VCFInfoHeaderLine metaData;
            if (isFirst) {
                isFirst = false;
            } else {
                this.mWriter.write(";");
            }
            String key = entry.getKey();
            this.mWriter.write(key);
            if (entry.getValue().equals("") || (metaData = this.mHeader.getInfoHeaderLine(key)) != null && metaData.getCountType() == VCFHeaderLineCount.INTEGER && metaData.getCount() == 0) continue;
            this.mWriter.write("=");
            this.mWriter.write(entry.getValue());
        }
    }

    private void addGenotypeData(VariantContext vc, Map<Allele, String> alleleMap, List<String> genotypeFormatKeys) throws IOException {
        for (String sample : this.mHeader.getGenotypeSamples()) {
            int i;
            this.mWriter.write("\t");
            Genotype g = vc.getGenotype(sample);
            if (g == null) {
                VCFWriter.missingSampleError(vc, this.mHeader);
            }
            ArrayList<String> attrs = new ArrayList<String>(genotypeFormatKeys.size());
            for (String field : genotypeFormatKeys) {
                String outputValue;
                if (field.equals("GT")) {
                    if (!g.isAvailable()) {
                        throw new ReviewedStingException("GTs cannot be missing for some samples if they are available for others in the record");
                    }
                    this.writeAllele(g.getAllele(0), alleleMap);
                    for (int i2 = 1; i2 < g.getPloidy(); ++i2) {
                        this.mWriter.write(g.isPhased() ? "|" : "/");
                        this.writeAllele(g.getAllele(i2), alleleMap);
                    }
                    continue;
                }
                if (field.equals("FT")) {
                    outputValue = g.isFiltered() ? g.getFilters() : "PASS";
                } else {
                    IntGenotypeFieldAccessors.Accessor accessor = this.intGenotypeFieldAccessors.getAccessor(field);
                    if (accessor != null) {
                        int[] intValues = accessor.getValues(g);
                        if (intValues == null) {
                            outputValue = ".";
                        } else if (intValues.length == 1) {
                            outputValue = Integer.toString(intValues[0]);
                        } else {
                            StringBuilder sb = new StringBuilder();
                            sb.append(intValues[0]);
                            for (int i3 = 1; i3 < intValues.length; ++i3) {
                                sb.append(",");
                                sb.append(intValues[i3]);
                            }
                            outputValue = sb.toString();
                        }
                    } else {
                        int numInFormatField;
                        String val = g.hasExtendedAttribute(field) ? g.getExtendedAttribute(field) : ".";
                        VCFFormatHeaderLine metaData = this.mHeader.getFormatHeaderLine(field);
                        if (metaData != null && (numInFormatField = metaData.getCount(vc)) > 1 && val.equals(".")) {
                            StringBuilder sb = new StringBuilder(".");
                            for (int i4 = 1; i4 < numInFormatField; ++i4) {
                                sb.append(",");
                                sb.append(".");
                            }
                            val = sb.toString();
                        }
                        outputValue = VCFWriter.formatVCFField(val);
                    }
                }
                if (outputValue == null) continue;
                attrs.add(outputValue);
            }
            for (i = attrs.size() - 1; i >= 0 && this.isMissingValue((String)attrs.get(i)); --i) {
                attrs.remove(i);
            }
            for (i = 0; i < attrs.size(); ++i) {
                if (i > 0 || genotypeFormatKeys.contains("GT")) {
                    this.mWriter.write(":");
                }
                this.mWriter.write((String)attrs.get(i));
            }
        }
    }

    public static final void missingSampleError(VariantContext vc, VCFHeader header) {
        ArrayList<String> badSampleNames = new ArrayList<String>();
        for (String x : header.getGenotypeSamples()) {
            if (vc.hasGenotype(x)) continue;
            badSampleNames.add(x);
        }
        throw new ReviewedStingException("BUG: we now require all samples in VCFheader to have genotype objects.  Missing samples are " + Utils.join((String)",", badSampleNames));
    }

    private boolean isMissingValue(String s) {
        return VCFWriter.countOccurrences(".".charAt(0), s) + VCFWriter.countOccurrences(',', s) == s.length();
    }

    private void writeAllele(Allele allele, Map<Allele, String> alleleMap) throws IOException {
        String encoding = alleleMap.get(allele);
        if (encoding == null) {
            throw new TribbleException.InternalCodecException("Allele " + allele + " is not an allele in the variant context");
        }
        this.mWriter.write(encoding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String formatVCFDouble(double d) {
        String format;
        if (d < 1.0) {
            if (d < 0.01) {
                if (!(Math.abs(d) >= 1.0E-20)) return "0.00";
                format = "%.3e";
                return String.format(format, d);
            } else {
                format = "%.3f";
            }
            return String.format(format, d);
        } else {
            format = QUAL_FORMAT_STRING;
        }
        return String.format(format, d);
    }

    public static String formatVCFField(Object val) {
        String result;
        if (val == null) {
            result = ".";
        } else if (val instanceof Double) {
            result = VCFWriter.formatVCFDouble((Double)val);
        } else if (val instanceof Boolean) {
            result = (Boolean)val != false ? "" : null;
        } else if (val instanceof List) {
            result = VCFWriter.formatVCFField(((List)val).toArray());
        } else if (val.getClass().isArray()) {
            int length = Array.getLength(val);
            if (length == 0) {
                return VCFWriter.formatVCFField(null);
            }
            StringBuffer sb = new StringBuffer(VCFWriter.formatVCFField(Array.get(val, 0)));
            for (int i = 1; i < length; ++i) {
                sb.append(",");
                sb.append(VCFWriter.formatVCFField(Array.get(val, i)));
            }
            result = sb.toString();
        } else {
            result = val.toString();
        }
        return result;
    }

    public static List<String> calcVCFGenotypeKeys(VariantContext vc, VCFHeader header) {
        HashSet<String> keys = new HashSet<String>();
        boolean sawGoodGT = false;
        boolean sawGoodQual = false;
        boolean sawGenotypeFilter = false;
        boolean sawDP = false;
        boolean sawAD = false;
        boolean sawPL = false;
        for (Genotype g : vc.getGenotypes()) {
            keys.addAll(g.getExtendedAttributes().keySet());
            if (g.isAvailable()) {
                sawGoodGT = true;
            }
            if (g.hasGQ()) {
                sawGoodQual = true;
            }
            if (g.hasDP()) {
                sawDP = true;
            }
            if (g.hasAD()) {
                sawAD = true;
            }
            if (g.hasPL()) {
                sawPL = true;
            }
            if (!g.isFiltered()) continue;
            sawGenotypeFilter = true;
        }
        if (sawGoodQual) {
            keys.add("GQ");
        }
        if (sawDP) {
            keys.add("DP");
        }
        if (sawAD) {
            keys.add("AD");
        }
        if (sawPL) {
            keys.add("PL");
        }
        if (sawGenotypeFilter) {
            keys.add("FT");
        }
        ArrayList<String> sortedList = ParsingUtils.sortList(new ArrayList(keys));
        if (sawGoodGT) {
            ArrayList<String> newList = new ArrayList<String>(sortedList.size() + 1);
            newList.add("GT");
            newList.addAll(sortedList);
            sortedList = newList;
        }
        if (sortedList.isEmpty() && header.hasGenotypingData()) {
            return Collections.singletonList("GT");
        }
        return sortedList;
    }

    private static int countOccurrences(char c, String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            count += s.charAt(i) == c ? 1 : 0;
        }
        return count;
    }

    private final void fieldIsMissingFromHeaderError(VariantContext vc, String id, String field) {
        if (!this.allowMissingFieldsInHeader) {
            throw new UserException.MalformedVCFHeader("Key " + id + " found in VariantContext field " + field + " at " + vc.getChr() + ":" + vc.getStart() + " but this key isn't defined in the VCFHeader.  The GATK now requires all VCFs to have" + " complete VCF headers by default.  This error can be disabled with the engine argument" + " -U LENIENT_VCF_PROCESSING or repair the VCF file header using repairVCFHeader");
        }
    }
}

