/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.CommonInfo;
import org.broadinstitute.sting.utils.variantcontext.FastGenotype;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.sting.utils.variantcontext.GenotypeType;

@Deprecated
public class SlowGenotype
extends Genotype {
    protected CommonInfo commonInfo;
    public static final double NO_LOG10_PERROR = 1.0;
    protected List<Allele> alleles = null;
    protected boolean isPhased = false;

    protected SlowGenotype(String sampleName, List<Allele> alleles, double log10PError, String filters, Map<String, Object> attributes, boolean isPhased, double[] log10Likelihoods) {
        super(sampleName, filters);
        this.alleles = alleles == null || alleles.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(alleles);
        this.commonInfo = new CommonInfo(sampleName, log10PError, Collections.<String>emptySet(), attributes);
        if (log10Likelihoods != null) {
            this.commonInfo.putAttribute("PL", GenotypeLikelihoods.fromLog10Likelihoods(log10Likelihoods));
        }
        this.isPhased = isPhased;
        this.validate();
    }

    @Override
    public List<Allele> getAlleles() {
        return this.alleles;
    }

    @Override
    public Allele getAllele(int i) {
        if (this.getType() == GenotypeType.UNAVAILABLE) {
            throw new ReviewedStingException("Requesting alleles for an UNAVAILABLE genotype");
        }
        return this.alleles.get(i);
    }

    @Override
    public boolean isPhased() {
        return this.isPhased;
    }

    @Override
    public boolean hasLikelihoods() {
        return this.commonInfo.hasAttribute("PL") && !this.commonInfo.getAttribute("PL").equals(".") || this.commonInfo.hasAttribute("GL") && !this.commonInfo.getAttribute("GL").equals(".");
    }

    @Override
    public GenotypeLikelihoods getLikelihoods() {
        GenotypeLikelihoods x = this.getLikelihoods("PL", true);
        if (x != null) {
            return x;
        }
        x = this.getLikelihoods("GL", false);
        return x;
    }

    private GenotypeLikelihoods getLikelihoods(String key, boolean asPL) {
        Object x = this.commonInfo.getAttribute(key);
        if (x instanceof String) {
            if (asPL) {
                return GenotypeLikelihoods.fromPLField((String)x);
            }
            return GenotypeLikelihoods.fromGLField((String)x);
        }
        if (x instanceof GenotypeLikelihoods) {
            return (GenotypeLikelihoods)x;
        }
        return null;
    }

    private final void validate() {
        if (this.alleles.size() == 0) {
            return;
        }
        for (Allele allele : this.alleles) {
            if (allele != null) continue;
            throw new IllegalArgumentException("BUG: allele cannot be null in Genotype");
        }
    }

    @Override
    public boolean hasLog10PError() {
        return this.commonInfo.hasLog10PError();
    }

    @Override
    public double getLog10PError() {
        return this.commonInfo.getLog10PError();
    }

    @Override
    public boolean hasExtendedAttribute(String key) {
        return this.commonInfo.hasAttribute(key);
    }

    @Override
    public Object getExtendedAttribute(String key) {
        return this.commonInfo.getAttribute(key);
    }

    @Override
    public Object getExtendedAttribute(String key, Object defaultValue) {
        return this.commonInfo.getAttribute(key, defaultValue);
    }

    @Override
    public int[] getPL() {
        return this.hasPL() ? this.getLikelihoods().getAsPLs() : null;
    }

    @Override
    public boolean hasPL() {
        return this.hasLikelihoods();
    }

    @Override
    public int getDP() {
        return this.commonInfo.getAttributeAsInt("DP", -1);
    }

    @Override
    public boolean hasDP() {
        return this.commonInfo.hasAttribute("DP");
    }

    @Override
    public int[] getAD() {
        if (this.hasAD()) {
            return (int[])this.commonInfo.getAttribute("AD");
        }
        return null;
    }

    @Override
    public boolean hasAD() {
        return this.commonInfo.hasAttribute("AD");
    }

    @Override
    public int getGQ() {
        if (this.commonInfo.hasLog10PError()) {
            return (int)Math.round(this.commonInfo.getPhredScaledQual());
        }
        return -1;
    }

    @Override
    public boolean hasGQ() {
        return this.hasLog10PError();
    }

    @Override
    public Map<String, Object> getExtendedAttributes() {
        LinkedHashMap<String, Object> ea = new LinkedHashMap<String, Object>(this.commonInfo.getAttributes());
        for (String primary : FastGenotype.PRIMARY_KEYS) {
            ea.remove(primary);
        }
        return ea;
    }
}

