/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.DataSeriesReader;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Bases;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.Scores;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CRAMCompressionRecord;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CompressorCache;
import htsjdk.samtools.cram.structure.DataSeries;
import htsjdk.samtools.cram.structure.DataSeriesType;
import htsjdk.samtools.cram.structure.EncodingDescriptor;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;

public final class CramRecordReader {
    private final DataSeriesReader<Integer> bitFlagsCodec;
    private final DataSeriesReader<Integer> compressionBitFlagsCodec;
    private final DataSeriesReader<Integer> readLengthCodec;
    private final DataSeriesReader<Integer> alignmentStartCodec;
    private final DataSeriesReader<Integer> readGroupCodec;
    private final DataSeriesReader<byte[]> readNameCodec;
    private final DataSeriesReader<Integer> distanceToNextFragmentCodec;
    private final Map<Integer, DataSeriesReader<byte[]>> tagValueCodecs;
    private final DataSeriesReader<Integer> numberOfReadFeaturesCodec;
    private final DataSeriesReader<Integer> readFeaturePositionCodec;
    private final DataSeriesReader<Byte> readFeatureCodeCodec;
    private final DataSeriesReader<Byte> baseCodec;
    private final DataSeriesReader<byte[]> qualityScoreArrayCodec;
    private final DataSeriesReader<Byte> baseSubstitutionCodec;
    private final DataSeriesReader<byte[]> insertionCodec;
    private final DataSeriesReader<byte[]> softClipCodec;
    private final DataSeriesReader<Integer> hardClipCodec;
    private final DataSeriesReader<Integer> paddingCodec;
    private final DataSeriesReader<Integer> deletionLengthCodec;
    private final DataSeriesReader<Integer> mappingScoreCodec;
    private final DataSeriesReader<Integer> mateBitFlagCodec;
    private final DataSeriesReader<Integer> mateReferenceIdCodec;
    private final DataSeriesReader<Integer> mateAlignmentStartCodec;
    private final DataSeriesReader<Integer> insertSizeCodec;
    private final DataSeriesReader<Integer> tagIdListCodec;
    private final DataSeriesReader<Integer> refIdCodec;
    private final DataSeriesReader<Integer> refSkipCodec;
    private final DataSeriesReader<byte[]> basesCodec;
    private final DataSeriesReader<Byte> qualityScoreCodec;
    private final DataSeriesReader<byte[]> qualityScoresCodec;
    private final Charset charset = Charset.forName("UTF8");
    private final Slice slice;
    private final CompressionHeader compressionHeader;
    private final SliceBlocksReadStreams sliceBlocksReadStreams;
    protected final ValidationStringency validationStringency;

    public CramRecordReader(Slice slice, CompressorCache compressorCache, ValidationStringency validationStringency) {
        this.slice = slice;
        this.compressionHeader = slice.getCompressionHeader();
        this.validationStringency = validationStringency;
        this.sliceBlocksReadStreams = new SliceBlocksReadStreams(slice.getSliceBlocks(), compressorCache);
        this.bitFlagsCodec = this.createDataSeriesReader(DataSeries.BF_BitFlags);
        this.compressionBitFlagsCodec = this.createDataSeriesReader(DataSeries.CF_CompressionBitFlags);
        this.readLengthCodec = this.createDataSeriesReader(DataSeries.RL_ReadLength);
        this.alignmentStartCodec = this.createDataSeriesReader(DataSeries.AP_AlignmentPositionOffset);
        this.readGroupCodec = this.createDataSeriesReader(DataSeries.RG_ReadGroup);
        this.readNameCodec = this.createDataSeriesReader(DataSeries.RN_ReadName);
        this.distanceToNextFragmentCodec = this.createDataSeriesReader(DataSeries.NF_RecordsToNextFragment);
        this.numberOfReadFeaturesCodec = this.createDataSeriesReader(DataSeries.FN_NumberOfReadFeatures);
        this.readFeaturePositionCodec = this.createDataSeriesReader(DataSeries.FP_FeaturePosition);
        this.readFeatureCodeCodec = this.createDataSeriesReader(DataSeries.FC_FeatureCode);
        this.baseCodec = this.createDataSeriesReader(DataSeries.BA_Base);
        this.baseSubstitutionCodec = this.createDataSeriesReader(DataSeries.BS_BaseSubstitutionCode);
        this.insertionCodec = this.createDataSeriesReader(DataSeries.IN_Insertion);
        this.softClipCodec = this.createDataSeriesReader(DataSeries.SC_SoftClip);
        this.hardClipCodec = this.createDataSeriesReader(DataSeries.HC_HardClip);
        this.paddingCodec = this.createDataSeriesReader(DataSeries.PD_padding);
        this.deletionLengthCodec = this.createDataSeriesReader(DataSeries.DL_DeletionLength);
        this.mappingScoreCodec = this.createDataSeriesReader(DataSeries.MQ_MappingQualityScore);
        this.mateBitFlagCodec = this.createDataSeriesReader(DataSeries.MF_MateBitFlags);
        this.mateReferenceIdCodec = this.createDataSeriesReader(DataSeries.NS_NextFragmentReferenceSequenceID);
        this.mateAlignmentStartCodec = this.createDataSeriesReader(DataSeries.NP_NextFragmentAlignmentStart);
        this.insertSizeCodec = this.createDataSeriesReader(DataSeries.TS_InsertSize);
        this.tagIdListCodec = this.createDataSeriesReader(DataSeries.TL_TagIdList);
        this.refIdCodec = this.createDataSeriesReader(DataSeries.RI_RefId);
        this.refSkipCodec = this.createDataSeriesReader(DataSeries.RS_RefSkip);
        this.basesCodec = this.createDataSeriesReader(DataSeries.BB_Bases);
        this.qualityScoreCodec = this.createDataSeriesReader(DataSeries.QS_QualityScore);
        this.qualityScoresCodec = this.createDataSeriesReader(DataSeries.QQ_scores);
        this.qualityScoreArrayCodec = new DataSeriesReader(DataSeriesType.BYTE_ARRAY, this.compressionHeader.getEncodingMap().getEncodingDescriptorForDataSeries(DataSeries.QS_QualityScore), this.sliceBlocksReadStreams);
        this.tagValueCodecs = this.compressionHeader.getTagEncodingMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, mapEntry -> new DataSeriesReader(DataSeriesType.BYTE_ARRAY, (EncodingDescriptor)mapEntry.getValue(), this.sliceBlocksReadStreams)));
    }

    public CRAMCompressionRecord readCRAMRecord(long sequentialIndex, int prevAlignmentStart) {
        int bamFlags = this.bitFlagsCodec.readData();
        int cramFlags = this.compressionBitFlagsCodec.readData();
        int referenceIndex = this.slice.getAlignmentContext().getReferenceContext().isMultiRef() ? this.refIdCodec.readData().intValue() : this.slice.getAlignmentContext().getReferenceContext().getReferenceContextID();
        int readLength = this.readLengthCodec.readData();
        int alignmentStart = this.compressionHeader.isAPDelta() ? prevAlignmentStart + this.alignmentStartCodec.readData() : this.alignmentStartCodec.readData();
        int readGroupID = this.readGroupCodec.readData();
        String readName = null;
        if (this.compressionHeader.isPreserveReadNames()) {
            readName = new String(this.readNameCodec.readData(), this.charset);
        }
        int mateFlags = 0;
        int mateSequenceID = -1;
        int mateAlignmentStart = 0;
        int templateSize = 0;
        int recordsToNextFragment = -1;
        if (CRAMCompressionRecord.isDetached(cramFlags)) {
            mateFlags = this.mateBitFlagCodec.readData();
            if ((mateFlags & 1) != 0) {
                bamFlags |= SAMFlag.MATE_REVERSE_STRAND.intValue();
            }
            if ((mateFlags & 2) != 0) {
                bamFlags |= SAMFlag.MATE_UNMAPPED.intValue();
            }
            if (!this.compressionHeader.isPreserveReadNames()) {
                readName = new String(this.readNameCodec.readData(), this.charset);
            }
            mateSequenceID = this.mateReferenceIdCodec.readData();
            mateAlignmentStart = this.mateAlignmentStartCodec.readData();
            templateSize = this.insertSizeCodec.readData();
        } else if (CRAMCompressionRecord.isHasMateDownStream(cramFlags)) {
            recordsToNextFragment = this.distanceToNextFragmentCodec.readData();
        }
        ArrayList<ReadTag> readTags = null;
        Integer tagIdList = this.tagIdListCodec.readData();
        byte[][] ids = this.compressionHeader.getTagIDDictionary()[tagIdList];
        if (ids.length > 0) {
            readTags = new ArrayList<ReadTag>(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                int id = ReadTag.name3BytesToInt(ids[i]);
                DataSeriesReader<byte[]> dataSeriesReader = this.tagValueCodecs.get(id);
                ReadTag tag = new ReadTag(id, dataSeriesReader.readData(), this.validationStringency);
                readTags.add(tag);
            }
        }
        int mappingQuality = 0;
        ArrayList<ReadFeature> readFeatures = null;
        byte[] readBases = SAMRecord.NULL_SEQUENCE;
        byte[] qualityScores = SAMRecord.NULL_QUALS;
        if (!CRAMCompressionRecord.isSegmentUnmapped(bamFlags)) {
            int size = this.numberOfReadFeaturesCodec.readData();
            int prevPos = 0;
            if (size > 0) {
                readFeatures = new ArrayList<ReadFeature>(size);
                block15: for (int i = 0; i < size; ++i) {
                    int pos;
                    Byte operator = this.readFeatureCodeCodec.readData();
                    prevPos = pos = prevPos + this.readFeaturePositionCodec.readData();
                    switch (operator) {
                        case 66: {
                            ReadBase readBase = new ReadBase(pos, this.baseCodec.readData(), this.qualityScoreCodec.readData());
                            readFeatures.add(readBase);
                            continue block15;
                        }
                        case 88: {
                            byte code = this.baseSubstitutionCodec.readData();
                            Substitution substitution = new Substitution(pos, code);
                            readFeatures.add(substitution);
                            continue block15;
                        }
                        case 73: {
                            Insertion insertion = new Insertion(pos, this.insertionCodec.readData());
                            readFeatures.add(insertion);
                            continue block15;
                        }
                        case 83: {
                            SoftClip softClip = new SoftClip(pos, this.softClipCodec.readData());
                            readFeatures.add(softClip);
                            continue block15;
                        }
                        case 72: {
                            HardClip hardClip = new HardClip(pos, this.hardClipCodec.readData());
                            readFeatures.add(hardClip);
                            continue block15;
                        }
                        case 80: {
                            Padding padding = new Padding(pos, this.paddingCodec.readData());
                            readFeatures.add(padding);
                            continue block15;
                        }
                        case 68: {
                            Deletion deletion = new Deletion(pos, this.deletionLengthCodec.readData());
                            readFeatures.add(deletion);
                            continue block15;
                        }
                        case 78: {
                            RefSkip refSkip = new RefSkip(pos, this.refSkipCodec.readData());
                            readFeatures.add(refSkip);
                            continue block15;
                        }
                        case 105: {
                            InsertBase insertBase = new InsertBase(pos, this.baseCodec.readData());
                            readFeatures.add(insertBase);
                            continue block15;
                        }
                        case 81: {
                            BaseQualityScore baseQualityScore = new BaseQualityScore(pos, this.qualityScoreCodec.readData());
                            readFeatures.add(baseQualityScore);
                            continue block15;
                        }
                        case 98: {
                            Bases bases = new Bases(pos, this.basesCodec.readData());
                            readFeatures.add(bases);
                            continue block15;
                        }
                        case 113: {
                            Scores scores = new Scores(pos, this.qualityScoresCodec.readData());
                            readFeatures.add(scores);
                            continue block15;
                        }
                        default: {
                            throw new RuntimeException("Unknown read feature operator: " + operator);
                        }
                    }
                }
            }
            mappingQuality = this.mappingScoreCodec.readData();
            if (CRAMCompressionRecord.isForcePreserveQualityScores(cramFlags)) {
                qualityScores = this.qualityScoreArrayCodec.readDataArray(readLength);
            }
        } else if (!CRAMCompressionRecord.isUnknownBases(cramFlags)) {
            readBases = new byte[readLength];
            for (int i = 0; i < readBases.length; ++i) {
                readBases[i] = this.baseCodec.readData();
            }
            if (CRAMCompressionRecord.isForcePreserveQualityScores(cramFlags)) {
                qualityScores = this.qualityScoreArrayCodec.readDataArray(readLength);
            }
        }
        return new CRAMCompressionRecord(sequentialIndex, bamFlags, cramFlags, readName, readLength, referenceIndex, alignmentStart, templateSize, mappingQuality, qualityScores, readBases, readTags, readFeatures, readGroupID, mateFlags, mateSequenceID, mateAlignmentStart, recordsToNextFragment);
    }

    private <T> DataSeriesReader<T> createDataSeriesReader(DataSeries dataSeries) {
        EncodingDescriptor encodingDescriptor = this.compressionHeader.getEncodingMap().getEncodingDescriptorForDataSeries(dataSeries);
        if (encodingDescriptor != null) {
            return new DataSeriesReader(dataSeries.getType(), encodingDescriptor, this.sliceBlocksReadStreams);
        }
        return null;
    }
}

