/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LookupDeveloperIdentityRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, LookupDeveloperIdentityRequest> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(LookupDeveloperIdentityRequest.getter(LookupDeveloperIdentityRequest::identityPoolId)).setter(LookupDeveloperIdentityRequest.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityId").getter(LookupDeveloperIdentityRequest.getter(LookupDeveloperIdentityRequest::identityId)).setter(LookupDeveloperIdentityRequest.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()}).build();
    private static final SdkField<String> DEVELOPER_USER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeveloperUserIdentifier").getter(LookupDeveloperIdentityRequest.getter(LookupDeveloperIdentityRequest::developerUserIdentifier)).setter(LookupDeveloperIdentityRequest.setter(Builder::developerUserIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperUserIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(LookupDeveloperIdentityRequest.getter(LookupDeveloperIdentityRequest::maxResults)).setter(LookupDeveloperIdentityRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(LookupDeveloperIdentityRequest.getter(LookupDeveloperIdentityRequest::nextToken)).setter(LookupDeveloperIdentityRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD, IDENTITY_ID_FIELD, DEVELOPER_USER_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LookupDeveloperIdentityRequest.memberNameToFieldInitializer();
    private final String identityPoolId;
    private final String identityId;
    private final String developerUserIdentifier;
    private final Integer maxResults;
    private final String nextToken;

    private LookupDeveloperIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.developerUserIdentifier = builder.developerUserIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final String identityId() {
        return this.identityId;
    }

    public final String developerUserIdentifier() {
        return this.developerUserIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.developerUserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupDeveloperIdentityRequest)) {
            return false;
        }
        LookupDeveloperIdentityRequest other = (LookupDeveloperIdentityRequest)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.developerUserIdentifier(), other.developerUserIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"LookupDeveloperIdentityRequest").add("IdentityPoolId", (Object)this.identityPoolId()).add("IdentityId", (Object)this.identityId()).add("DeveloperUserIdentifier", (Object)this.developerUserIdentifier()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "DeveloperUserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.developerUserIdentifier()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdentityPoolId", IDENTITY_POOL_ID_FIELD);
        map.put("IdentityId", IDENTITY_ID_FIELD);
        map.put("DeveloperUserIdentifier", DEVELOPER_USER_IDENTIFIER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LookupDeveloperIdentityRequest, T> g) {
        return obj -> g.apply((LookupDeveloperIdentityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityId;
        private String developerUserIdentifier;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupDeveloperIdentityRequest model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.identityId(model.identityId);
            this.developerUserIdentifier(model.developerUserIdentifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final String getDeveloperUserIdentifier() {
            return this.developerUserIdentifier;
        }

        public final void setDeveloperUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
        }

        @Override
        public final Builder developerUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LookupDeveloperIdentityRequest build() {
            return new LookupDeveloperIdentityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, LookupDeveloperIdentityRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityId(String var1);

        public Builder developerUserIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

