/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.cram;

import htsjdk.io.IOPath;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import java.util.Optional;

public class CRAMEncoderOptions {
    private CRAMReferenceSource referenceSource;
    private IOPath referencePath;

    public Optional<CRAMReferenceSource> getReferenceSource() {
        return Optional.ofNullable(this.referenceSource);
    }

    public CRAMEncoderOptions setReferenceSource(CRAMReferenceSource referenceSource) {
        if (this.referencePath != null) {
            throw new IllegalStateException(String.format("Reference source and reference path are mutually exclusive. Reference path already has value %s.", this.referencePath.getRawInputString()));
        }
        this.referencePath = null;
        this.referenceSource = referenceSource;
        return this;
    }

    public Optional<IOPath> getReferencePath() {
        return Optional.ofNullable(this.referencePath);
    }

    public CRAMEncoderOptions setReferencePath(IOPath referencePath) {
        if (this.referenceSource != null) {
            throw new IllegalStateException(String.format("Reference path and reference source are mutually exclusive. Reference source already has value %s.", this.referenceSource));
        }
        this.referenceSource = null;
        this.referencePath = referencePath;
        return this;
    }
}

