/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans.ransnx16;

import htsjdk.samtools.cram.compression.rans.RANSParams;

public class RANSNx16Params
implements RANSParams {
    public static final int ORDER_FLAG_MASK = 1;
    public static final int N32_FLAG_MASK = 4;
    public static final int STRIPE_FLAG_MASK = 8;
    public static final int NOSZ_FLAG_MASK = 16;
    public static final int CAT_FLAG_MASK = 32;
    public static final int RLE_FLAG_MASK = 64;
    public static final int PACK_FLAG_MASK = 128;
    private int formatFlags;
    private static final int FORMAT_FLAG_MASK = 255;

    public RANSNx16Params(int formatFlags) {
        this.formatFlags = formatFlags;
    }

    public String toString() {
        return "RANSNx16Params{formatFlags=" + this.formatFlags + "}";
    }

    @Override
    public RANSParams.ORDER getOrder() {
        return RANSParams.ORDER.fromInt(this.formatFlags & 1);
    }

    @Override
    public int getFormatFlags() {
        return this.formatFlags & 0xFF;
    }

    public int getNumInterleavedRANSStates() {
        return (this.formatFlags & 4) == 0 ? 4 : 32;
    }

    public boolean isStripe() {
        return (this.formatFlags & 8) != 0;
    }

    public boolean isNosz() {
        return (this.formatFlags & 0x10) != 0;
    }

    public boolean isCAT() {
        return (this.formatFlags & 0x20) != 0;
    }

    public boolean isRLE() {
        return (this.formatFlags & 0x40) != 0;
    }

    public boolean isPack() {
        return (this.formatFlags & 0x80) != 0;
    }
}

