/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.range;

import java.nio.ByteBuffer;

public class RangeCoder {
    private long low = 0L;
    private long range = 0xFFFFFFFFL;
    private long code = 0L;
    private int FFnum = 0;
    private boolean carry = false;
    private int cache = 0;

    public void rangeDecodeStart(ByteBuffer inBuffer) {
        for (int i = 0; i < 5; ++i) {
            this.code = (this.code << 8) + (long)(inBuffer.get() & 0xFF);
        }
        this.code &= 0xFFFFFFFFL;
    }

    protected void rangeDecode(ByteBuffer inBuffer, int cumulativeFrequency, int symbolFrequency) {
        this.code -= (long)cumulativeFrequency * this.range;
        this.range *= (long)symbolFrequency;
        while (this.range < 0x1000000L) {
            this.range <<= 8;
            this.code = (this.code << 8) + (long)(inBuffer.get() & 0xFF);
        }
    }

    protected int rangeGetFrequency(int totalFrequency) {
        this.range = (long)Math.floor(this.range / (long)totalFrequency);
        return (int)Math.floor(this.code / this.range);
    }

    protected void rangeEncode(ByteBuffer outBuffer, int cumulativeFrequency, int symbolFrequency, int totalFrequency) {
        long old_low = this.low;
        this.range = (long)Math.floor(this.range / (long)totalFrequency);
        this.low += (long)cumulativeFrequency * this.range;
        this.low &= 0xFFFFFFFFL;
        this.range *= (long)symbolFrequency;
        if (this.low < old_low) {
            this.carry = true;
        }
        while (this.range < 0x1000000L) {
            this.range <<= 8;
            this.rangeShiftLow(outBuffer);
        }
    }

    protected void rangeEncodeEnd(ByteBuffer outBuffer) {
        for (int i = 0; i < 5; ++i) {
            this.rangeShiftLow(outBuffer);
        }
    }

    private void rangeShiftLow(ByteBuffer outBuffer) {
        if (this.low < 0xFF000000L || this.carry) {
            if (!this.carry) {
                outBuffer.put((byte)this.cache);
                while (this.FFnum > 0) {
                    outBuffer.put((byte)-1);
                    --this.FFnum;
                }
            } else {
                outBuffer.put((byte)(this.cache + 1));
                while (this.FFnum > 0) {
                    outBuffer.put((byte)0);
                    --this.FFnum;
                }
            }
            this.cache = (int)(this.low >>> 24);
            this.carry = false;
        } else {
            ++this.FFnum;
        }
        this.low = this.low << 8 & 0xFFFFFFFFL;
    }
}

