/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BinaryTagCodec;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.TagValueAndUnsignedArrayFlag;
import htsjdk.samtools.util.DateParser;
import htsjdk.samtools.util.Iso8601Date;
import htsjdk.samtools.util.StringUtil;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

public class TextTagCodec {
    private static final int NUM_TAG_FIELDS = 3;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String[] fields = new String[3];

    public String encode(String tagName, Object value) {
        long longVal;
        StringBuilder sb = new StringBuilder(tagName);
        sb.append(':');
        char tagType = BinaryTagCodec.getTagValueType(value);
        switch (tagType) {
            case 'C': 
            case 'I': 
            case 'S': 
            case 'c': 
            case 's': {
                tagType = 'i';
            }
        }
        if (tagType == 'H') {
            value = StringUtil.bytesToHexString((byte[])value);
        } else if (tagType == 'B') {
            value = TextTagCodec.getArrayType(value, false) + TextTagCodec.encodeArrayValue(value);
        } else if (tagType == 'i' && ((longVal = ((Number)value).longValue()) < Integer.MIN_VALUE || longVal > 0xFFFFFFFFL)) {
            throw new IllegalArgumentException("Value for tag " + tagName + " cannot be stored in either a signed or unsigned 32-bit integer: " + longVal);
        }
        sb.append(tagType).append(':').append(value.toString());
        return sb.toString();
    }

    private static char getArrayType(Object array, boolean isUnsigned) {
        int type;
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType == Float.TYPE) {
            if (isUnsigned) {
                throw new IllegalArgumentException("float array cannot be unsigned");
            }
            return 'f';
        }
        if (componentType == Byte.TYPE) {
            type = 99;
        } else if (componentType == Short.TYPE) {
            type = 115;
        } else if (componentType == Integer.TYPE) {
            type = 105;
        } else {
            throw new IllegalArgumentException("Unrecognized array type " + String.valueOf(componentType));
        }
        return (char)((int)(isUnsigned ? Character.toUpperCase((char)type) : type));
    }

    private static String encodeArrayValue(Object value) {
        int length = Array.getLength(value);
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            ret.append(',');
            ret.append(Array.get(value, i).toString());
        }
        return ret.toString();
    }

    private static long[] widenToUnsigned(Object array) {
        long mask;
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType == Byte.TYPE) {
            mask = 255L;
        } else if (componentType == Short.TYPE) {
            mask = 65535L;
        } else if (componentType == Integer.TYPE) {
            mask = 0xFFFFFFFFL;
        } else {
            throw new IllegalArgumentException("Unrecognized unsigned array type " + String.valueOf(componentType));
        }
        long[] ret = new long[Array.getLength(array)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Array.getLong(array, i) & mask;
        }
        return ret;
    }

    String encodeUnsignedArray(String tagName, Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Non-array passed to encodeUnsignedArray: " + String.valueOf(array.getClass()));
        }
        long[] widened = TextTagCodec.widenToUnsigned(array);
        return tagName + ":B:" + TextTagCodec.getArrayType(array, true) + TextTagCodec.encodeArrayValue(widened);
    }

    public String encodeUntypedTag(String tagName, Object value) {
        return tagName + ':' + value.toString();
    }

    public Map.Entry<String, Object> decode(String tag) {
        int numFields = StringUtil.splitConcatenateExcessTokens(tag, this.fields, ':');
        if (numFields != 3 && numFields != 2) {
            throw new SAMFormatException("Not enough fields in tag '" + tag + "'");
        }
        final String key = this.fields[0];
        String type = this.fields[1];
        String stringVal = numFields == 3 ? this.fields[2] : "";
        final Object val = TextTagCodec.convertStringToObject(type, stringVal);
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Object getValue() {
                return val;
            }

            @Override
            public Object setValue(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Object convertStringToObject(String type, String stringVal) {
        if (type.equals("Z")) {
            return stringVal;
        }
        if (type.equals("A")) {
            if (stringVal.length() != 1) {
                throw new SAMFormatException("Tag of type A should have a single-character value");
            }
            return Character.valueOf(stringVal.charAt(0));
        }
        if (type.equals("i")) {
            long lValue;
            try {
                lValue = Long.parseLong(stringVal);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type i should have signed decimal value");
            }
            if (lValue >= Integer.MIN_VALUE && lValue <= Integer.MAX_VALUE) {
                return (int)lValue;
            }
            if (SAMUtils.isValidUnsignedIntegerAttribute(lValue)) {
                return lValue;
            }
            throw new SAMFormatException("Integer is out of range for both a 32-bit signed and unsigned integer: " + stringVal);
        }
        if (type.equals("f")) {
            try {
                return Float.valueOf(Float.parseFloat(stringVal));
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type f should have single-precision floating point value");
            }
        }
        if (type.equals("H")) {
            try {
                return StringUtil.hexStringToBytes(stringVal);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type H should have valid hex string with even number of digits");
            }
        }
        if (type.equals("B")) {
            return TextTagCodec.covertStringArrayToObject(stringVal);
        }
        throw new SAMFormatException("Unrecognized tag type: " + type);
    }

    private static Object covertStringArrayToObject(String stringVal) {
        String[] stringValues;
        String[] elementTypeAndValue = new String[2];
        int numberOfTokens = StringUtil.splitConcatenateExcessTokens(stringVal, elementTypeAndValue, ',');
        if (elementTypeAndValue[0].length() != 1) {
            throw new SAMFormatException("Unrecognized element type for array tag value: " + elementTypeAndValue[0]);
        }
        char elementType = elementTypeAndValue[0].charAt(0);
        String[] stringArray = stringValues = elementTypeAndValue[1] != null ? elementTypeAndValue[1].split(",") : EMPTY_STRING_ARRAY;
        if (elementType == 'f') {
            float[] ret = new float[stringValues.length];
            for (int i = 0; i < stringValues.length; ++i) {
                try {
                    ret[i] = Float.parseFloat(stringValues[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SAMFormatException("Array tag of type f should have single-precision floating point value");
                }
            }
            return ret;
        }
        long mask = Long.MAX_VALUE;
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        boolean isUnsigned = Character.isUpperCase(elementType);
        switch (Character.toLowerCase(elementType)) {
            case 'c': {
                if (isUnsigned) {
                    mask = 255L;
                    break;
                }
                minValue = -128L;
                maxValue = 127L;
                break;
            }
            case 's': {
                if (isUnsigned) {
                    mask = 65535L;
                    break;
                }
                minValue = -32768L;
                maxValue = 32767L;
                break;
            }
            case 'i': {
                if (isUnsigned) {
                    mask = 0xFFFFFFFFL;
                    break;
                }
                minValue = Integer.MIN_VALUE;
                maxValue = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new SAMFormatException("Unrecognized array tag element type: " + elementType);
            }
        }
        if (isUnsigned) {
            minValue = 0L;
            maxValue = mask;
        }
        long[] longValues = new long[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            long longValue;
            try {
                longValue = Long.parseLong(stringValues[i]);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Array tag of type " + elementType + " should have integral value");
            }
            if (longValue < minValue || longValue > maxValue) {
                throw new SAMFormatException("Value for element of array tag of type " + elementType + " is out of allowed range: " + longValue);
            }
            longValues[i] = longValue;
        }
        switch (Character.toLowerCase(elementType)) {
            case 'c': {
                byte[] array = new byte[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    array[i] = (byte)longValues[i];
                }
                if (isUnsigned) {
                    return new TagValueAndUnsignedArrayFlag(array, true);
                }
                return array;
            }
            case 's': {
                short[] array = new short[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    array[i] = (short)longValues[i];
                }
                if (isUnsigned) {
                    return new TagValueAndUnsignedArrayFlag(array, true);
                }
                return array;
            }
            case 'i': {
                int[] array = new int[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    array[i] = (int)longValues[i];
                }
                if (isUnsigned) {
                    return new TagValueAndUnsignedArrayFlag(array, true);
                }
                return array;
            }
        }
        throw new SAMFormatException("Unrecognized array tag element type: " + elementType);
    }

    Iso8601Date decodeDate(String dateStr) {
        try {
            return new Iso8601Date(dateStr);
        }
        catch (DateParser.InvalidDateException ex) {
            try {
                return new Iso8601Date(DateFormat.getDateTimeInstance().parse(dateStr));
            }
            catch (ParseException e) {
                try {
                    return new Iso8601Date(new Date(dateStr));
                }
                catch (Exception e1) {
                    throw new DateParser.InvalidDateException("Could not parse as date: " + dateStr, e);
                }
            }
        }
    }
}

