/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import javax.swing.JMenu;
import org.broad.igv.session.autosave.SessionAutosaveManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.OpenSessionMenuAction;
import org.broad.igv.ui.util.MenuAndToolbarUtils;

public class AutosaveMenu
extends JMenu {
    public AutosaveMenu() {
        this("Autosaved Sessions");
    }

    private AutosaveMenu(String name) {
        super(name);
        this.addMenuListener(e -> this.fillAutosaveList());
    }

    private void fillAutosaveList() {
        Optional<File> exitAutosave = SessionAutosaveManager.getExitSessionAutosaveFile();
        File[] timedAutosaves = SessionAutosaveManager.getTimedSessionAutosaveFiles();
        Arrays.sort(timedAutosaves, Collections.reverseOrder());
        this.removeAll();
        if (exitAutosave.isPresent()) {
            this.add(MenuAndToolbarUtils.createMenuItem(new OpenSessionMenuAction(exitAutosave.get().getAbsolutePath(), IGV.getInstance())));
            if (timedAutosaves.length > 0) {
                this.addSeparator();
            }
        }
        for (File timedAutosave : timedAutosaves) {
            this.add(MenuAndToolbarUtils.createMenuItem(new OpenSessionMenuAction(timedAutosave.getAbsolutePath(), IGV.getInstance())));
        }
    }
}

