/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.bedpe.BedPE;
import org.broad.igv.bedpe.BedPEFeature;
import org.broad.igv.bedpe.BedPERenderer;
import org.broad.igv.bedpe.BedPEShape;
import org.broad.igv.bedpe.InteractionTrack;
import org.broad.igv.track.RenderContext;

public class ProportionalArcRenderer
implements BedPERenderer {
    public static final float PROP_ALPHA = 0.02f;
    private Map<Color, Color> alphaColors = new HashMap<Color, Color>();
    InteractionTrack track;

    public ProportionalArcRenderer(InteractionTrack track) {
        this.track = track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(List<BedPE> features, RenderContext context, Rectangle trackRectangle, InteractionTrack.ArcOption arcOption) {
        Graphics2D g = null;
        try {
            g = (Graphics2D)context.getGraphics().create();
            double origin = context.getOrigin();
            double locScale = context.getScale();
            Color trackColor = this.track.getColor();
            if (this.track.thickness > 1) {
                g.setStroke(new BasicStroke(this.track.thickness));
            }
            for (BedPE bedPE : features) {
                double p1 = ((double)bedPE.getStart() - origin) / locScale;
                double p2 = ((double)bedPE.getEnd() - origin) / locScale;
                if (p2 >= trackRectangle.getX() && p1 <= trackRectangle.getMaxX()) {
                    InteractionTrack.Direction direction = this.track.direction;
                    int gap = this.track.gap;
                    int h = trackRectangle.height - gap;
                    if (this.track.maxScore > 0.0 && bedPE.getScore() > 0.0) {
                        double logMax = Math.log10(this.track.maxScore + 1.0);
                        h = (int)(Math.log10(bedPE.getScore() + 1.0) / logMax * (double)h);
                    }
                    if (bedPE.isSameChr()) {
                        Color fcolor;
                        BedPEFeature feature = bedPE.get();
                        Color color = fcolor = feature.color == null ? trackColor : feature.color;
                        if (fcolor != null) {
                            g.setColor(fcolor);
                        }
                        double pixelStart = (feature.getMidStart() - origin) / locScale;
                        double pixelEnd = (feature.getMidEnd() - origin) / locScale;
                        if (arcOption != InteractionTrack.ArcOption.ONE_END ? arcOption == InteractionTrack.ArcOption.BOTH_ENDS && (pixelStart < (double)trackRectangle.x || pixelEnd > (double)(trackRectangle.x + trackRectangle.width)) : pixelStart < (double)trackRectangle.x && pixelEnd > (double)(trackRectangle.x + trackRectangle.width)) continue;
                        int w = (int)(pixelEnd - pixelStart);
                        if (w < 3) {
                            w = 3;
                            pixelStart -= 1.0;
                        }
                        double y = direction == InteractionTrack.Direction.UP ? (double)(gap + trackRectangle.y + trackRectangle.height - h) : (double)(gap + trackRectangle.y - h);
                        int angleSt = direction == InteractionTrack.Direction.UP ? 0 : 180;
                        Arc2D.Double arcPath = new Arc2D.Double(pixelStart, y, w, 2 * h, angleSt, 180.0, 0);
                        g.draw(arcPath);
                        Color shadedColor = this.getAlphaColor(fcolor, 0.02f);
                        g.setColor(shadedColor);
                        g.fill(arcPath);
                        bedPE.setShape(new PAShape(pixelStart + (double)(w / 2), y + (double)h, w / 2, h));
                        continue;
                    }
                    Color fcolor = bedPE.get().color == null ? Color.black : bedPE.get().color;
                    g.setColor(fcolor);
                    double ps = ((double)((bedPE.getStart() + bedPE.getEnd()) / 2) - origin) / locScale;
                    int yBase = direction == InteractionTrack.Direction.UP ? trackRectangle.y + trackRectangle.height - h : trackRectangle.y + gap;
                    g.drawLine((int)ps, yBase, (int)ps, yBase + h);
                    continue;
                }
                bedPE.setShape(null);
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
    }

    private Color getAlphaColor(Color fcolor, float alpha) {
        Color ac = this.alphaColors.get(fcolor);
        if (ac == null) {
            float[] rgb = new float[3];
            rgb = fcolor.getRGBColorComponents(rgb);
            ac = new Color(rgb[0], rgb[1], rgb[2], alpha);
            this.alphaColors.put(fcolor, ac);
        }
        return ac;
    }

    public static class PAShape
    implements BedPEShape {
        double h;
        double k;
        double a2;
        double b2;

        public PAShape(double h, double k, double a, double b) {
            this.h = h;
            this.k = k;
            this.a2 = a * a;
            this.b2 = b * b;
        }

        @Override
        public boolean contains(double x, double y) {
            double dx = x - this.h;
            double dy = y - this.k;
            double e = dx * dx / this.a2 + dy * dy / this.b2;
            return e < 1.0;
        }
    }
}

