/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.sam.samV1_0;

import htsjdk.beta.codecs.reads.ReadsCodecUtils;
import htsjdk.beta.codecs.reads.sam.SAMDecoder;
import htsjdk.beta.codecs.reads.sam.samV1_0.SAMCodecV1_0;
import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.reads.ReadsDecoderOptions;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import java.io.IOException;
import java.util.Optional;

public class SAMDecoderV1_0
extends SAMDecoder {
    private final SamReader samReader;
    private final SAMFileHeader samFileHeader;

    public SAMDecoderV1_0(Bundle inputBundle, ReadsDecoderOptions readsDecoderOptions) {
        super(inputBundle, readsDecoderOptions);
        this.samReader = ReadsCodecUtils.getSamReader(inputBundle, readsDecoderOptions, SamReaderFactory.makeDefault());
        this.samFileHeader = this.samReader.getFileHeader();
    }

    @Override
    public HtsVersion getVersion() {
        return SAMCodecV1_0.VERSION_1;
    }

    @Override
    public SAMFileHeader getHeader() {
        return this.samFileHeader;
    }

    @Override
    public CloseableIterator<SAMRecord> iterator() {
        return this.samReader.iterator();
    }

    @Override
    public boolean isQueryable() {
        return false;
    }

    @Override
    public boolean hasIndex() {
        return false;
    }

    @Override
    public void close() {
        try {
            this.samReader.close();
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Exception closing reader for %s", this.getInputBundle()), e);
        }
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        throw new IllegalArgumentException(String.format("This decoder is not queryable: %s", this.getDisplayName()));
    }

    @Override
    public Optional<SAMRecord> queryMate(SAMRecord rec) {
        throw new IllegalArgumentException(String.format("This decoder is not queryable: %s", this.getDisplayName()));
    }
}

