/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.table;

import com.jidesoft.swing.JideBoxLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.NumberFormatter;
import org.broad.igv.Globals;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGVDialog;
import org.broad.igv.ui.table.SearchableTableModel;
import org.broad.igv.ui.table.SearchableTableRecord;

public class SearchableTableDialog
extends IGVDialog {
    private static Logger log = LogManager.getLogger(SearchableTableDialog.class);
    private static NumberFormatter numberFormatter = new NumberFormatter();
    private JTable table;
    private JTextField filterTextField;
    private JLabel rowCountLabel;
    private SearchableTableModel model;
    private boolean canceled;

    public SearchableTableDialog(Frame owner, SearchableTableModel model) {
        super(owner);
        this.model = model;
        this.setModal(true);
        this.initComponents();
        this.init(model);
    }

    private void init(SearchableTableModel model) {
        this.setModal(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.setAutoCreateRowSorter(true);
        this.table.setModel(model);
        this.table.setRowSorter(model.getSorter());
        try {
            this.rowCountLabel.setText(numberFormatter.valueToString(this.table.getRowCount()) + " rows");
        }
        catch (ParseException e) {
            this.rowCountLabel.setText(this.table.getRowCount() + " rows");
        }
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchableTableDialog.this.updateFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchableTableDialog.this.updateFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchableTableDialog.this.updateFilter();
            }
        });
    }

    private void updateFilter() {
        RegexFilter rf = null;
        try {
            rf = new RegexFilter(this.filterTextField.getText());
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.model.getSorter().setRowFilter(rf);
        try {
            this.rowCountLabel.setText(numberFormatter.valueToString(this.table.getRowCount()) + " rows");
        }
        catch (ParseException e) {
            log.error(e);
        }
    }

    private void loadButtonActionPerformed(ActionEvent e) {
        this.canceled = false;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.canceled = true;
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public SearchableTableRecord getSelectedRecord() {
        int idx = this.table.getSelectedRow();
        if (idx < 0) {
            return null;
        }
        int modelIndex = this.table.convertRowIndexToModel(idx);
        return this.model.getRecords().get(modelIndex);
    }

    public List<SearchableTableRecord> getSelectedRecords() {
        return Arrays.stream(this.table.getSelectedRows()).mapToObj(this.table::convertRowIndexToModel).map(this.model.getRecords()::get).collect(Collectors.toList());
    }

    private void initComponents() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(0, 10));
        this.table = new JTable();
        this.filterTextField = new JTextField();
        this.rowCountLabel = new JLabel();
        this.rowCountLabel.setHorizontalAlignment(4);
        Font headerFont = this.table.getTableHeader().getFont();
        Font boldHeaderFont = headerFont.deriveFont(1);
        this.table.getTableHeader().setFont(boldHeaderFont);
        JPanel dialogPane = new JPanel();
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        dialogPane.setLayout(new BorderLayout());
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setViewportView(this.table);
        contentPanel.add((Component)scrollPane1, "Center");
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout((LayoutManager)new JideBoxLayout((Container)filterPanel, 0, 5));
        filterPanel.add((Component)this.filterTextField, "vary");
        JLabel filterLabel = new JLabel();
        filterLabel.setText("Filter:");
        filterPanel.add((Component)filterLabel, "fix");
        String filterToolTip = "Enter multiple filter strings separated by spaces.";
        filterLabel.setToolTipText("Enter multiple filter strings separated by spaces.");
        this.filterTextField.setToolTipText("Enter multiple filter strings separated by spaces.");
        JPanel sillyPanel = new JPanel();
        sillyPanel.setLayout((LayoutManager)new JideBoxLayout((Container)sillyPanel, 0, 0));
        sillyPanel.setPreferredSize(new Dimension(100, 28));
        sillyPanel.add((Component)this.rowCountLabel, "vary");
        filterPanel.add((Component)sillyPanel, "fix");
        contentPanel.add((Component)filterPanel, "North");
        dialogPane.add((Component)contentPanel, "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        JButton okButton = new JButton();
        this.getRootPane().setDefaultButton(okButton);
        okButton.setText("Load");
        okButton.addActionListener(e -> this.loadButtonActionPerformed(e));
        buttonBar.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(e -> this.cancelButtonActionPerformed(e));
        buttonBar.add((Component)cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
        this.setSize(1000, 620);
        this.setLocationRelativeTo(this.getOwner());
    }

    private class RegexFilter
    extends RowFilter {
        List<Matcher> matchers;

        RegexFilter(String text) {
            if (text == null) {
                throw new IllegalArgumentException("Pattern must be non-null");
            }
            this.matchers = Arrays.stream(Globals.whitespacePattern.split(text)).map(t -> {
                String value = t.trim();
                return Pattern.compile("(?i)" + value).matcher("");
            }).collect(Collectors.toList());
        }

        public boolean include(RowFilter.Entry value) {
            return this.matchers.stream().allMatch(entry -> {
                Matcher matcher = entry;
                return IntStream.range(0, SearchableTableDialog.this.table.getColumnCount()).anyMatch(index -> {
                    matcher.reset(SearchableTableDialog.this.table.getColumnName(index).toLowerCase());
                    if (matcher.find()) {
                        return true;
                    }
                    return matcher.reset(value.getStringValue(index)).find();
                });
            });
        }
    }
}

