/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.util.LongRunningTask;

public class OpenSessionMenuAction
extends MenuAction {
    private static Logger log = LogManager.getLogger(OpenSessionMenuAction.class);
    private IGV igv;
    private String sessionFile = null;
    private boolean autoload = false;

    public OpenSessionMenuAction(String sessionFile, IGV igv) {
        super(sessionFile);
        this.sessionFile = sessionFile;
        this.igv = igv;
        this.autoload = true;
    }

    public OpenSessionMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.sessionFile == null || !this.autoload) {
            this.sessionFile = OpenSessionMenuAction.pickSessionFile();
        }
        if (this.sessionFile != null) {
            LongRunningTask.submit(() -> this.igv.loadSession(this.sessionFile, null));
        }
    }

    private static String pickSessionFile() {
        String result;
        File lastSessionDirectory = PreferencesManager.getPreferences().getLastTrackDirectory();
        File tmpFile = FileDialogUtils.chooseFile("Open Session", lastSessionDirectory, 0);
        if (tmpFile == null) {
            result = null;
        } else {
            result = tmpFile.getAbsolutePath();
            PreferencesManager.getPreferences().setLastTrackDirectory(tmpFile.getParentFile());
        }
        return result;
    }
}

