/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingWorker;
import org.broad.igv.encode.EncodeFileRecord;
import org.broad.igv.encode.EncodeTrackChooser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class BrowseEncodeAction
extends MenuAction {
    private static Logger log = LogManager.getLogger(BrowseEncodeAction.class);
    private static Map<String, Color> colors = new HashMap<String, Color>();
    static Set<String> sampleInfoAttributes;
    private final Type type;
    IGV igv;

    public BrowseEncodeAction(String label, int mnemonic, Type type, IGV igv) {
        super(label, null, mnemonic);
        this.type = type;
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        final Genome genome = GenomeManager.getInstance().getCurrentGenome();
        final WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        SwingWorker<EncodeTrackChooser, Void> worker = new SwingWorker<EncodeTrackChooser, Void>(){

            @Override
            protected EncodeTrackChooser doInBackground() throws Exception {
                return EncodeTrackChooser.getInstance(genome.getId(), BrowseEncodeAction.this.type);
            }

            @Override
            protected void done() {
                WaitCursorManager.removeWaitCursor(token);
                try {
                    EncodeTrackChooser chooser = (EncodeTrackChooser)this.get();
                    if (chooser == null) {
                        MessageUtils.showMessage("Encode data is not available for " + genome.getDisplayName() + " through IGV.");
                        return;
                    }
                    chooser.setVisible(true);
                    if (chooser.isCanceled()) {
                        return;
                    }
                    List<EncodeFileRecord> records = chooser.getSelectedRecords();
                    if (records.size() > 0) {
                        ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>(records.size());
                        for (EncodeFileRecord record : records) {
                            String antibody;
                            ResourceLocator rl = new ResourceLocator(record.getPath());
                            rl.setName(record.getTrackName());
                            Map<String, String> attributes = record.getAttributes();
                            String string = antibody = attributes.containsKey("antibody") ? attributes.get("antibody") : attributes.get("Target");
                            if (antibody != null) {
                                rl.setColor(colors.get(antibody.toUpperCase()));
                            }
                            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                                String value = entry.getValue();
                                if (value == null || value.length() <= 0 || !sampleInfoAttributes.contains(entry.getKey())) continue;
                                AttributeManager.getInstance().addAttribute(rl.getName(), entry.getKey(), value);
                            }
                            rl.setMetadata(attributes);
                            locators.add(rl);
                        }
                        BrowseEncodeAction.this.igv.loadTracks(locators);
                    }
                }
                catch (Exception e) {
                    log.error("Error opening Encode browser", e);
                    throw new RuntimeException(e);
                }
            }
        };
        worker.execute();
    }

    static {
        colors.put("H3K27AC", new Color(200, 0, 0));
        colors.put("H3K27ME3", new Color(200, 0, 0));
        colors.put("H3K36ME3", new Color(0, 0, 150));
        colors.put("H3K4ME1", new Color(0, 150, 0));
        colors.put("H3K4ME2", new Color(0, 150, 0));
        colors.put("H3K4ME3", new Color(0, 150, 0));
        colors.put("H3K9AC", new Color(100, 0, 0));
        colors.put("H3K9ME1", new Color(100, 0, 0));
        sampleInfoAttributes = new HashSet<String>(Arrays.asList("dataType", "cell", "antibody", "lab", "Biosample", "AssayType", "Target"));
    }

    public static enum Type {
        UCSC,
        SIGNALS_CHIP,
        SIGNALS_OTHER,
        OTHER;

    }
}

