/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.ucsc.Hub;
import org.broad.igv.ucsc.TrackConfigGroup;
import org.broad.igv.ui.util.HyperlinkFactory;

public class HubTrackSelectionDialog
extends JDialog {
    private static final Dimension TRACK_SPACER = new Dimension(10, 5);
    private Map<JCheckBox, TrackConfig> configMap;

    public HubTrackSelectionDialog(List<TrackConfigGroup> groupedTrackConfigurations, Frame owner) {
        super(owner);
        this.setModal(true);
        this.init(groupedTrackConfigurations);
        this.setLocationRelativeTo(owner);
    }

    void init(List<TrackConfigGroup> trackConfigurations) {
        this.configMap = new HashMap<JCheckBox, TrackConfig>();
        this.setTitle("Select tracks to load");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(mainPanel);
        this.add((Component)scrollPane, "Center");
        JPanel categoryContainer = new JPanel();
        categoryContainer.setLayout(new BoxLayout(categoryContainer, 3));
        mainPanel.add(categoryContainer);
        JPanel checkAllPanel = new JPanel();
        ((FlowLayout)checkAllPanel.getLayout()).setAlignment(0);
        JButton selectAllButton = new JButton("Select All");
        selectAllButton.setFocusPainted(false);
        selectAllButton.addActionListener(e -> this.configMap.keySet().forEach(cb -> cb.setSelected(true)));
        checkAllPanel.add(selectAllButton);
        JButton selectNoneButton = new JButton("Select None");
        selectNoneButton.addActionListener(e -> this.configMap.keySet().forEach(cb -> cb.setSelected(false)));
        checkAllPanel.add(selectNoneButton);
        categoryContainer.add(checkAllPanel);
        ArrayList<JPanel> cpl = new ArrayList<JPanel>();
        for (TrackConfigGroup configGroup : trackConfigurations) {
            categoryContainer.add(Box.createVerticalStrut(10));
            JPanel categoryPanel = this.categoryPanel(configGroup);
            categoryContainer.add(categoryPanel);
            cpl.add(categoryPanel);
        }
        JPanel buttonPanel = new JPanel();
        ((FlowLayout)buttonPanel.getLayout()).setAlignment(2);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> this.setVisible(false));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> this.okAction());
        if (Globals.IS_MAC) {
            buttonPanel.add(cancelButton);
            buttonPanel.add(okButton);
        } else {
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
        }
        this.getRootPane().setDefaultButton(okButton);
        mainPanel.add((Component)buttonPanel, "South");
        int h = 75;
        for (JPanel p : cpl) {
            h += p.getMinimumSize().height;
        }
        this.setSize(new Dimension(800, Math.min(800, h)));
        this.pack();
        this.revalidate();
    }

    private void okAction() {
        for (Map.Entry<JCheckBox, TrackConfig> entry : this.configMap.entrySet()) {
            TrackConfig trackConfig = entry.getValue();
            if (entry.getKey().isSelected()) {
                trackConfig.setVisible(true);
                continue;
            }
            trackConfig.setVisible(false);
        }
        this.setVisible(false);
    }

    private JPanel categoryPanel(TrackConfigGroup configGroup) {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        Border border = BorderFactory.createLineBorder(Color.lightGray);
        container.setBorder(BorderFactory.createTitledBorder(border, configGroup.label));
        JPanel trackContainer = new JPanel();
        WrapLayout wrapLayout = new WrapLayout();
        wrapLayout.setAlignment(0);
        trackContainer.setLayout(wrapLayout);
        container.add(trackContainer);
        for (TrackConfig trackConfig : configGroup.tracks) {
            JPanel p = new JPanel();
            JCheckBox checkBox = new JCheckBox();
            this.configMap.put(checkBox, trackConfig);
            checkBox.setSelected(trackConfig.getVisible());
            JLabel label = trackConfig.getHtml() == null ? new JLabel(trackConfig.getName()) : HyperlinkFactory.createLink(trackConfig.getName(), trackConfig.getHtml());
            label.setLabelFor(checkBox);
            p.add(checkBox);
            p.add(label);
            p.add(Box.createRigidArea(TRACK_SPACER));
            trackContainer.add(p);
        }
        return container;
    }

    public List<TrackConfig> getSelectedConfigs() {
        List<TrackConfig> selected = this.configMap.values().stream().filter(trackConfig -> trackConfig.getVisible()).collect(Collectors.toList());
        selected.sort((o1, o2) -> o1.getOrder() - o2.getOrder());
        return selected;
    }

    public static void main(String[] args) throws InterruptedException, InvocationTargetException, IOException {
        String hubFile = "test/data/hubs/hub.txt";
        Hub hub = Hub.loadHub(hubFile);
        List<TrackConfigGroup> groupedTrackConfigurations = hub.getGroupedTrackConfigurations();
        HubTrackSelectionDialog dlf = new HubTrackSelectionDialog(groupedTrackConfigurations, null);
        dlf.setVisible(true);
        for (TrackConfig config : dlf.getSelectedConfigs()) {
            System.out.println(config.getName());
        }
    }

    static class WrapLayout
    extends FlowLayout {
        private Dimension preferredLayoutSize;

        public WrapLayout() {
        }

        public WrapLayout(int align) {
            super(align);
        }

        public WrapLayout(int align, int hgap, int vgap) {
            super(align, hgap, vgap);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            return this.layoutSize(target, true);
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            Dimension minimum = this.layoutSize(target, false);
            minimum.width -= this.getHgap() + 1;
            return minimum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container target, boolean preferred) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int targetWidth = target.getSize().width;
                Container container = target;
                while (container.getSize().width == 0 && container.getParent() != null) {
                    container = container.getParent();
                }
                targetWidth = container.getSize().width;
                if (targetWidth == 0) {
                    targetWidth = Integer.MAX_VALUE;
                }
                int hgap = this.getHgap();
                int vgap = this.getVgap();
                Insets insets = target.getInsets();
                int horizontalInsetsAndGap = insets.left + insets.right + hgap * 2;
                int maxWidth = targetWidth - horizontalInsetsAndGap;
                Dimension dim = new Dimension(0, 0);
                int rowWidth = 0;
                int rowHeight = 0;
                int nmembers = target.getComponentCount();
                for (int i = 0; i < nmembers; ++i) {
                    Dimension d;
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension dimension = d = preferred ? m.getPreferredSize() : m.getMinimumSize();
                    if (rowWidth + d.width > maxWidth) {
                        this.addRow(dim, rowWidth, rowHeight);
                        rowWidth = 0;
                        rowHeight = 0;
                    }
                    if (rowWidth != 0) {
                        rowWidth += hgap;
                    }
                    rowWidth += d.width;
                    rowHeight = Math.max(rowHeight, d.height);
                }
                this.addRow(dim, rowWidth, rowHeight);
                dim.width += horizontalInsetsAndGap;
                dim.height += insets.top + insets.bottom + vgap * 2;
                Container scrollPane = SwingUtilities.getAncestorOfClass(JScrollPane.class, target);
                if (scrollPane != null && target.isValid()) {
                    dim.width -= hgap + 1;
                }
                return dim;
            }
        }

        private void addRow(Dimension dim, int rowWidth, int rowHeight) {
            dim.width = Math.max(dim.width, rowWidth);
            if (dim.height > 0) {
                dim.height += this.getVgap();
            }
            dim.height += rowHeight;
        }
    }
}

