/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.broad.igv.data.CombinedDataSource;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.LoadedDataInterval;
import org.broad.igv.track.Track;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataSourceTrack
extends DataTrack {
    private static Logger log = LogManager.getLogger(DataSourceTrack.class);
    public DataSource dataSource;

    public DataSourceTrack(ResourceLocator locator, String id, String name, DataSource dataSource) {
        super(locator, id, name);
        if (dataSource == null && locator != null) {
            log.warn("Null data source for track: " + locator.getTrackName() + "  " + locator.getPath());
        }
        if (dataSource != null) {
            this.setDatasource(dataSource);
        }
    }

    public void setDatasource(DataSource dataSource) {
        this.dataSource = dataSource;
        if (this.dataSource != null) {
            this.setTrackType(dataSource.getTrackType());
        }
    }

    public DataSourceTrack() {
    }

    void initScale(DataSource dataSource, List<LocusScore> scores) {
        float min = (float)dataSource.getDataMin();
        float max = (float)dataSource.getDataMax();
        float baseline = 0.0f;
        if (min > 0.0f) {
            min = 0.0f;
        }
        for (LocusScore score : scores) {
            max = Math.max(max, score.getScore());
        }
        this.setDataRange(new DataRange(min, baseline, max));
    }

    @Override
    public LoadedDataInterval<List<LocusScore>> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        List<LocusScore> tmp;
        List<LocusScore> list = tmp = this.dataSource == null ? Collections.EMPTY_LIST : this.dataSource.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
        if (tmp == null) {
            tmp = Collections.EMPTY_LIST;
        }
        if (this.dataRange == null && !this.autoScale) {
            this.initScale(this.dataSource, tmp);
        }
        return new LoadedDataInterval<List<LocusScore>>(chr, startLocation, endLocation, zoom, tmp);
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
        this.clearCaches();
        if (this.dataSource != null) {
            this.dataSource.setWindowFunction(statType);
        }
    }

    @Override
    public boolean isLogNormalized() {
        return this.dataSource != null ? this.dataSource.isLogNormalized() : false;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.dataSource != null ? this.dataSource.getWindowFunction() : null;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.dataSource != null ? this.dataSource.getAvailableWindowFunctions() : null;
    }

    public void updateTrackReferences(List<Track> allTracks) {
        if (this.dataSource != null && this.dataSource instanceof CombinedDataSource) {
            ((CombinedDataSource)this.dataSource).updateTrackReferences(allTracks);
        }
    }

    @Override
    public void marshalXML(Document document, Element element) {
        boolean normalize;
        super.marshalXML(document, element);
        if (this.dataSource != null && this.dataSource instanceof CoverageDataSource && (normalize = ((CoverageDataSource)this.dataSource).getNormalize())) {
            element.setAttribute("normalize", "true");
        }
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        if (this.dataSource != null && this.dataSource instanceof CoverageDataSource && element.hasAttribute("normalize")) {
            ((CoverageDataSource)this.dataSource).setNormalize(Boolean.parseBoolean(element.getAttribute("normalize")));
        }
    }
}

