/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.converters;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.broad.igv.util.ParsingUtils;

public class MFastaToSAM {
    public static final int READ_PAIRED_FLAG = 1;
    public static final int PROPER_PAIR_FLAG = 2;
    public static final int READ_UNMAPPED_FLAG = 4;
    public static final int MATE_UNMAPPED_FLAG = 8;
    public static final int READ_STRAND_FLAG = 16;
    public static final int MATE_STRAND_FLAG = 32;
    public static final int FIRST_OF_PAIR_FLAG = 64;
    public static final int SECOND_OF_PAIR_FLAG = 128;
    public static final int NOT_PRIMARY_ALIGNMENT_FLAG = 256;
    public static final int READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
    public static final int DUPLICATE_READ_FLAG = 1024;
    public static final int SUPPLEMENTARY_FLAG = 2048;

    public static void main(String[] args) throws IOException {
        String inputPath = args[5];
        String outputPath = args[6];
        MFastaToSAM.convert(inputPath, outputPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String path, String outputPath) throws IOException {
        File outputFile = new File(outputPath);
        BufferedReader reader = null;
        PrintWriter out = null;
        try {
            String line;
            reader = ParsingUtils.openBufferedReader(path);
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            String chr = "MSA_SARS2_20200329_consensus";
            int chrLen = 30005;
            out.println("@HD\tVN:1.5");
            out.println("@SQ\tSN:" + chr + "\tLN:" + chrLen);
            out.println("@PG\tPN:MFastaToSAM\tID:MFastaToSAM");
            String readname = null;
            Object seq = null;
            Object cigarString = null;
            int m = 0;
            int d = 0;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(">")) {
                    if (readname != null) {
                        MFastaToSAM.outputSamRecord(readname, chr, cigarString, seq, out);
                    }
                    readname = line.substring(1);
                    cigarString = "";
                    seq = "";
                    m = 0;
                    d = 0;
                    continue;
                }
                char[] chars = line.toCharArray();
                boolean lastCharDash = chars[0] == '-';
                for (int i = 0; i < chars.length; ++i) {
                    char c = chars[i];
                    if (c == '-') {
                        if (!lastCharDash) {
                            cigarString = (String)cigarString + String.valueOf(m) + "M";
                            m = 0;
                        }
                        ++d;
                        lastCharDash = true;
                        continue;
                    }
                    if (lastCharDash) {
                        cigarString = (String)cigarString + String.valueOf(d) + "D";
                        d = 0;
                    }
                    ++m;
                    seq = (String)seq + c;
                    lastCharDash = false;
                }
            }
            out.flush();
        }
        finally {
            out.close();
            reader.close();
        }
    }

    private static void outputSamRecord(String readName, String chr, String cigarString, String seq, PrintWriter out) {
        out.print(readName + "\t0\t" + chr + "\t1\t32\t" + cigarString + "\t*\t0\t0\t" + seq + "\t*");
        out.println();
    }
}

