/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import htsjdk.samtools.util.SequenceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.mods.BaseModificationSet;

public class BaseModificationUtils {
    private static Logger log = LogManager.getLogger(BaseModificationUtils.class);
    static Map<String, String> codeValues = new HashMap<String, String>();
    private static int MM_WARNING_COUNT;

    public static String modificationName(String modification) {
        return codeValues.containsKey(modification) ? codeValues.get(modification) : modification;
    }

    public static List<BaseModificationSet> getBaseModificationSets(String mm, byte[] ml, byte[] sequence, boolean isNegativeStrand) {
        if (isNegativeStrand) {
            sequence = AlignmentUtils.reverseComplementCopy(sequence);
        }
        ArrayList<BaseModificationSet> modificationSets = new ArrayList<BaseModificationSet>();
        String[] mmTokens = mm.split(";");
        int mlIdx = 0;
        for (String mmi : mmTokens) {
            String[] modifications;
            String modificationString;
            String[] tokens = mmi.split(",");
            char base = tokens[0].charAt(0);
            char strand = tokens[0].charAt(1);
            boolean skippedBasesCalled = tokens[0].endsWith(".") ? true : (tokens[0].endsWith("?") ? false : PreferencesManager.getPreferences().getAsBoolean("BASEMOD.SKIPPED_BASES"));
            if (tokens.length == 1) continue;
            String string = modificationString = tokens[0].endsWith(".") || tokens[0].endsWith("?") ? tokens[0].substring(2, tokens[0].length() - 1) : tokens[0].substring(2);
            if (modificationString.length() > 1) {
                if (BaseModificationUtils.isChEBI(modificationString)) {
                    modifications = new String[]{modificationString};
                } else {
                    modifications = new String[modificationString.length()];
                    for (int i = 0; i < modificationString.length(); ++i) {
                        modifications[i] = modificationString.substring(i, i + 1);
                    }
                }
            } else {
                modifications = new String[]{modificationString};
            }
            HashMap likelihoodMap = new HashMap();
            for (String m : modifications) {
                likelihoodMap.put(m, new HashMap());
            }
            int idx = 1;
            int skip = Integer.parseInt(tokens[idx++]);
            int matchCount = 0;
            for (int p = 0; p < sequence.length; ++p) {
                byte likelihood;
                String modification;
                int n;
                int n2;
                String[] stringArray;
                int position;
                if (base != 'N' && sequence[p] != base) continue;
                int n3 = position = isNegativeStrand ? sequence.length - 1 - p : p;
                if (matchCount == skip) {
                    stringArray = modifications;
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        modification = stringArray[n];
                        likelihood = ml == null ? (byte)-1 : ml[mlIdx++];
                        ((Map)likelihoodMap.get(modification)).put(position, likelihood);
                    }
                    if (idx < tokens.length) {
                        skip = Integer.parseInt(tokens[idx++]);
                        matchCount = 0;
                        continue;
                    }
                    if (!skippedBasesCalled) break;
                    skip = -1;
                    continue;
                }
                if (skippedBasesCalled) {
                    stringArray = modifications;
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        modification = stringArray[n];
                        likelihood = 0;
                        ((Map)likelihoodMap.get(modification)).put(position, likelihood);
                    }
                }
                ++matchCount;
            }
            for (String m : modifications) {
                modificationSets.add(new BaseModificationSet(base, strand, m, (Map)likelihoodMap.get(m)));
            }
        }
        return modificationSets;
    }

    public static boolean isChEBI(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean validateMMTag(String readName, String mm, byte[] sequence, boolean isNegativeStrand) {
        if (PreferencesManager.getPreferences().getAsBoolean("BASEMOD.VALIDATE_BASE_COUNT")) {
            String[] mmTokens;
            for (String mmi : mmTokens = mm.split(";")) {
                int i;
                int baseCount;
                String[] tokens = mmi.split(",");
                if (tokens[0].charAt(0) == 'N') {
                    baseCount = sequence.length;
                } else {
                    byte base = (byte)tokens[0].charAt(0);
                    byte readBase = isNegativeStrand ? SequenceUtil.complement((byte)base) : base;
                    baseCount = 0;
                    for (i = 0; i < sequence.length; ++i) {
                        if (readBase != sequence[i]) continue;
                        ++baseCount;
                    }
                }
                int modified = tokens.length - 1;
                int skipped = 0;
                for (i = 1; i < tokens.length; ++i) {
                    skipped += Integer.parseInt(tokens[i]);
                }
                if (modified + skipped <= baseCount) continue;
                if (++MM_WARNING_COUNT < 21) {
                    log.warn(readName + "  MM base count validation failed: expected " + (modified + skipped) + "'" + tokens[0].charAt(0) + "'s, actual count = " + baseCount);
                    if (MM_WARNING_COUNT == 20) {
                        log.warn("MM validation warning count exceeded.  Further failures will not be logged.");
                    }
                }
                return false;
            }
        }
        return true;
    }

    static {
        codeValues.put("m", "5mC");
        codeValues.put("h", "5hmC");
        codeValues.put("f", "5fC");
        codeValues.put("c", "5caC");
        codeValues.put("g", "5hmU");
        codeValues.put("e", "5fU");
        codeValues.put("b", "5caU");
        codeValues.put("a", "6mA");
        codeValues.put("o", "8xoG");
        codeValues.put("n", "Xao");
        codeValues.put("C", "Unknown C");
        codeValues.put("T", "Unknown T");
        codeValues.put("A", "Unknown A");
        codeValues.put("G", "Unknown G");
        codeValues.put("N", "Unknown");
        codeValues.put("NONE_C", "Unmodified C");
        codeValues.put("NONE_T", "Unmodified T");
        codeValues.put("NONE_G", "Unmodified G");
        codeValues.put("NONE_A", "Unmodified A");
        MM_WARNING_COUNT = 0;
    }
}

