/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BaseModficationFilter {
    String modification;
    char base = '\u0000';
    public static Map<String, String> modToBaseMap = Stream.of({"m", "C"}, {"h", "C"}, {"f", "C"}, {"c", "C"}, {"C", "C"}, {"g", "T"}, {"e", "T"}, {"b", "T"}, {"T", "T"}, {"a", "A"}, {"A", "A"}, {"o", "G"}, {"G", "G"}, {"n", "N"}, {"N", "N"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));

    public BaseModficationFilter(String modification, char base) {
        this.modification = modification;
        this.base = base;
    }

    public BaseModficationFilter(String modification) {
        this.modification = modification;
        this.base = '\u0000';
    }

    public boolean pass(String mod) {
        if (mod.startsWith("NONE_")) {
            char b = mod.charAt(5);
            return this.base > '\u0000' && this.base == b || modToBaseMap.containsKey(this.modification.substring(0, 1)) && modToBaseMap.get(this.modification.substring(0, 1)).charAt(0) == b;
        }
        return this.modification == null || this.modification.contains(mod);
    }

    public boolean pass(String mod, char b) {
        if (this.base != '\u0000' && this.base == b) {
            return true;
        }
        return this.pass(mod);
    }

    public String toString() {
        return (this.modification == null ? "" : this.modification) + "," + String.valueOf(this.base == '\u0000' ? "" : Character.valueOf(this.base));
    }

    public static BaseModficationFilter fromString(String str) {
        char base;
        String mod;
        int idx = str.indexOf(",");
        if (idx < 0) {
            mod = str;
            base = '\u0000';
        } else if (idx == 0) {
            mod = null;
            base = str.charAt(1);
        } else {
            mod = str.substring(0, idx);
            base = idx == str.length() - 1 ? (char)'\u0000' : str.charAt(idx + 1);
        }
        return new BaseModficationFilter(mod, base);
    }
}

