/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.samtools.SAMTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.sam.SortOption;
import org.broad.igv.sam.SupplementaryAlignment;

public class SupplementaryGroup {
    private final List<SupplementaryAlignment> readOrder;
    private final List<SupplementaryAlignment> positionOrder;
    private final Adapter primaryRead;
    private final Alignment original;

    public SupplementaryGroup(Alignment alignment) {
        Object rawSATag;
        ArrayList<SupplementaryAlignment> supplementaryAlignments = alignment instanceof SAMAlignment ? ((SAMAlignment)alignment).getSupplementaryAlignments() : ((rawSATag = alignment.getAttribute(SAMTag.SA.name())) == null ? null : new ArrayList<SupplementaryAlignment>(SupplementaryAlignment.parseFromSATag(rawSATag.toString())));
        this.primaryRead = new Adapter(alignment);
        this.original = alignment;
        ArrayList<SupplementaryAlignment> combined = supplementaryAlignments == null || supplementaryAlignments.isEmpty() ? new ArrayList<SupplementaryAlignment>() : new ArrayList<SupplementaryAlignment>(supplementaryAlignments);
        combined.add(this.primaryRead);
        this.readOrder = new ArrayList<SupplementaryAlignment>(combined);
        this.readOrder.sort(SupplementaryAlignment.LEADING_CLIP_COMPARATOR);
        this.positionOrder = new ArrayList<SupplementaryAlignment>(combined);
        this.positionOrder.sort(SortOption.POSITION_COMPARATOR);
    }

    public int getBaseCount() {
        return this.streamInPositionOrder().mapToInt(SupplementaryAlignment::getNumberOfAlignedBases).sum();
    }

    public String getReadName() {
        return this.original.getReadName();
    }

    public List<String> getContigs() {
        return this.streamInReadOrder().map(SupplementaryAlignment::getContig).filter(Objects::nonNull).sorted(ChromosomeNameComparator.get()).distinct().collect(Collectors.toList());
    }

    public int getLengthOnReference() {
        return this.streamInPositionOrder().mapToInt(SupplementaryAlignment::getLengthOnReference).sum();
    }

    public SupplementaryAlignment getNextInRead(SupplementaryAlignment alignment) {
        int i = this.readOrder.indexOf(alignment);
        return this.readOrder.size() > i + 1 ? this.readOrder.get(i + 1) : null;
    }

    public SupplementaryAlignment getPreviousInRead(SupplementaryAlignment alignment) {
        int i = this.readOrder.indexOf(alignment);
        return i > 0 ? this.readOrder.get(i - 1) : null;
    }

    public SupplementaryAlignment getNextPosition(SupplementaryAlignment alignment) {
        int i = this.positionOrder.indexOf(alignment);
        return this.positionOrder.size() > i + 1 ? this.readOrder.get(i + 1) : null;
    }

    public SupplementaryAlignment getPreviousPosition(SupplementaryAlignment alignment) {
        int i = this.readOrder.indexOf(alignment);
        return i > 0 ? this.readOrder.get(i - 1) : null;
    }

    public SupplementaryAlignment getPrimaryAlignment() {
        return this.primaryRead;
    }

    public Alignment unwrap() {
        return this.original;
    }

    public Iterator<SupplementaryAlignment> iterateInReadOrder() {
        return this.readOrder.iterator();
    }

    public Iterator<SupplementaryAlignment> iterateInPositionOrder() {
        return this.positionOrder.iterator();
    }

    public Stream<SupplementaryAlignment> streamInReadOrder() {
        return this.readOrder.stream();
    }

    public Stream<SupplementaryAlignment> streamInPositionOrder() {
        return this.positionOrder.stream();
    }

    public int size() {
        return this.readOrder.size();
    }

    private static class Adapter
    extends SupplementaryAlignment {
        public Adapter(Alignment a) {
            super(a.getChr(), a.getStart(), a.getReadStrand(), a.getCigar(), a.getMappingQuality(), a.getAttribute(SAMTag.NM.name()) == null ? 0 : (Integer)a.getAttribute(SAMTag.NM.name()));
        }
    }
}

