/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.tribble.readers.AsciiLineReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.Globals;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.BisulfiteCounts;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.mods.BaseModificationCounts;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public abstract class BaseAlignmentCounts
implements AlignmentCounts {
    private static Logger log = LogManager.getLogger(BaseAlignmentCounts.class);
    public static final char[] nucleotides = new char[]{'a', 'c', 'g', 't', 'n'};
    private static Map<String, Set<Integer>> knownSnps;
    int start;
    int end;
    private int bucketSize = 1;
    protected boolean countDeletedBasesCovered = false;
    private BisulfiteCounts bisulfiteCounts;
    private BaseModificationCounts baseModificationCounts;

    public BaseAlignmentCounts(int start, int end, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        IGVPreferences prefs = PreferencesManager.getPreferences();
        String snpsFile = prefs.get("KNOWN_SNPS_FILE", null);
        if (snpsFile != null && knownSnps == null) {
            BaseAlignmentCounts.loadKnownSnps(snpsFile);
        }
        this.start = start;
        this.end = end;
        this.countDeletedBasesCovered = prefs.getAsBoolean("SAM.COUNT_DELETED_BASES_COVERED");
        if (!Globals.isHeadless() && bisulfiteContext != null) {
            this.bisulfiteCounts = new BisulfiteCounts(bisulfiteContext, GenomeManager.getInstance().getCurrentGenome());
        }
        this.baseModificationCounts = new BaseModificationCounts();
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getChr() {
        return null;
    }

    public String getContig() {
        return null;
    }

    @Override
    public BisulfiteCounts getBisulfiteCounts() {
        return this.bisulfiteCounts;
    }

    @Override
    public BaseModificationCounts getModifiedBaseCounts() {
        return this.baseModificationCounts;
    }

    @Override
    public int getBucketSize() {
        return this.bucketSize;
    }

    @Override
    public boolean hasBaseCounts() {
        return true;
    }

    @Override
    public void incCounts(Alignment alignment) {
        if (this.bisulfiteCounts != null) {
            this.bisulfiteCounts.incrementCounts(alignment);
        }
        if (this.baseModificationCounts != null) {
            this.baseModificationCounts.incrementCounts(alignment);
        }
        int alignmentStart = alignment.getAlignmentStart();
        int alignmentEnd = alignment.getAlignmentEnd();
        Strand strand = alignment.getReadStrand();
        boolean isNegativeStrand = strand == Strand.NEGATIVE;
        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
        if (blocks != null) {
            AlignmentBlock[] insertions;
            List<Gap> gaps;
            int lastBlockEnd = -1;
            for (AlignmentBlock b : blocks) {
                if (b.getEnd() < this.start) continue;
                if (b.getStart() > this.end) break;
                if (b.isSoftClip() || strand == Strand.NONE) continue;
                this.incBlockCounts(b, isNegativeStrand);
            }
            if ((gaps = alignment.getGaps()) != null) {
                for (Gap gap : gaps) {
                    if (gap.getType() != 'D') continue;
                    for (int pos = gap.getStart(); pos < gap.getStart() + gap.getnBases(); ++pos) {
                        this.incrementDeletion(pos, isNegativeStrand);
                    }
                }
            }
            if ((insertions = alignment.getInsertions()) != null) {
                for (AlignmentBlock insBlock : insertions) {
                    if (insBlock.getEnd() < this.start) continue;
                    if (insBlock.getStart() <= this.end) {
                        this.incrementInsertion(insBlock);
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (int pos = alignmentStart; pos < alignmentEnd; ++pos) {
                byte q = 0;
                this.incPositionCount(pos, (byte)110, q, alignment.isNegativeStrand());
            }
        }
    }

    @Override
    public String getValueStringAt(int pos) {
        if (pos < this.getStart() || pos >= this.getEnd()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int totalCount = this.getTotalCount(pos);
        buf.append("Total count: " + totalCount);
        for (char c : nucleotides) {
            int negCount = this.getNegCount(pos, (byte)c);
            int posCount = this.getPosCount(pos, (byte)c);
            int count = negCount + posCount;
            int percent = Math.round((float)count * 100.0f / (float)totalCount);
            char cU = Character.toUpperCase(c);
            buf.append("<br>" + cU + "      : " + count);
            if (count == 0) continue;
            buf.append("  (" + percent + "%,     " + posCount + "+,   " + negCount + "- )");
        }
        int delCount = this.getDelCount(pos);
        int insCount = this.getInsCount(pos);
        if (delCount > 0 || insCount > 0) {
            buf.append("<br>DEL: " + delCount);
            buf.append("<br>INS: " + insCount);
        }
        return buf.toString();
    }

    @Override
    public boolean isConsensusMismatch(int pos, byte ref, String chr, float snpThreshold) {
        Set<Integer> filteredSnps;
        boolean qualityWeight = PreferencesManager.getPreferences().getAsBoolean("SAM.ALLELE_USE_QUALITY");
        Set<Integer> set = filteredSnps = knownSnps == null ? null : knownSnps.get(chr);
        if (filteredSnps == null || !filteredSnps.contains(pos + 1)) {
            float threshold = snpThreshold * (float)(qualityWeight ? this.getTotalQuality(pos) : this.getTotalCount(pos));
            float mismatchQualitySum = 0.0f;
            if (ref > 0) {
                if (ref < 96) {
                    ref = (byte)(ref + 32);
                }
                for (char c : nucleotides) {
                    if (c == ref || c == 'n') continue;
                    mismatchQualitySum += (float)(qualityWeight ? this.getQuality(pos, (byte)c) : this.getCount(pos, (byte)c));
                }
                return mismatchQualitySum >= threshold && threshold > 0.0f;
            }
        }
        return false;
    }

    @Override
    public boolean isConsensusDeletion(int start, int width, float snpThreshold) {
        int end = start + width;
        int count = 0;
        for (int i = start; i < end; ++i) {
            int totalCoverad = this.getTotalCount(i) + this.getDelCount(i);
            if (!((float)this.getDelCount(i) >= snpThreshold * (float)totalCoverad)) continue;
            ++count;
        }
        return (double)count >= 0.5 * (double)width;
    }

    @Override
    public boolean isConsensusInsertion(int pos, float snpThreshold) {
        float threshold = snpThreshold * (float)(this.getTotalCount(pos) + this.getDelCount(pos));
        return (float)this.getInsCount(pos) >= threshold;
    }

    private static void loadKnownSnps(String snpFile) {
        if (knownSnps != null) {
            return;
        }
        knownSnps = new HashMap<String, Set<Integer>>();
        try (AsciiLineReader reader = ParsingUtils.openAsciiReader(new ResourceLocator(snpFile));){
            String nextLine = "";
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                String chr = tokens[0];
                Set snps = knownSnps.computeIfAbsent(chr, k -> new HashSet(10000));
                snps.add(Integer.valueOf(tokens[1]));
            }
        }
        catch (Exception e) {
            knownSnps = null;
            log.error("", e);
            MessageUtils.showMessage("Error loading snps file: " + snpFile + " (" + e.toString() + ")");
        }
    }

    protected abstract void incPositionCount(int var1, byte var2, byte var3, boolean var4);

    protected abstract void incrementInsertion(AlignmentBlock var1);

    protected abstract void incrementDeletion(int var1, boolean var2);

    protected abstract void incBlockCounts(AlignmentBlock var1, boolean var2);
}

