/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broad.igv.event.DataLoadedEvent;
import org.broad.igv.event.IGVEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.event.RefreshEvent;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.genome.ChromAliasManager;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTileLoader;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PackedAlignments;
import org.broad.igv.sam.ReadStats;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.sam.mods.BaseModificationKey;
import org.broad.igv.sam.mods.BaseModificationSet;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.track.Track;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class AlignmentDataManager
implements IGVEventObserver {
    private static Logger log = LogManager.getLogger(AlignmentDataManager.class);
    private final Genome genome;
    private ChromAliasManager chromAliasManager;
    private final AlignmentReader reader;
    private AlignmentTrack alignmentTrack;
    private CoverageTrack coverageTrack;
    private Set<Track> subscribedTracks;
    private List<AlignmentInterval> intervalCache;
    private ResourceLocator locator;
    private Set<String> sequenceNames;
    private AlignmentTileLoader loader;
    private Map<String, PEStats> peStats;
    private Set<BaseModificationKey> allBaseModificationKeys = new HashSet<BaseModificationKey>();
    private Set<String> simplexBaseModfications = new HashSet<String>();
    private Range currentlyLoading;
    private AlignmentTrack.ExperimentType inferredType;
    Map<String, String> chrAliasCache = new HashMap<String, String>();

    public AlignmentDataManager(ResourceLocator locator, Genome genome) throws IOException {
        this.locator = locator;
        this.reader = AlignmentReaderFactory.getReader(locator);
        this.loader = new AlignmentTileLoader(this.reader);
        this.inferType();
        this.peStats = new HashMap<String, PEStats>();
        this.genome = genome;
        this.intervalCache = Collections.synchronizedList(new ArrayList());
        this.subscribedTracks = Collections.synchronizedSet(new HashSet());
        this.sequenceNames = new HashSet<String>(this.getLoader().getSequenceNames());
        this.chromAliasManager = new ChromAliasManager(this.sequenceNames, genome);
        IGVEventBus.getInstance().subscribe(FrameManager.ChangeEvent.class, this);
        IGVEventBus.getInstance().subscribe(RefreshEvent.class, this);
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        if (event instanceof FrameManager.ChangeEvent) {
            this.trimCache();
        } else if (event instanceof RefreshEvent) {
            this.clear();
        } else {
            log.warn("Unknown event type: " + String.valueOf(event.getClass()));
        }
    }

    public void subscribe(Track track) {
        this.subscribedTracks.add(track);
    }

    public void unsubscribe(Track track) {
        this.subscribedTracks.remove(track);
        if (this.subscribedTracks.isEmpty()) {
            this.dispose();
            this.dumpAlignments();
            IGVEventBus.getInstance().unsubscribe(this);
        }
    }

    public AlignmentTileLoader getLoader() {
        return this.loader;
    }

    public ResourceLocator getLocator() {
        return this.locator;
    }

    public Map<String, PEStats> getPEStats() {
        return this.peStats;
    }

    public Set<BaseModificationKey> getAllBaseModificationKeys() {
        return this.allBaseModificationKeys;
    }

    public boolean isPairedEnd() {
        return this.getLoader().isPairedEnd();
    }

    public boolean hasYCTags() {
        return this.getLoader().hasYCTags();
    }

    public boolean hasIndex() {
        return this.getLoader().hasIndex();
    }

    public void setAlignmentTrack(AlignmentTrack alignmentTrack) {
        this.alignmentTrack = alignmentTrack;
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public double getVisibilityWindow() {
        return this.getPreferences().getAsFloat("SAM.MAX_VISIBLE_RANGE") * 1000.0f;
    }

    private IGVPreferences getPreferences() {
        String category = "NULL";
        AlignmentTrack.ExperimentType experimentType = this.getExperimentType();
        if (experimentType == AlignmentTrack.ExperimentType.RNA) {
            category = "RNA";
        } else if (experimentType == AlignmentTrack.ExperimentType.THIRD_GEN) {
            category = "THIRD_GEN";
        }
        return PreferencesManager.getPreferences(category);
    }

    public List<String> getSequenceNames() throws IOException {
        return this.getLoader().getSequenceNames();
    }

    public AlignmentInterval getLoadedInterval(ReferenceFrame frame) {
        return this.getLoadedInterval(frame, false);
    }

    public AlignmentInterval getLoadedInterval(ReferenceFrame frame, boolean includeOverlaps) {
        for (AlignmentInterval interval : this.intervalCache) {
            if (!interval.contains(frame.getCurrentRange())) continue;
            return interval;
        }
        if (includeOverlaps) {
            for (AlignmentInterval interval : this.intervalCache) {
                if (!interval.overlaps(frame.getCurrentRange())) continue;
                return interval;
            }
        }
        return null;
    }

    public void setViewAsPairs(boolean option, AlignmentTrack.RenderOptions renderOptions, Track.DisplayMode displayMode) {
        if (option == renderOptions.isViewPairs()) {
            return;
        }
        renderOptions.setViewPairs(option);
        this.packAlignments(renderOptions, displayMode);
    }

    void packAlignments(AlignmentTrack.RenderOptions renderOptions, Track.DisplayMode displayMode) {
        for (AlignmentInterval interval : this.intervalCache) {
            interval.packAlignments(renderOptions, displayMode);
        }
    }

    public boolean isLoaded(ReferenceFrame frame) {
        return this.getLoadedInterval(frame) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ReferenceFrame frame, AlignmentTrack.RenderOptions renderOptions, Track.DisplayMode displayMode, boolean expandEnds) {
        if (frame.getChrName().equals("All") || frame.getEnd() - frame.getOrigin() > this.getVisibilityWindow()) {
            return;
        }
        if (this.isLoaded(frame)) {
            return;
        }
        Range range = frame.getCurrentRange();
        String chr = frame.getChrName();
        int start = range.getStart();
        int end = range.getEnd();
        int adjustedStart = start;
        int adjustedEnd = end;
        Range adjustedRange = new Range(chr, start, end);
        if (this.currentlyLoading != null && this.currentlyLoading.contains(adjustedRange)) {
            return;
        }
        try {
            this.currentlyLoading = adjustedRange;
            int windowSize = Math.min(4 * (end - start), PreferencesManager.getPreferences().getAsInt("SAM.MAX_VISIBLE_RANGE") * 1000);
            int center = start + (end - start) / 2;
            int expand = Math.min(Integer.MAX_VALUE - center, Math.max(end - start, windowSize / 2));
            if (expandEnds) {
                adjustedStart = Math.max(0, Math.min(start, center - expand));
                adjustedEnd = Math.max(end, center + expand);
                if (adjustedEnd < 0) {
                    adjustedEnd = Integer.MAX_VALUE;
                }
            }
            AlignmentInterval loadedInterval = this.loadInterval(chr, adjustedStart, adjustedEnd, renderOptions, frame);
            this.trimCache();
            this.intervalCache.add(loadedInterval);
            loadedInterval.packAlignments(renderOptions, displayMode);
        }
        finally {
            this.currentlyLoading = null;
        }
        IGVEventBus.getInstance().post(new DataLoadedEvent(frame));
    }

    private void trimCache() {
        ArrayList<AlignmentInterval> trimmedIntervals = new ArrayList<AlignmentInterval>();
        for (AlignmentInterval interval : this.intervalCache) {
            if (!this.intervalInView(interval)) continue;
            trimmedIntervals.add(interval);
        }
        this.intervalCache = trimmedIntervals;
    }

    private boolean intervalInView(AlignmentInterval interval) {
        for (ReferenceFrame frame : FrameManager.getFrames()) {
            if (!interval.contains(frame.getCurrentRange())) continue;
            return true;
        }
        return false;
    }

    AlignmentInterval loadInterval(String chr, int start, int end, AlignmentTrack.RenderOptions renderOptions, ReferenceFrame frame) {
        String seqName;
        if (this.sequenceNames.contains(chr)) {
            seqName = chr;
        } else if (this.chrAliasCache.containsKey(chr)) {
            seqName = this.chrAliasCache.get(chr);
        } else {
            seqName = this.chromAliasManager.getAliasName(chr);
            this.chrAliasCache.put(chr, seqName);
        }
        if (seqName == null) {
            return new AlignmentInterval(chr, start, end);
        }
        DownsampleOptions downsampleOptions = new DownsampleOptions();
        AlignmentTrack.BisulfiteContext bisulfiteContext = renderOptions != null ? renderOptions.bisulfiteContext : null;
        SpliceJunctionHelper spliceJunctionHelper = new SpliceJunctionHelper();
        AlignmentTileLoader.AlignmentTile t = this.getLoader().loadTile(seqName, start, end, spliceJunctionHelper, downsampleOptions, this.peStats, bisulfiteContext, renderOptions);
        List<Alignment> alignments = t.getAlignments();
        List<DownsampledInterval> downsampledIntervals = t.getDownsampledIntervals();
        this.updateBaseModfications(alignments);
        return new AlignmentInterval(chr, start, end, alignments, t.getCounts(), spliceJunctionHelper, downsampledIntervals, frame);
    }

    private void updateBaseModfications(List<Alignment> alignments) {
        for (Alignment a : alignments) {
            List<BaseModificationSet> bmSets = a.getBaseModificationSets();
            if (bmSets == null) continue;
            for (BaseModificationSet bms : bmSets) {
                this.allBaseModificationKeys.add(BaseModificationKey.getKey(bms.getBase(), bms.getStrand(), bms.getModification()));
            }
        }
        Set minusStranMods = this.allBaseModificationKeys.stream().filter(key -> key.getStrand() == '-').map(key -> key.getModification()).collect(Collectors.toSet());
        for (BaseModificationKey key2 : this.allBaseModificationKeys) {
            if (key2.getStrand() == '+' && !minusStranMods.contains(key2.getModification())) {
                this.simplexBaseModfications.add(key2.getModification());
            }
            this.simplexBaseModfications.add("NONE_" + key2.getCanonicalBase());
        }
    }

    public AlignmentTrack.ExperimentType inferType() {
        if (this.inferredType == null) {
            try {
                ReadStats readStats = new ReadStats();
                List<Alignment> sample = AlignmentUtils.firstAlignments(this.reader, 100);
                for (Alignment a : sample) {
                    readStats.addAlignment(a);
                }
                this.inferredType = readStats.inferType();
                if (this.inferredType == AlignmentTrack.ExperimentType.THIRD_GEN) {
                    return this.inferredType;
                }
                readStats = new ReadStats();
                sample = AlignmentUtils.firstAlignments(this.reader, 2000);
                for (Alignment a : sample) {
                    readStats.addAlignment(a);
                }
                this.inferredType = readStats.inferType();
                return this.inferredType;
            }
            catch (Exception e) {
                log.error("Error inferring alignment type", e);
                this.inferredType = AlignmentTrack.ExperimentType.UNKOWN;
            }
        }
        return this.inferredType;
    }

    private AlignmentTrack.ExperimentType getExperimentType() {
        return this.alignmentTrack == null ? null : this.alignmentTrack.getExperimentType();
    }

    public PackedAlignments getGroups(AlignmentInterval interval, AlignmentTrack.RenderOptions renderOptions) {
        if (interval != null) {
            return interval.getPackedAlignments();
        }
        return null;
    }

    public void clear() {
        this.intervalCache.clear();
    }

    public void dumpAlignments() {
        for (AlignmentInterval interval : this.intervalCache) {
            interval.dumpAlignments();
        }
    }

    public PackedAlignments getGroupedAlignmentsContaining(double position, ReferenceFrame frame) {
        String chr = frame.getChrName();
        int start = (int)position;
        int end = start + 1;
        AlignmentInterval interval = this.getLoadedInterval(frame);
        if (interval == null) {
            return null;
        }
        PackedAlignments packedAlignments = interval.getPackedAlignments();
        if (packedAlignments != null && packedAlignments.contains(chr, start, end)) {
            return packedAlignments;
        }
        return null;
    }

    public int getNLevels() {
        int nLevels = 0;
        for (AlignmentInterval interval : this.intervalCache) {
            PackedAlignments packedAlignments = interval.getPackedAlignments();
            if (packedAlignments == null) continue;
            int intervalNLevels = packedAlignments.getNLevels();
            nLevels = Math.max(nLevels, intervalNLevels);
        }
        return nLevels;
    }

    public int getMaxGroupCount() {
        int groupCount = 0;
        for (AlignmentInterval interval : this.intervalCache) {
            PackedAlignments packedAlignments;
            if (interval == null || (packedAlignments = interval.getPackedAlignments()) == null) continue;
            groupCount = Math.max(groupCount, packedAlignments.size());
        }
        return groupCount;
    }

    private void dispose() {
        if (this.loader != null) {
            try {
                this.loader.close();
            }
            catch (IOException ex) {
                log.error("Error closing AlignmentQueryReader. ", ex);
            }
        }
    }

    public void updatePEStats(AlignmentTrack.RenderOptions renderOptions) {
        if (this.peStats != null) {
            for (PEStats stats : this.peStats.values()) {
                stats.computeInsertSize(renderOptions.getMinInsertSizePercentile(), renderOptions.getMaxInsertSizePercentile());
            }
        }
    }

    public void alleleThresholdChanged() {
        this.coverageTrack.setSnpThreshold(PreferencesManager.getPreferences().getAsFloat("SAM.ALLELE_THRESHOLD"));
    }

    public boolean isPhased() {
        return this.getLoader().isPhased();
    }

    public Collection<AlignmentInterval> getLoadedIntervals() {
        return this.intervalCache;
    }

    public Set<String> getSimplexBaseModifications() {
        return this.simplexBaseModfications;
    }

    public static class DownsampleOptions {
        private boolean downsample;
        private int sampleWindowSize;
        private int maxReadCount;

        public DownsampleOptions() {
            IGVPreferences prefs = PreferencesManager.getPreferences();
            this.init(prefs.getAsBoolean("SAM.DOWNSAMPLE_READS"), prefs.getAsInt("SAM.SAMPLING_WINDOW"), prefs.getAsInt("SAM.MAX_LEVELS"));
        }

        DownsampleOptions(boolean downsample, int sampleWindowSize, int maxReadCount) {
            this.init(downsample, sampleWindowSize, maxReadCount);
        }

        private void init(boolean downsample, int sampleWindowSize, int maxReadCount) {
            this.downsample = downsample;
            this.sampleWindowSize = sampleWindowSize;
            this.maxReadCount = maxReadCount;
        }

        public boolean isDownsample() {
            return this.downsample;
        }

        public int getSampleWindowSize() {
            return this.sampleWindowSize;
        }

        public int getMaxReadCount() {
            return this.maxReadCount;
        }
    }
}

