/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.fasta;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.Globals;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.GenomeImporter;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.ParsingUtils;

public class FastaIndex {
    static Logger log = LogManager.getLogger(FastaIndex.class);
    private final LinkedHashMap<String, FastaSequenceIndexEntry> sequenceEntries = new LinkedHashMap();

    public FastaIndex(String indexPath) throws IOException {
        this.parseIndexFile(indexPath);
    }

    public Set<String> getSequenceNames() {
        return this.sequenceEntries.keySet();
    }

    public FastaSequenceIndexEntry getIndexEntry(String name) {
        return this.sequenceEntries.get(name);
    }

    public int getSequenceSize(String name) {
        FastaSequenceIndexEntry entry = this.sequenceEntries.get(name);
        return entry == null ? -1 : (int)entry.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseIndexFile(String indexFile) throws IOException {
        try (BufferedReader reader = null;){
            String nextLine;
            reader = ParsingUtils.openBufferedReader(indexFile);
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = Globals.singleTabMultiSpacePattern.split(nextLine);
                int nTokens = tokens.length;
                if (nTokens != 5) {
                    log.warn("Skipping fasta index line: " + nextLine);
                    continue;
                }
                String contig = tokens[0];
                contig = GenomeImporter.SEQUENCE_NAME_SPLITTER.split(contig, 2)[0];
                long size = Long.parseLong(tokens[1]);
                long location = Long.parseLong(tokens[2]);
                int basesPerLine = Integer.parseInt(tokens[3]);
                int bytesPerLine = Integer.parseInt(tokens[4]);
                this.add(new FastaSequenceIndexEntry(contig, location, size, basesPerLine, bytesPerLine));
            }
            if (this.sequenceEntries.size() == 0) {
                throw new RuntimeException("No sequences found in " + indexFile);
            }
        }
    }

    private void add(FastaSequenceIndexEntry indexEntry) {
        FastaSequenceIndexEntry ret = this.sequenceEntries.put(indexEntry.getContig(), indexEntry);
        if (ret != null) {
            throw new RuntimeException("Contig '" + indexEntry.getContig() + "' already exists in fasta index.");
        }
    }

    public List<Chromosome> getChromosomes() {
        int i = 0;
        ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>();
        for (Map.Entry<String, FastaSequenceIndexEntry> e : this.sequenceEntries.entrySet()) {
            int length = e.getValue() == null ? -1 : (int)e.getValue().getSize();
            chromosomes.add(new Chromosome(i++, e.getKey(), length));
        }
        return chromosomes;
    }

    public static class FastaSequenceIndexEntry {
        private String contig;
        private long position;
        private long size;
        private int basesPerLine;
        private int bytesPerLine;

        public FastaSequenceIndexEntry(String contig, long position, long size, int basesPerLine, int bytesPerLine) {
            this.contig = contig;
            this.position = position;
            this.size = size;
            this.basesPerLine = basesPerLine;
            this.bytesPerLine = bytesPerLine;
        }

        public String getContig() {
            return this.contig;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.size;
        }

        public int getBasesPerLine() {
            return this.basesPerLine;
        }

        public int getBytesPerLine() {
            return this.bytesPerLine;
        }

        public String toString() {
            return String.format("contig %s; position %d; size %d; basesPerLine %d; bytesPerLine %d", this.contig, this.position, this.size, this.basesPerLine, this.bytesPerLine);
        }
    }
}

