/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import org.broad.igv.feature.CytoBandFileParser;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.genome.CytobandSource;
import org.broad.igv.util.ParsingUtils;

public class CytobandMap
implements CytobandSource {
    private LinkedHashMap<String, List<Cytoband>> cytobandMap;

    CytobandMap(String path) {
        try {
            this.init(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CytobandMap(LinkedHashMap<String, List<Cytoband>> cytobandMap) {
        this.cytobandMap = cytobandMap;
    }

    void init(String path) throws IOException {
        try (BufferedReader br = ParsingUtils.openBufferedReader(path);){
            this.cytobandMap = CytoBandFileParser.loadData(br);
        }
    }

    @Override
    public List<Cytoband> getCytobands(String chr) {
        return this.cytobandMap.get(chr);
    }

    @Override
    public String[] getChromosomeNames() {
        return this.cytobandMap.keySet().toArray(new String[0]);
    }
}

