/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.util.ParsingUtils;

public class ChromSizesUtils {
    public static void main(String[] args) throws IOException {
        String genomeListFile = "genomes/genomes.tab";
        String outputDirectory = "genomes/sizes";
        ChromSizesUtils.updateChromSizes(genomeListFile, new File(outputDirectory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChromSizes(String genomeListPath, File directory) throws IOException {
        try (BufferedReader br = null;){
            String nextLine;
            br = ParsingUtils.openBufferedReader(genomeListPath);
            while ((nextLine = br.readLine()) != null) {
                String genomeID;
                String pre;
                File outputFile;
                String[] tokens = nextLine.split("\t");
                if (tokens.length <= 2 || (outputFile = new File(directory, (pre = (genomeID = tokens[2]).replace("/", "_")) + ".chrom.sizes")).exists()) continue;
                System.out.println("Updating " + genomeID);
                String genomePath = tokens[1];
                try {
                    Genome genome = GenomeManager.getInstance().loadGenome(genomePath);
                    System.out.println(genome.getId());
                    ChromSizesUtils.exportChromSizes(directory, genome);
                }
                catch (Exception e) {
                    System.err.println(e.toString());
                }
            }
            System.out.println("Done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportChromSizes(File directory, Genome genome) throws FileNotFoundException {
        String pre = genome.getId().replace("/", "_");
        String fn = pre + ".chrom.sizes";
        File file = new File(directory, fn);
        try (PrintWriter pw = null;){
            pw = new PrintWriter(file);
            for (String chr : genome.getChromosomeNames()) {
                Chromosome chromosome = genome.getChromosome(chr);
                pw.println(chromosome.getName() + "\t" + chromosome.getLength());
            }
        }
    }
}

