/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.basepair;

import htsjdk.tribble.readers.AsciiLineReader;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.basepair.BasePairData;
import org.broad.igv.feature.basepair.BasePairFeature;
import org.broad.igv.feature.basepair.BasePairTrack;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;

public class BasePairFileParser {
    static Logger log = LogManager.getLogger(BasePairFileParser.class);

    public static void loadData(ResourceLocator locator, Genome genome, BasePairData basePairData, BasePairTrack.RenderOptions renderOptions) {
        AsciiLineReader reader = null;
        String nextLine = null;
        int rowCounter = 0;
        ArrayList<String> colors = new ArrayList<String>();
        ArrayList<String> colorLabels = new ArrayList<String>();
        try {
            reader = ParsingUtils.openAsciiReader(locator);
            nextLine = reader.readLine();
            ++rowCounter;
            if (nextLine.substring(0, 6).equals("color:")) {
                String[] tokens;
                while (nextLine.substring(0, 6).equals("color:")) {
                    tokens = Globals.whitespacePattern.split(nextLine, -1);
                    int r = Integer.parseInt(tokens[1]);
                    int g = Integer.parseInt(tokens[2]);
                    int b = Integer.parseInt(tokens[3]);
                    String label = "";
                    try {
                        label = StringUtils.join(Arrays.copyOfRange(tokens, 4, tokens.length), " ");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    Color color = new Color(r, g, b, 255);
                    colors.add(ColorUtilities.colorToString(color));
                    colorLabels.add(label);
                    nextLine = reader.readLine();
                    ++rowCounter;
                }
                while (nextLine != null) {
                    tokens = Globals.whitespacePattern.split(nextLine, -1);
                    String chr = genome == null ? tokens[0] : genome.getCanonicalChrName(tokens[0]);
                    int startLeftNuc = Integer.parseInt(tokens[1]) - 1;
                    int startRightNuc = Integer.parseInt(tokens[2]) - 1;
                    int endLeftNuc = Integer.parseInt(tokens[3]) - 1;
                    int endRightNuc = Integer.parseInt(tokens[4]) - 1;
                    int colorIndex = Integer.parseInt(tokens[5]);
                    BasePairFeature feature = startLeftNuc <= endRightNuc ? new BasePairFeature(chr, Math.min(startLeftNuc, startRightNuc), Math.max(startLeftNuc, startRightNuc), Math.min(endLeftNuc, endRightNuc), Math.max(endLeftNuc, endRightNuc), colorIndex) : new BasePairFeature(chr, Math.min(endLeftNuc, endRightNuc), Math.max(endLeftNuc, endRightNuc), Math.min(startLeftNuc, startRightNuc), Math.max(startLeftNuc, startRightNuc), colorIndex);
                    basePairData.addFeature(feature);
                    nextLine = reader.readLine();
                    ++rowCounter;
                }
            }
            renderOptions.setColors(colors);
            renderOptions.setColorLabels(colorLabels);
            basePairData.finish();
        }
        catch (Exception e) {
            log.error("Error parsing base pair file", e);
            if (nextLine != null && rowCounter != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, rowCounter, nextLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

