/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import com.jidesoft.utils.SortedList;
import htsjdk.tribble.Feature;
import htsjdk.tribble.NamedFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.IGVNamedFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.aa.AminoAcidManager;
import org.broad.igv.feature.aa.Codon;
import org.broad.igv.feature.aa.CodonTable;
import org.broad.igv.feature.aa.CodonTableManager;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.SequenceTrack;

public class FeatureDB {
    private static Logger log = LogManager.getLogger(FeatureDB.class);
    private static Map<String, List<NamedFeature>> featureMap = Collections.synchronizedSortedMap(new TreeMap());
    private static final int MAX_DUPLICATE_COUNT = 20;

    public static void addFeature(NamedFeature feature, Genome genome) {
        String name = feature.getName();
        if (name != null && name.length() > 0 && !name.equals(".")) {
            FeatureDB.put(name, feature, genome);
        }
        if (feature instanceof BasicFeature) {
            BasicFeature igvFeature = (BasicFeature)feature;
            String id = igvFeature.getIdentifier();
            if (id != null && id.length() > 0) {
                FeatureDB.put(id, feature, genome);
            }
            FeatureDB.addByAttributes(igvFeature, genome);
            List<Exon> exons = igvFeature.getExons();
            if (exons != null) {
                for (Exon exon : exons) {
                    FeatureDB.addByAttributes(exon, genome);
                }
            }
        }
    }

    private static void addByAttributes(IGVFeature igvFeature, Genome genome) {
        List<String> attributeKeys = igvFeature.getAttributeKeys();
        for (String key : attributeKeys) {
            String value = igvFeature.getAttribute(key);
            if (value.length() >= 50) continue;
            FeatureDB.put(value, igvFeature, genome);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean put(String name, NamedFeature feature, Genome genome) {
        String key = name.toUpperCase();
        if (!Globals.isHeadless()) {
            Genome currentGenome;
            Genome genome2 = currentGenome = genome != null ? genome : GenomeManager.getInstance().getCurrentGenome();
            if (currentGenome != null && currentGenome.getChromosome(feature.getChr()) == null) {
                return false;
            }
        }
        Map<String, List<NamedFeature>> map = featureMap;
        synchronized (map) {
            List<NamedFeature> currentList = featureMap.get(key);
            if (currentList == null) {
                SortedList newList = new SortedList(new ArrayList(), (Comparator)FeatureComparator.get(true));
                boolean added = newList.add(feature);
                if (added) {
                    featureMap.put(key, (List<NamedFeature>)newList);
                }
                return added;
            }
            if (currentList.size() > 20) {
                return false;
            }
            return currentList.add(feature);
        }
    }

    public static void addFeature(String name, IGVNamedFeature feature, Genome genome) {
        FeatureDB.put(name.toUpperCase(), feature, genome);
    }

    private FeatureDB() {
    }

    public static void addFeatures(List<Feature> features, Genome genome) {
        for (Feature feature : features) {
            if (!(feature instanceof IGVFeature)) continue;
            FeatureDB.addFeature((IGVFeature)feature, genome);
        }
    }

    public static void clearFeatures() {
        featureMap.clear();
    }

    static int size() {
        return featureMap.size();
    }

    public static NamedFeature getFeature(String name) {
        String nm = name.trim().toUpperCase();
        List<NamedFeature> features = featureMap.get(nm);
        if (features != null) {
            return features.get(0);
        }
        return null;
    }

    static Map<String, List<IGVNamedFeature>> getFeaturesMap(String name) {
        String nm = name.trim().toUpperCase();
        SortedMap treeMap = (SortedMap)featureMap;
        return treeMap.subMap(nm, nm + "\uffff");
    }

    public static List<IGVNamedFeature> getFeaturesList(String name, int limit) {
        return FeatureDB.getFeaturesList(name, limit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IGVNamedFeature> getFeaturesList(String name, int limit, boolean longestOnly) {
        Map<String, List<NamedFeature>> map = featureMap;
        synchronized (map) {
            Map<String, List<IGVNamedFeature>> resultMap = FeatureDB.getFeaturesMap(name);
            Set<String> names = resultMap.keySet();
            Iterator<String> nameIter = names.iterator();
            ArrayList<IGVNamedFeature> features = new ArrayList<IGVNamedFeature>(Math.min(limit, names.size()));
            for (int ii = 0; nameIter.hasNext() && ii < limit; ++ii) {
                List<IGVNamedFeature> subFeats = resultMap.get(nameIter.next());
                if (longestOnly) {
                    features.add(subFeats.get(0));
                    continue;
                }
                features.addAll(subFeats);
            }
            return features;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, BasicFeature> getMutationAA(String name, int proteinPosition, String refAA, String mutAA, Genome currentGenome) {
        String nm = name.toUpperCase();
        if (!Globals.isHeadless() && currentGenome == null) {
            currentGenome = GenomeManager.getInstance().getCurrentGenome();
        }
        HashMap<Integer, BasicFeature> results = new HashMap<Integer, BasicFeature>();
        List<NamedFeature> possibles = featureMap.get(nm);
        if (possibles != null) {
            Map<String, List<NamedFeature>> map = featureMap;
            synchronized (map) {
                for (NamedFeature f : possibles) {
                    Set<String> snps;
                    CodonTable codonTable;
                    BasicFeature bf;
                    Codon c;
                    if (!(f instanceof BasicFeature) || (c = (bf = (BasicFeature)f).getCodon(currentGenome, bf.getChr(), proteinPosition)) == null || !c.getAminoAcid().equalsByName(refAA) || (codonTable = CodonTableManager.getInstance().getCodonTableForChromosome(currentGenome.getId(), bf.getChr())) == null || (snps = AminoAcidManager.getInstance().getMappingSNPs(c.getSequence(), AminoAcidManager.getAminoAcidByName(mutAA), codonTable)).size() < 1) continue;
                    results.put(c.getGenomePositions()[0], bf);
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, BasicFeature> getMutationNT(String name, int startPosition, String refNT, Genome currentGenome) {
        String nm = name.toUpperCase();
        if (!Globals.isHeadless() && currentGenome == null) {
            currentGenome = GenomeManager.getInstance().getCurrentGenome();
        }
        HashMap<Integer, BasicFeature> results = new HashMap<Integer, BasicFeature>();
        List<NamedFeature> possibles = featureMap.get(nm);
        String brefNT = refNT.toUpperCase();
        if (possibles != null) {
            Map<String, List<NamedFeature>> map = featureMap;
            synchronized (map) {
                for (NamedFeature f : possibles) {
                    byte[] nuclSequence;
                    if (!(f instanceof BasicFeature)) continue;
                    BasicFeature bf = (BasicFeature)f;
                    int genomePosition = bf.featureToGenomePosition(new int[]{startPosition - 1})[0];
                    if (genomePosition < 0 || (nuclSequence = currentGenome.getSequence(bf.getChr(), genomePosition, genomePosition + 1)) == null) continue;
                    String tempNT = new String(nuclSequence);
                    if (bf.getStrand() == Strand.NEGATIVE) {
                        tempNT = SequenceTrack.getReverseComplement(tempNT);
                    }
                    if (!tempNT.toUpperCase().equals(brefNT)) continue;
                    results.put(genomePosition, bf);
                }
            }
        }
        return results;
    }

    private static class FeatureComparator
    implements Comparator<Feature> {
        private boolean descending;
        private static FeatureComparator ascending_instance;
        private static FeatureComparator descending_instance;

        public static FeatureComparator get(boolean descending) {
            FeatureComparator instance;
            if (descending) {
                if (ascending_instance == null) {
                    ascending_instance = new FeatureComparator(descending);
                }
                instance = ascending_instance;
            } else {
                if (descending_instance == null) {
                    descending_instance = new FeatureComparator(descending);
                }
                instance = descending_instance;
            }
            return instance;
        }

        private FeatureComparator(boolean reverse) {
            this.descending = reverse;
        }

        @Override
        public int compare(Feature feat1, Feature feat2) {
            int nameLen2;
            int nameLen1 = feat1.getChr().length();
            if (nameLen1 != (nameLen2 = feat2.getChr().length())) {
                return nameLen1 - nameLen2;
            }
            int len1 = feat1.getEnd() - feat1.getStart();
            int len2 = feat2.getEnd() - feat2.getStart();
            int toRet = !this.descending ? len1 - len2 : len2 - len1;
            return toRet;
        }
    }
}

