/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import java.io.BufferedReader;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.FeatureCodecParser;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public abstract class AbstractFeatureParser
implements FeatureParser {
    private static Logger log = LogManager.getLogger(IGV.class);
    protected int startBase = 0;
    boolean gffTags = false;
    protected TrackProperties trackProperties = null;

    public static boolean canParse(ResourceLocator locator) {
        return CodecFactory.getCodec(locator, null) != null;
    }

    public static FeatureParser getInstanceFor(ResourceLocator locator, Genome genome) {
        FeatureCodec codec = CodecFactory.getCodec(locator, genome);
        if (codec != null && codec instanceof AsciiFeatureCodec) {
            return new FeatureCodecParser((AsciiFeatureCodec)codec, genome);
        }
        return null;
    }

    @Override
    public List<Feature> loadFeatures(BufferedReader reader, Genome genome) {
        return this.loadFeatures(reader, genome, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Feature> loadFeatures(BufferedReader reader, Genome genome, int maxLines) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String nextLine = null;
        int maxLogErrors = 10;
        int nErrors = 0;
        int nLines = 0;
        try {
            while ((nextLine = reader.readLine()) != null) {
                if ((nextLine = nextLine.trim()).length() == 0) continue;
                if (maxLines <= 0 || ++nLines <= maxLines) {
                    try {
                        Feature feature;
                        String[] tokens;
                        if (nextLine.startsWith("#type")) {
                            tokens = Globals.equalPattern.split(nextLine);
                            if (tokens.length <= 1) continue;
                            try {
                                TrackType trackType = TrackType.valueOf(tokens[1]);
                            }
                            catch (Exception e) {
                                log.error("Error converting track type: " + tokens[1]);
                            }
                            continue;
                        }
                        if (nextLine.startsWith("#track") || nextLine.startsWith("track")) {
                            TrackProperties tp = new TrackProperties();
                            ParsingUtils.parseTrackLine(nextLine, tp);
                            this.setTrackProperties(tp);
                            if (!tp.isGffTags()) continue;
                            this.gffTags = true;
                            continue;
                        }
                        if (nextLine.startsWith("#coords")) {
                            try {
                                tokens = Globals.equalPattern.split(nextLine);
                                this.startBase = Integer.parseInt(tokens[1]);
                            }
                            catch (Exception e) {
                                log.error("Error parsing coords line: " + nextLine, e);
                            }
                            continue;
                        }
                        if (nextLine.startsWith("#gffTags")) {
                            this.gffTags = true;
                            continue;
                        }
                        if (nextLine.startsWith("#") || (feature = this.parseLine(nextLine)) == null) continue;
                        features.add(feature);
                    }
                    catch (NumberFormatException e) {
                        if (nErrors < maxLogErrors) {
                            log.error("Number format error parsing line: " + nextLine, e);
                        }
                        ++nErrors;
                    }
                    continue;
                }
                break;
            }
        }
        catch (EOFException e) {
            return features;
        }
        catch (Exception e) {
            if (nextLine != null && nLines != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, nLines, nextLine);
            }
            throw new RuntimeException(e);
        }
        FeatureDB.addFeatures(features, genome);
        return features;
    }

    protected abstract Feature parseLine(String var1);

    protected void setTrackProperties(TrackProperties trackProperties) {
        this.trackProperties = trackProperties;
    }

    @Override
    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }
}

