/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.encode;

import com.jidesoft.swing.JideBoxLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.NumberFormatter;
import org.broad.igv.Globals;
import org.broad.igv.encode.EncodeFileRecord;
import org.broad.igv.encode.EncodeTableModel;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.IGVDialog;
import org.broad.igv.ui.action.BrowseEncodeAction;
import org.broad.igv.util.Pair;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class EncodeTrackChooser
extends IGVDialog {
    private static Logger log = LogManager.getLogger(EncodeTrackChooser.class);
    private static Map<String, EncodeTrackChooser> instanceMap = Collections.synchronizedMap(new HashMap());
    private static NumberFormatter numberFormatter = new NumberFormatter();
    private static String ENCODE_HOST = "https://www.encodeproject.org";
    private static Set<String> filteredColumns = new HashSet<String>(Arrays.asList("ID", "Assembly", "HREF", "path"));
    private static List<String> filteredExtensions = Arrays.asList("tsv", "tsv.gz");
    private static Map<String, String> speciesNames = Map.of("ce10", "Caenorhabditis elegans", "ce11", "Caenorhabditis elegans", "dm3", "Drosophila melanogaster", "dm6", "Drosophila melanogaster", "GRCh38", "Homo sapiens", "hg19", "Homo sapiens", "mm10", "Mus musculus", "mm9", "Mus musculus");
    static HashSet<String> ucscSupportedGenomes = new HashSet<String>(Arrays.asList("hg19", "mm9"));
    static HashSet<String> supportedGenomes = new HashSet<String>(Arrays.asList("ce10", "ce11", "dm3", "dm6", "GRCh38", "hg19", "mm10", "mm9"));
    JTable table;
    JTextField filterTextField;
    JLabel rowCountLabel;
    EncodeTableModel model;
    private boolean canceled;

    public static synchronized EncodeTrackChooser getInstance(String genomeId, BrowseEncodeAction.Type type) throws IOException {
        String encodeGenomeId = EncodeTrackChooser.getEncodeGenomeID(genomeId);
        String key = encodeGenomeId + type.toString();
        EncodeTrackChooser instance = instanceMap.get(key);
        if (instance == null) {
            Pair<List<String>, List<EncodeFileRecord>> records = EncodeTrackChooser.getEncodeFileRecords(encodeGenomeId, type);
            if (records == null) {
                return null;
            }
            Frame parent = IGV.hasInstance() ? IGV.getInstance().getMainFrame() : null;
            List<String> headings = records.getFirst();
            List<EncodeFileRecord> rows = records.getSecond();
            String title = EncodeTrackChooser.getDialogTitle(genomeId, type);
            instance = new EncodeTrackChooser(parent, new EncodeTableModel(headings, rows), title);
            instanceMap.put(key, instance);
        }
        return instance;
    }

    private static String getDialogTitle(String genomeId, BrowseEncodeAction.Type type) {
        if (type == BrowseEncodeAction.Type.UCSC) {
            return "ENCODE data hosted at UCSC (2012)";
        }
        switch (type) {
            case SIGNALS_CHIP: {
                return "ENCODE CHiP Seq - Signals";
            }
            case SIGNALS_OTHER: {
                return "ENCODE Non CHiP Data - Signals";
            }
        }
        return "ENCODE";
    }

    public static boolean genomeSupportedUCSC(String genomeId) {
        return genomeId != null && ucscSupportedGenomes.contains(EncodeTrackChooser.getEncodeGenomeID(genomeId));
    }

    public static boolean genomeSupported(String genomeId) {
        return genomeId != null && supportedGenomes.contains(EncodeTrackChooser.getEncodeGenomeID(genomeId));
    }

    private static String getEncodeGenomeID(String genomeId) {
        switch (genomeId) {
            case "hg38": 
            case "hg38_1kg": {
                return "GRCh38";
            }
            case "b37": 
            case "1kg_v37": {
                return "hg19";
            }
        }
        return genomeId;
    }

    private static Pair<List<String>, List<EncodeFileRecord>> getEncodeFileRecords(String genomeId, BrowseEncodeAction.Type type) throws IOException {
        try (InputStream is = EncodeTrackChooser.getStreamFor(genomeId, type);){
            if (is == null) {
                Pair<List<String>, List<EncodeFileRecord>> pair = null;
                return pair;
            }
            Pair pair = EncodeTrackChooser.parseRecords(is, type, genomeId);
            return pair;
        }
    }

    private static InputStream getStreamFor(String genomeId, BrowseEncodeAction.Type type) throws IOException {
        if (type == BrowseEncodeAction.Type.UCSC) {
            return EncodeTrackChooser.class.getResourceAsStream("encode." + genomeId + ".txt");
        }
        String root = PreferencesManager.getPreferences().get("ENCODE_FILELIST_URL") + genomeId + ".";
        String url = null;
        switch (type) {
            case SIGNALS_CHIP: {
                url = root + "signals.chip.txt";
                break;
            }
            case SIGNALS_OTHER: {
                url = root + "signals.other.txt";
                break;
            }
            case OTHER: {
                url = root + "other.txt";
            }
        }
        if (url == null) {
            throw new RuntimeException("Unknown encode data collection type: " + String.valueOf((Object)type));
        }
        return ParsingUtils.openInputStream(url);
    }

    private static Pair parseRecords(InputStream is, BrowseEncodeAction.Type type, String genomeId) throws IOException {
        String nextLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String[] headers = Globals.tabPattern.split(reader.readLine());
        int pathColumn = type == BrowseEncodeAction.Type.UCSC ? 0 : Arrays.asList(headers).indexOf("HREF");
        ArrayList<EncodeFileRecord> records = new ArrayList<EncodeFileRecord>(20000);
        while ((nextLine = reader.readLine()) != null) {
            String path;
            if (nextLine.startsWith("#")) continue;
            String[] tokens = Globals.tabPattern.split(nextLine, -1);
            String string = path = type == BrowseEncodeAction.Type.UCSC ? tokens[pathColumn] : ENCODE_HOST + tokens[pathColumn];
            if (filteredExtensions.stream().anyMatch(e -> path.endsWith((String)e))) continue;
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            for (int i = 0; i < headers.length; ++i) {
                String value;
                String string2 = value = i < tokens.length ? tokens[i] : "";
                if (value.length() <= 0) continue;
                attributes.put(headers[i], EncodeTrackChooser.shortenField(value, genomeId));
            }
            EncodeFileRecord record = new EncodeFileRecord(path, attributes);
            records.add(record);
        }
        List filteredHeaders = Arrays.stream(headers).filter(h -> !filteredColumns.contains(h)).collect(Collectors.toList());
        return new Pair(filteredHeaders, records);
    }

    private static String shortenField(String value, String genomeId) {
        String species = speciesNames.get(genomeId);
        return species == null ? value : value.replace("(" + species + ")", "").replace(species, "").trim();
    }

    private EncodeTrackChooser(Frame owner, EncodeTableModel model, String title) {
        super(owner);
        this.setTitle(title);
        this.model = model;
        this.setModal(true);
        this.initComponents(owner);
        this.init(model);
    }

    private void init(EncodeTableModel model) {
        this.setModal(true);
        this.table.setAutoCreateRowSorter(true);
        this.table.setModel(model);
        this.table.setRowSorter(model.getSorter());
        try {
            this.rowCountLabel.setText(numberFormatter.valueToString(this.table.getRowCount()) + " rows");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                EncodeTrackChooser.this.updateFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EncodeTrackChooser.this.updateFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EncodeTrackChooser.this.updateFilter();
            }
        });
    }

    private void updateFilter() {
        RegexFilter rf = null;
        try {
            rf = new RegexFilter(this.filterTextField.getText());
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.model.getSorter().setRowFilter(rf);
        try {
            this.rowCountLabel.setText(numberFormatter.valueToString(this.table.getRowCount()) + " rows");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void loadButtonActionPerformed(ActionEvent e) {
        this.canceled = false;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.canceled = true;
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private Set<String> getLoadedPaths() {
        if (!IGV.hasInstance()) {
            return new HashSet<String>();
        }
        Set<ResourceLocator> locators = IGV.getInstance().getDataResourceLocators();
        HashSet<String> loadedPaths = new HashSet<String>(locators.size());
        for (ResourceLocator locator : locators) {
            loadedPaths.add(locator.getPath());
        }
        return loadedPaths;
    }

    public List<EncodeFileRecord> getSelectedRecords() throws IOException {
        ArrayList<EncodeFileRecord> selectedRecords = new ArrayList<EncodeFileRecord>();
        List<EncodeFileRecord> allRecords = this.model.getRecords();
        int rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int modelIdx = this.table.convertRowIndexToModel(i);
            EncodeFileRecord record = allRecords.get(modelIdx);
            if (!record.isSelected()) continue;
            selectedRecords.add(record);
            record.setSelected(false);
        }
        return selectedRecords;
    }

    private void initComponents(Frame owner) {
        this.table = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                if (realColumnIndex > 0) {
                    return this.getModel().getValueAt(rowIndex, realColumnIndex).toString();
                }
                return null;
            }
        };
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel dialogPane = new JPanel();
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        dialogPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(0, 10));
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setViewportView(this.table);
        contentPanel.add((Component)scrollPane1, "Center");
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout((LayoutManager)new JideBoxLayout((Container)filterPanel, 0, 5));
        JLabel filterLabel = new JLabel("Filter:");
        String filterToolTip = "Enter multiple filter strings separated by commas.  e.g.  GM12878, ChipSeq";
        filterLabel.setToolTipText("Enter multiple filter strings separated by commas.  e.g.  GM12878, ChipSeq");
        filterPanel.add((Component)filterLabel, "fix");
        this.filterTextField = new JTextField();
        this.filterTextField.setToolTipText("Enter multiple filter strings separated by commas.  e.g.  GM12878, ChipSeq");
        filterPanel.add((Component)this.filterTextField, "vary");
        this.rowCountLabel = new JLabel();
        this.rowCountLabel.setHorizontalAlignment(4);
        JPanel rowCountPanel = new JPanel();
        rowCountPanel.setLayout((LayoutManager)new JideBoxLayout((Container)rowCountPanel, 0, 0));
        rowCountPanel.setPreferredSize(new Dimension(100, 28));
        rowCountPanel.add((Component)this.rowCountLabel, "vary");
        filterPanel.add((Component)rowCountPanel, "fix");
        contentPanel.add((Component)filterPanel, "North");
        dialogPane.add((Component)contentPanel, "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        JButton okButton = new JButton("Load");
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(e -> this.loadButtonActionPerformed(e));
        buttonBar.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> this.cancelButtonActionPerformed(e));
        buttonBar.add((Component)cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
        Rectangle ownerBounds = owner.getBounds();
        this.setSize(ownerBounds.width, 620);
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void main(String[] args) throws IOException {
        EncodeTrackChooser.getInstance("hg19", BrowseEncodeAction.Type.UCSC).setVisible(true);
    }

    private class RegexFilter
    extends RowFilter {
        List<Pair<String, Matcher>> matchers;

        RegexFilter(String text) {
            String[] tokens;
            if (text == null) {
                throw new IllegalArgumentException("Pattern must be non-null");
            }
            this.matchers = new ArrayList<Pair<String, Matcher>>();
            for (String t : tokens = Globals.whitespacePattern.split(text)) {
                String column = "*";
                String value = t.trim();
                if (t.contains("=")) {
                    String[] kv = Globals.equalPattern.split(t);
                    if (kv.length > 1) {
                        column = kv[0].trim();
                        value = kv[1].trim();
                    } else {
                        value = kv[0];
                    }
                }
                this.matchers.add(new Pair<String, Matcher>(column, Pattern.compile("(?i)" + value).matcher("")));
            }
        }

        public boolean include(RowFilter.Entry value) {
            for (Pair<String, Matcher> entry : this.matchers) {
                String column = entry.getFirst();
                Matcher matcher = entry.getSecond();
                boolean found = false;
                int nColumns = EncodeTrackChooser.this.table.getColumnCount();
                for (int index = 1; index < nColumns; ++index) {
                    matcher.reset(EncodeTrackChooser.this.table.getColumnName(index).toLowerCase());
                    if (matcher.find()) {
                        found = true;
                        break;
                    }
                    boolean wildcard = column.equals("*");
                    if (!wildcard && !column.equalsIgnoreCase(EncodeTrackChooser.this.table.getColumnName(index))) continue;
                    matcher.reset(value.getStringValue(index));
                    if (!matcher.find()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }
}

