/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.blast;

import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Strand;

public class BlastMapping
extends BasicFeature {
    private Block queryBlock;
    private Block subjectBlock;

    public BlastMapping(Block queryBlock, Block subjectBlock, float percentIden) {
        this.queryBlock = queryBlock;
        this.subjectBlock = subjectBlock;
        this.setStart(Math.min(queryBlock.getStart(), queryBlock.getEnd()));
        this.setEnd(Math.max(queryBlock.getStart(), queryBlock.getEnd()));
        this.setName("[" + subjectBlock.getContig() + ":" + subjectBlock.getStart() + "-" + subjectBlock.getEnd() + "]");
        this.setScore(percentIden);
    }

    @Override
    public String getChr() {
        return this.queryBlock.getContig();
    }

    @Override
    public Strand getStrand() {
        return this.subjectBlock.getStrand();
    }

    public static class Block {
        private String contig;
        private int start;
        private int end;
        Strand strand;

        public Block(String contig, int start, int end, Strand strand) {
            this.contig = contig;
            this.start = start;
            this.end = end;
            this.strand = strand;
        }

        public String getContig() {
            return this.contig;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public Strand getStrand() {
            return this.strand;
        }

        public boolean containsPosition(String contig, int position) {
            return this.contig.equals(contig) && position >= this.start && position < this.end;
        }
    }
}

