/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.bedpe.BedPEFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class BedPEParser {
    private static Logger log = LogManager.getLogger(BedPEParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static Dataset parse(ResourceLocator locator, Genome genome) throws IOException {
        colorColumn = -1;
        thicknessColumn = -1;
        type = DatasetType.UNKNOWN;
        parsedHeader = true;
        columns = new String[]{"chrom1", "start1", "stop1", "chrom2", "start2", "stop2", "name", "score", "strand1", "strand2"};
        col7isNumeric = true;
        colorCache = new HashMap<String, Color>();
        features = new ArrayList<BedPEFeature>();
        br = null;
        try {
            br = ParsingUtils.openBufferedReader(locator.getPath());
            firstLine = true;
            skippedLineCount = 0;
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("#columns")) {
                    try {
                        t1 = ParsingUtils.WHITESPACE_PATTERN.split(nextLine);
                        if (t1.length != 2) ** GOTO lbl33
                        for (String keyValue : t2 = ParsingUtils.SEMI_COLON_PATTERN.split(t1[1])) {
                            t = keyValue.split("=");
                            if (t[0].equals("color")) {
                                colorColumn = Integer.parseInt(t[1]) - 1;
                                continue;
                            }
                            if (!t[0].equals("thickness")) continue;
                            thicknessColumn = Integer.parseInt(t[1]) - 1;
                        }
                    }
                    catch (NumberFormatException e) {
                        BedPEParser.log.error("Error parsing #column line.", e);
                    }
                } else if (nextLine.trim().equals("#chrom1\tstart1\tstop1\tchrom2\tstart2\tstop2\tname\tqual\tstrand1\tstrand2\tfilters\tinfo")) {
                    type = DatasetType.TENX;
                }
lbl33:
                // 6 sources

                if (nextLine.startsWith("#") || nextLine.startsWith("chr1\tx1\tx2")) {
                    tokens = Globals.tabPattern.split(nextLine);
                    if (tokens.length >= 6) {
                        columns = tokens;
                        for (i = 6; i < columns.length; ++i) {
                            if (columns[i].equalsIgnoreCase("color")) {
                                colorColumn = i;
                                continue;
                            }
                            if (!columns[i].toLowerCase().equalsIgnoreCase("thickness")) continue;
                            thicknessColumn = i;
                        }
                    }
                } else if (nextLine.startsWith("track") || nextLine.startsWith("##track")) {
                    trackProperties = new TrackProperties();
                    ParsingUtils.parseTrackLine(nextLine, trackProperties);
                } else if (firstLine && nextLine.startsWith("chromosome1\tx1\tx2") || nextLine.startsWith("chr1\tx1\tx2")) {
                    columns = Globals.tabPattern.split(nextLine);
                    for (i = 6; i < columns.length; ++i) {
                        if (!columns[i].equalsIgnoreCase("color")) continue;
                        colorColumn = i;
                    }
                } else {
                    tokens = Globals.tabPattern.split(nextLine);
                    if (tokens.length < 6) {
                        if (skippedLineCount >= 5 || ++skippedLineCount != 5) continue;
                        BedPEParser.log.warn("Skipping line: " + nextLine + (skippedLineCount < 5 ? "" : " Further skipped lines will not be logged"));
                        continue;
                    }
                    chr1 = genome == null ? tokens[0] : genome.getCanonicalChrName(tokens[0]);
                    chr2 = genome == null ? tokens[3] : genome.getCanonicalChrName(tokens[3]);
                    start1 = Integer.parseInt(tokens[1]);
                    end1 = Integer.parseInt(tokens[2]);
                    start2 = Integer.parseInt(tokens[4]);
                    end2 = Integer.parseInt(tokens[5]);
                    feature = new BedPEFeature(chr1, start1, end1, chr2, start2, end2);
                    if (tokens.length > 6) {
                        feature.name = tokens[6];
                        col7isNumeric = col7isNumeric != false && BedPEParser.isNumeric(tokens[6]) != false;
                    } else {
                        col7isNumeric = false;
                    }
                    if (tokens.length > 7) {
                        feature.scoreString = tokens[7];
                        try {
                            feature.score = Double.parseDouble(tokens[7]);
                        }
                        catch (NumberFormatException e) {
                            feature.score = 0.0;
                        }
                    }
                    if (tokens.length > 8) {
                        attributes = new LinkedHashMap<String, String>();
                        for (i = 8; i < tokens.length; ++i) {
                            t = tokens[i];
                            v0 = c = columns != null && columns.length > i ? columns[i] : String.valueOf(i);
                            if (c.equals("info") && t.contains("=")) {
                                for (String kvPair : kvPairs = Globals.semicolonPattern.split(tokens[11])) {
                                    kv = Globals.equalPattern.split(kvPair);
                                    if (kv.length <= 1) continue;
                                    attributes.put(kv[0], kv[1]);
                                }
                                continue;
                            }
                            attributes.put(c, t);
                        }
                        feature.attributes = attributes;
                        feature.type = (String)attributes.get("TYPE");
                    }
                    if (colorColumn > 0 && tokens.length > colorColumn) {
                        colorString = tokens[colorColumn];
                        c = (Color)colorCache.get(colorString);
                        if (c == null) {
                            c = ColorUtilities.stringToColor(colorString);
                            colorCache.put(colorString, c);
                        }
                        feature.color = c;
                    }
                    if (thicknessColumn > 0 && tokens.length > thicknessColumn) {
                        feature.thickness = Integer.parseInt(tokens[thicknessColumn]);
                    }
                    features.add(feature);
                }
                firstLine = false;
            }
            if (col7isNumeric) {
                for (BedPEFeature f : features) {
                    f.score = Double.parseDouble(f.name);
                    f.scoreString = f.name;
                    f.name = null;
                }
                if (type == DatasetType.UNKNOWN) {
                    type = DatasetType.CLUSTER;
                }
            }
            var14_18 = new Dataset(type, features);
            return var14_18;
        }
        finally {
            br.close();
        }
    }

    public static boolean isNumeric(String strNum) {
        return strNum.matches("-?\\d+(\\.\\d+)?");
    }

    static enum DatasetType {
        TENX,
        CLUSTER,
        UNKNOWN;

    }

    public static class Dataset {
        public DatasetType type;
        public List<BedPEFeature> features;

        public Dataset(DatasetType type, List<BedPEFeature> features) {
            this.type = type;
            this.features = features;
        }
    }
}

