/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypesContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LazyGenotypesContext
extends GenotypesContext {
    private transient LazyParser parser;
    private transient Object unparsedGenotypeData;
    private int nUnparsedGenotypes;
    private boolean loaded = false;
    private static final ArrayList<Genotype> EMPTY = new ArrayList(0);

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!this.loaded || this.unparsedGenotypeData != null) {
            throw new IllegalStateException("Deserialized LazyGenotypesContext is not fully decoded, but is required to have been fully decoded before serialization");
        }
    }

    public LazyGenotypesContext(LazyParser parser, Object unparsedGenotypeData, int nUnparsedGenotypes) {
        super(EMPTY);
        this.parser = parser;
        this.unparsedGenotypeData = unparsedGenotypeData;
        this.nUnparsedGenotypes = nUnparsedGenotypes;
    }

    @Override
    protected ArrayList<Genotype> getGenotypes() {
        this.decode();
        return this.notToBeDirectlyAccessedGenotypes;
    }

    public void decode() {
        if (!this.loaded) {
            LazyData parsed = this.parser.parse(this.unparsedGenotypeData);
            this.notToBeDirectlyAccessedGenotypes = parsed.genotypes;
            this.sampleNamesInOrder = parsed.sampleNamesInOrder;
            this.sampleNameToOffset = parsed.sampleNameToOffset;
            this.loaded = true;
            this.unparsedGenotypeData = null;
            this.nUnparsedGenotypes = 0;
        }
    }

    @Override
    protected synchronized void ensureSampleNameMap() {
        if (!this.loaded) {
            this.decode();
        } else {
            super.ensureSampleNameMap();
        }
    }

    @Override
    protected synchronized void ensureSampleOrdering() {
        if (!this.loaded) {
            this.decode();
        } else {
            super.ensureSampleOrdering();
        }
    }

    @Override
    protected void invalidateSampleNameMap() {
        if (!this.loaded) {
            this.decode();
        }
        super.invalidateSampleNameMap();
    }

    @Override
    protected void invalidateSampleOrdering() {
        if (!this.loaded) {
            this.decode();
        }
        super.invalidateSampleOrdering();
    }

    @Override
    public boolean isEmpty() {
        return this.loaded ? super.isEmpty() : this.nUnparsedGenotypes == 0;
    }

    @Override
    public int size() {
        return this.loaded ? super.size() : this.nUnparsedGenotypes;
    }

    public Object getUnparsedGenotypeData() {
        return this.unparsedGenotypeData;
    }

    public static interface LazyParser {
        public LazyData parse(Object var1);
    }

    public static class LazyData {
        final ArrayList<Genotype> genotypes;
        final Map<String, Integer> sampleNameToOffset;
        final List<String> sampleNamesInOrder;

        public LazyData(ArrayList<Genotype> genotypes, List<String> sampleNamesInOrder, Map<String, Integer> sampleNameToOffset) {
            this.genotypes = genotypes;
            this.sampleNamesInOrder = sampleNamesInOrder;
            this.sampleNameToOffset = sampleNameToOffset;
        }
    }
}

