/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util.htsget;

import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.htsget.HtsgetClass;
import htsjdk.samtools.util.htsget.HtsgetFormat;
import htsjdk.samtools.util.htsget.HtsgetMalformedResponseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class HtsgetResponse {
    private final HtsgetFormat format;
    private final List<Block> blocks;
    private final String md5;

    public HtsgetResponse(HtsgetFormat format, List<Block> blocks, String md5) {
        this.format = format;
        this.blocks = blocks;
        this.md5 = md5;
    }

    public HtsgetFormat getFormat() {
        return this.format;
    }

    public List<Block> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public String getMd5() {
        return this.md5;
    }

    public static HtsgetResponse parse(String s) {
        JSONObject j = new JSONObject(s);
        JSONObject htsget = j.optJSONObject("htsget");
        if (htsget == null) {
            throw new HtsgetMalformedResponseException("No htsget key found in response");
        }
        String md5Json = htsget.optString("md5", null);
        String formatJson = htsget.optString("format", null);
        JSONArray blocksJson = htsget.optJSONArray("urls");
        if (blocksJson == null) {
            throw new HtsgetMalformedResponseException("No urls field found in Htsget Response");
        }
        List<Block> blocks = IntStream.range(0, blocksJson.length()).mapToObj(arg_0 -> ((JSONArray)blocksJson).getJSONObject(arg_0)).map(Block::parse).collect(Collectors.toList());
        return new HtsgetResponse(formatJson == null ? null : HtsgetFormat.valueOf(formatJson.toUpperCase()), blocks, md5Json);
    }

    public InputStream getDataStream() {
        return new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
            private final Iterator<Block> iterator;
            {
                this.iterator = HtsgetResponse.this.blocks.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return this.iterator.next().getData();
            }
        });
    }

    public static class Block {
        private final URI uri;
        private final Map<String, String> headers;
        private final HtsgetClass dataClass;

        public Block(URI uri, Map<String, String> headers, HtsgetClass dataClass) {
            this.uri = uri;
            this.headers = headers;
            this.dataClass = dataClass;
        }

        public URI getUri() {
            return this.uri;
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(this.headers);
        }

        public HtsgetClass getDataClass() {
            return this.dataClass;
        }

        public InputStream getData() {
            switch (this.getUri().getScheme()) {
                case "http": 
                case "https": {
                    try {
                        HttpURLConnection conn = (HttpURLConnection)this.uri.toURL().openConnection();
                        conn.setRequestMethod("GET");
                        this.headers.forEach(conn::setRequestProperty);
                        conn.connect();
                        return conn.getInputStream();
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException("Could not retrieve data from block", e);
                    }
                }
                case "data": {
                    String dataUri = this.uri.toString();
                    if (!dataUri.matches("^data:.*;base64,.*")) {
                        throw new HtsgetMalformedResponseException("data URI must be base64 encoded: " + dataUri);
                    }
                    return new ByteArrayInputStream(Base64.getDecoder().decode(dataUri.replaceFirst("^data:.*;base64,", "")));
                }
            }
            throw new HtsgetMalformedResponseException("Unrecognized URI scheme in data block: " + this.uri.getScheme());
        }

        public static Block parse(JSONObject blockJson) {
            URI uri;
            String uriJson = blockJson.optString("url", null);
            if (uriJson == null) {
                throw new HtsgetMalformedResponseException("No URI found in Htsget data block: " + blockJson.toString().substring(0, Math.min(100, blockJson.toString().length())));
            }
            try {
                uri = new URI(uriJson);
            }
            catch (URISyntaxException e2) {
                throw new HtsgetMalformedResponseException("Could not parse URI in Htsget data block: " + uriJson, e2);
            }
            String dataClassJson = blockJson.optString("class", null);
            HtsgetClass dataClass = dataClassJson == null ? null : HtsgetClass.valueOf(dataClassJson.toLowerCase());
            JSONObject headersJson = blockJson.optJSONObject("headers");
            Map<String, String> headers = headersJson == null ? null : headersJson.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
            return new Block(uri, headers, dataClass);
        }
    }
}

